/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class AssociationLinkerAnnot
extends AbstractAnnot {
    private static final String PROPERTY_PATH = "propertyPath";
    private static final String TABLE_ALIAS = "tableAlias";
    private final AnnotationValue propertyPath;
    private final AnnotationValue tableAlias;

    AssociationLinkerAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.propertyPath = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)PROPERTY_PATH);
        this.tableAlias = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)TABLE_ALIAS);
    }

    public AnnotationValue getPropertyPath() {
        return this.propertyPath;
    }

    public AnnotationValue getTableAlias() {
        return this.tableAlias;
    }

    public String getPropertyPathValue() {
        String result = AnnotationValueUtil.toString(this.propertyPath);
        if (result == null) {
            throw new AptIllegalStateException(PROPERTY_PATH);
        }
        return result;
    }

    public String getTableAliasValue() {
        String result = AnnotationValueUtil.toString(this.tableAlias);
        if (result == null) {
            throw new AptIllegalStateException(TABLE_ALIAS);
        }
        return result;
    }
}

