/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.doma.EmbeddableTypeImplementation;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.EmbeddableMetamodelGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.generator.ScalarMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.DefaultPropertyType;
import org.seasar.doma.jdbc.entity.EmbeddableType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.Property;

public class EmbeddableTypeGenerator
extends AbstractGenerator {
    private final EmbeddableMeta embeddableMeta;

    public EmbeddableTypeGenerator(RoundContext ctx, ClassName className, Printer printer, EmbeddableMeta embeddableMeta) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)embeddableMeta);
        this.embeddableMeta = embeddableMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    private void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    private void printClass() {
        this.iprint("/** */%n", new Object[0]);
        this.printGenerated();
        this.printEmbeddableTypeImplementation();
        this.iprint("public final class %1$s implements %2$s<%3$s> {%n", this.simpleName, EmbeddableType.class, this.embeddableMeta.getType());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printMethods();
        this.printNestedClass();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    private void printEmbeddableTypeImplementation() {
        this.iprint("@%1$s%n", EmbeddableTypeImplementation.class);
    }

    private void printFields() {
        this.printSingletonField();
    }

    private void printSingletonField() {
        this.iprint("private static final %1$s __singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    private void printMethods() {
        this.printGetEmbeddablePropertyTypesMethod();
        this.printNewEmbeddableMethod();
        this.printGetSingletonInternalMethod();
    }

    private void printGetEmbeddablePropertyTypesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public <ENTITY> %1$s<%2$s<ENTITY, ?>> getEmbeddablePropertyTypes(String embeddedPropertyName, Class<ENTITY> entityClass, %3$s namingType) {%n", List.class, EntityPropertyType.class, NamingType.class);
        this.iprint("    return %1$s.asList(%n", Arrays.class);
        Iterator<EmbeddablePropertyMeta> it = this.embeddableMeta.getEmbeddablePropertyMetas().iterator();
        while (it.hasNext()) {
            EmbeddablePropertyMeta propertyMeta = it.next();
            ScalarMetaFactory.ScalarMeta scalarMeta = propertyMeta.getCtType().accept(new ScalarMetaFactory(), false);
            this.iprint("        new %1$s<ENTITY, %2$s, %3$s>(entityClass, %4$s, embeddedPropertyName + \".%5$s\", \"%6$s\", namingType, %7$s, %8$s, %9$s)", DefaultPropertyType.class, scalarMeta.getBasicType(), scalarMeta.getContainerType(), scalarMeta.getSupplier(), propertyMeta.getName(), propertyMeta.getColumnName(), propertyMeta.isColumnInsertable(), propertyMeta.isColumnUpdatable(), propertyMeta.isColumnQuoteRequired());
            this.print(it.hasNext() ? ",%n" : "", new Object[0]);
        }
        this.print(");%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printNewEmbeddableMethod() {
        if (this.embeddableMeta.getEmbeddablePropertyMetas().stream().anyMatch(p -> p.getCtType().hasTypeParameter())) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public <ENTITY> %1$s newEmbeddable(String embeddedPropertyName, %2$s<String, %3$s<ENTITY, ?>> __args) {%n", this.embeddableMeta.getType(), Map.class, Property.class);
        if (this.embeddableMeta.isAbstract()) {
            this.iprint("    return null;%n", new Object[0]);
        } else {
            this.iprint("    return new %1$s(%n", this.embeddableMeta.getType());
            Iterator<EmbeddablePropertyMeta> it = this.embeddableMeta.getEmbeddablePropertyMetas().iterator();
            while (it.hasNext()) {
                EmbeddablePropertyMeta propertyMeta = it.next();
                this.iprint("        (%1$s)(__args.get(embeddedPropertyName + \".%2$s\") != null ? __args.get(embeddedPropertyName + \".%2$s\").get() : null)", propertyMeta.getBoxedType(), propertyMeta.getName());
                if (!it.hasNext()) continue;
                this.print(",%n", new Object[0]);
            }
            this.print(");%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleName);
        this.iprint("    return __singleton;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printNestedClass() {
        EmbeddableMetamodelGenerator generator = new EmbeddableMetamodelGenerator(this.ctx, this.className, this.printer, this.embeddableMeta);
        generator.generate();
    }
}

