/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Formatter;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.generator.Code;
import org.seasar.doma.internal.util.AssertionUtil;

public class Printer {
    private static final String INDENT_SPACE = "    ";
    private final StringBuilder indentBuffer = new StringBuilder();
    private final RoundContext ctx;
    private final Formatter formatter;

    public Printer(RoundContext ctx, Formatter formatter) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)formatter);
        this.ctx = ctx;
        this.formatter = formatter;
    }

    public void iprint(String format, Object ... args) {
        this.formatter.format(this.indentBuffer.toString(), new Object[0]);
        this.throwExceptionIfNecessary();
        this.convertArgs(args);
        this.formatter.format(format, args);
        this.throwExceptionIfNecessary();
    }

    public void print(String format, Object ... args) {
        this.convertArgs(args);
        this.formatter.format(format, args);
        this.throwExceptionIfNecessary();
    }

    private void convertArgs(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.toCharSequence(args[i]);
        }
    }

    private CharSequence toCharSequence(Object arg) {
        if (arg instanceof CharSequence) {
            return (CharSequence)arg;
        }
        if (arg instanceof Class) {
            return ((Class)arg).getName();
        }
        if (arg instanceof TypeMirror) {
            return this.ctx.getMoreTypes().getTypeName((TypeMirror)arg);
        }
        if (arg instanceof TypeElement) {
            return ((TypeElement)arg).getQualifiedName();
        }
        if (arg instanceof Element) {
            return ((Element)arg).getSimpleName();
        }
        if (arg instanceof Collection) {
            return ((Collection)arg).stream().map(this::toCharSequence).collect(Collectors.joining(", "));
        }
        if (arg instanceof Code) {
            Formatter f = new Formatter();
            Printer p = new Printer(this.ctx, f);
            ((Code)arg).print(p);
            return f.toString();
        }
        if (arg != null) {
            return arg.toString();
        }
        return null;
    }

    private void throwExceptionIfNecessary() {
        IOException e = this.formatter.ioException();
        if (e != null) {
            throw new UncheckedIOException(e);
        }
    }

    public void indent() {
        this.indentBuffer.append(INDENT_SPACE);
    }

    public void unindent() {
        if (this.indentBuffer.length() >= INDENT_SPACE.length()) {
            this.indentBuffer.setLength(this.indentBuffer.length() - INDENT_SPACE.length());
        }
    }
}

