/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.seasar.doma.Association;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.AggregateStrategyAnnot;
import org.seasar.doma.internal.apt.annot.AssociationLinkerAnnot;
import org.seasar.doma.internal.apt.cttype.BiFunctionCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.aggregate.AggregateStrategyMeta;
import org.seasar.doma.internal.apt.meta.aggregate.AssociationLinkerMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AggregateStrategyMetaFactory
implements TypeElementMetaFactory<AggregateStrategyMeta> {
    private final RoundContext ctx;

    public AggregateStrategyMetaFactory(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    @Override
    public AggregateStrategyMeta createTypeElementMeta(TypeElement typeElement) {
        AggregateStrategyAnnot aggregateStrategyAnnot = this.ctx.getAnnotations().newAggregateStrategyAnnot(typeElement);
        if (aggregateStrategyAnnot == null) {
            throw new AptIllegalStateException("aggregateStrategyAnnot is null. typeElement=" + String.valueOf(typeElement));
        }
        if (!typeElement.getKind().isInterface()) {
            throw new AptException((MessageResource)Message.DOMA4482, typeElement, new Object[0]);
        }
        if (typeElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new AptException((MessageResource)Message.DOMA4483, typeElement, new Object[0]);
        }
        if (!typeElement.getInterfaces().isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4487, typeElement, new Object[0]);
        }
        EntityCtType root = this.ctx.getCtTypes().newEntityCtType(aggregateStrategyAnnot.getRootValue());
        if (root == null) {
            throw new AptException((MessageResource)Message.DOMA4478, typeElement, new Object[0]);
        }
        List<AssociationLinkerMeta> associationLinkerMetas = this.findAssociationLinkerMetas(typeElement);
        this.validateAllPropertyPaths(associationLinkerMetas);
        this.validateAllTableAliases(aggregateStrategyAnnot.getTableAliasValue(), associationLinkerMetas);
        this.validateNavigation(root, associationLinkerMetas);
        return new AggregateStrategyMeta(typeElement, root, aggregateStrategyAnnot.getTableAliasValue(), associationLinkerMetas);
    }

    private void validateAllPropertyPaths(List<AssociationLinkerMeta> associationLinkerMetas) {
        HashSet<String> seen = new HashSet<String>(associationLinkerMetas.size());
        for (AssociationLinkerMeta linkerMeta : associationLinkerMetas) {
            if (seen.add(linkerMeta.propertyPath())) continue;
            throw new AptException((MessageResource)Message.DOMA4489, linkerMeta.filedElement(), linkerMeta.associationLinkerAnnot().getAnnotationMirror(), linkerMeta.associationLinkerAnnot().getPropertyPath(), new Object[]{linkerMeta.propertyPath()});
        }
        Map map = associationLinkerMetas.stream().collect(Collectors.toMap(AssociationLinkerMeta::propertyPath, Function.identity()));
        List<AssociationLinkerMeta> validationTargets = associationLinkerMetas.stream().filter(it -> it.propertyPathDepth() > 1).toList();
        for (AssociationLinkerMeta linkerMeta : validationTargets) {
            if (map.containsKey(linkerMeta.ancestorPath())) continue;
            throw new AptException((MessageResource)Message.DOMA4488, linkerMeta.filedElement(), linkerMeta.associationLinkerAnnot().getAnnotationMirror(), linkerMeta.associationLinkerAnnot().getPropertyPath(), new Object[]{linkerMeta.propertyPath(), linkerMeta.ancestorPath()});
        }
    }

    private void validateAllTableAliases(String rootTableAlias, List<AssociationLinkerMeta> associationLinkerMetas) {
        HashSet<String> seen = new HashSet<String>(1 + associationLinkerMetas.size());
        seen.add(rootTableAlias);
        for (AssociationLinkerMeta linkerMeta : associationLinkerMetas) {
            if (seen.add(linkerMeta.tableAlias())) continue;
            throw new AptException((MessageResource)Message.DOMA4481, linkerMeta.filedElement(), linkerMeta.associationLinkerAnnot().getAnnotationMirror(), linkerMeta.associationLinkerAnnot().getTableAlias(), new Object[]{linkerMeta.tableAlias()});
        }
    }

    private void validateNavigation(EntityCtType root, List<AssociationLinkerMeta> associationLinkerMetas) {
        for (AssociationLinkerMeta linkerMeta : associationLinkerMetas) {
            TypeMirror source = root.getType();
            TypeMirror target = root.getType();
            for (String segment : linkerMeta.propertyPathSegments()) {
                source = target;
                target = this.resolveEntity(source, segment, linkerMeta.filedElement(), linkerMeta.associationLinkerAnnot());
            }
            if (!this.ctx.getMoreTypes().isSameType(linkerMeta.source().getType(), source)) {
                throw new AptException((MessageResource)Message.DOMA4475, linkerMeta.filedElement(), new Object[]{linkerMeta.source().getType(), source});
            }
            if (this.ctx.getMoreTypes().isSameType(linkerMeta.target().getType(), target)) continue;
            throw new AptException((MessageResource)Message.DOMA4476, linkerMeta.filedElement(), new Object[]{linkerMeta.target().getType(), target});
        }
    }

    private List<AssociationLinkerMeta> findAssociationLinkerMetas(TypeElement aggregateStrategyElement) {
        ArrayList<AssociationLinkerMeta> associationLinkerMetas = new ArrayList<AssociationLinkerMeta>();
        for (VariableElement fieldElement : ElementFilter.fieldsIn(aggregateStrategyElement.getEnclosedElements())) {
            AssociationLinkerAnnot associationLinkerAnnot = this.getAssociationLinkerAnnot(fieldElement);
            if (associationLinkerAnnot == null) continue;
            this.validateModifiers(fieldElement);
            AssociationLinkerMeta associationLinkerMeta = this.createAssociationLinkerMeta(fieldElement, associationLinkerAnnot, aggregateStrategyElement);
            associationLinkerMetas.add(associationLinkerMeta);
        }
        if (associationLinkerMetas.isEmpty()) {
            this.ctx.getReporter().report(Diagnostic.Kind.WARNING, (MessageResource)Message.DOMA4469, aggregateStrategyElement, new Object[]{aggregateStrategyElement});
            return associationLinkerMetas;
        }
        Comparator<AssociationLinkerMeta> reversedComparator = Comparator.comparingInt(AssociationLinkerMeta::propertyPathDepth).reversed();
        return associationLinkerMetas.stream().sorted(reversedComparator).toList();
    }

    private AssociationLinkerAnnot getAssociationLinkerAnnot(VariableElement linkerElement) {
        AssociationLinkerAnnot associationLinkerAnnot = this.ctx.getAnnotations().newAssociationLinkerAnnot(linkerElement);
        if (associationLinkerAnnot == null) {
            return null;
        }
        if (associationLinkerAnnot.getPropertyPathValue().isBlank()) {
            throw new AptException((MessageResource)Message.DOMA4472, linkerElement, associationLinkerAnnot.getAnnotationMirror(), associationLinkerAnnot.getPropertyPath(), new Object[0]);
        }
        if (associationLinkerAnnot.getTableAliasValue().isBlank()) {
            throw new AptException((MessageResource)Message.DOMA4468, linkerElement, associationLinkerAnnot.getAnnotationMirror(), associationLinkerAnnot.getTableAlias(), new Object[0]);
        }
        return associationLinkerAnnot;
    }

    private void validateModifiers(VariableElement linkerElement) {
        if (!linkerElement.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new AptException((MessageResource)Message.DOMA4464, linkerElement, new Object[0]);
        }
        if (!linkerElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4470, linkerElement, new Object[0]);
        }
        if (!linkerElement.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new AptException((MessageResource)Message.DOMA4471, linkerElement, new Object[0]);
        }
    }

    private TypeMirror resolveEntity(TypeMirror typeMirror, String name, VariableElement linkerElement, AssociationLinkerAnnot associationLinkerAnnot) {
        TypeElement sourceElement = this.ctx.getMoreTypes().toTypeElement(typeMirror);
        if (sourceElement == null) {
            throw new AptIllegalStateException("sourceElement is null. typeMirror=" + String.valueOf(typeMirror));
        }
        Optional<VariableElement> field = this.findAssociationField(sourceElement, name);
        if (field.isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4474, linkerElement, associationLinkerAnnot.getAnnotationMirror(), associationLinkerAnnot.getPropertyPath(), new Object[]{name, sourceElement.getQualifiedName()});
        }
        TypeMirror fieldType = field.get().asType();
        CtType ctType = this.ctx.getCtTypes().newCtType(fieldType);
        EntityCtType entityCtType = EntityCtType.resolveEntityCtType(ctType);
        if (entityCtType == null) {
            throw new AptException((MessageResource)Message.DOMA4477, linkerElement, new Object[]{name, sourceElement.getQualifiedName(), fieldType});
        }
        return entityCtType.getType();
    }

    private Optional<VariableElement> findAssociationField(TypeElement typeElement, String name) {
        TypeElement t = typeElement;
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            Optional<VariableElement> field;
            if (t.getAnnotation(Entity.class) != null && (field = ElementFilter.fieldsIn(t.getEnclosedElements()).stream().filter(it -> it.getSimpleName().toString().equals(name)).findFirst()).isPresent()) {
                VariableElement f = field.get();
                if (f.getAnnotation(Association.class) == null) {
                    throw new AptException((MessageResource)Message.DOMA4486, field.get(), new Object[]{name, f.asType()});
                }
                return field;
            }
            t = this.ctx.getMoreTypes().toTypeElement(t.getSuperclass());
        }
        return Optional.empty();
    }

    private AssociationLinkerMeta createAssociationLinkerMeta(VariableElement fieldElement, AssociationLinkerAnnot associationLinkerAnnot, TypeElement aggregateStrategyElement) {
        String propertyPath = associationLinkerAnnot.getPropertyPathValue();
        List<String> propertyPathSegments = Arrays.stream(propertyPath.split("\\.")).toList();
        int propertyPathDepth = propertyPathSegments.size();
        if (propertyPathDepth == 0) {
            throw new AptIllegalStateException("propertyPath=" + propertyPath);
        }
        String ancestorPath = propertyPathDepth == 1 ? "" : propertyPath.substring(0, propertyPath.lastIndexOf(46));
        LinkMeta linkMeta = this.createLinkMeta(fieldElement);
        return new AssociationLinkerMeta(associationLinkerAnnot, ancestorPath, associationLinkerAnnot.getPropertyPathValue(), propertyPathSegments, propertyPathDepth, associationLinkerAnnot.getTableAliasValue(), linkMeta.source, linkMeta.target, aggregateStrategyElement, fieldElement);
    }

    private LinkMeta createLinkMeta(final VariableElement linkerElement) {
        BiFunctionCtType ctType = this.ctx.getCtTypes().newBiFunctionCtType(linkerElement.asType());
        if (ctType == null) {
            throw new AptException((MessageResource)Message.DOMA4465, linkerElement, new Object[0]);
        }
        SimpleCtTypeVisitor<EntityCtType, String, RuntimeException> entityCtTypeVisitor = new SimpleCtTypeVisitor<EntityCtType, String, RuntimeException>(){

            @Override
            protected EntityCtType defaultAction(CtType ctType, String ordinalNumber) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4466, linkerElement, new Object[]{ordinalNumber});
            }

            @Override
            public EntityCtType visitEntityCtType(EntityCtType ctType, String ordinalNumber) throws RuntimeException {
                return ctType;
            }
        };
        EntityCtType source = ctType.getFirstArgCtType().accept(entityCtTypeVisitor, "first");
        EntityCtType target = ctType.getSecondArgCtType().accept(entityCtTypeVisitor, "second");
        EntityCtType result = ctType.getResultCtType().accept(entityCtTypeVisitor, "third");
        if (!this.ctx.getMoreTypes().isSameType(result.getType(), source.getType())) {
            throw new AptException((MessageResource)Message.DOMA4467, linkerElement, new Object[0]);
        }
        return new LinkMeta(source, target);
    }

    private record LinkMeta(EntityCtType source, EntityCtType target) {
    }
}

