/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Scope;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.decl.TypeDeclaration;
import org.seasar.doma.internal.apt.decl.TypeParameterDeclaration;
import org.seasar.doma.internal.apt.meta.entity.ScopeClassMeta;
import org.seasar.doma.internal.apt.meta.entity.ScopeMethodMeta;
import org.seasar.doma.internal.apt.meta.entity.ScopeParameterMeta;

public class ScopeClassMetaFactory {
    private final RoundContext ctx;
    private final TypeElement typeElement;
    private final List<TypeParameterDeclaration> allTypeParameterDeclarations;

    public ScopeClassMetaFactory(RoundContext ctx, TypeElement typeElement) {
        this.ctx = Objects.requireNonNull(ctx);
        this.typeElement = Objects.requireNonNull(typeElement);
        TypeDeclaration typeDeclaration = ctx.getDeclarations().newTypeDeclaration(typeElement);
        this.allTypeParameterDeclarations = typeDeclaration.getAllTypeParameterDeclarations();
    }

    public ScopeClassMeta createScopeClassMeta() {
        List<ScopeMethodMeta> scopeMethodMetas = ElementFilter.methodsIn(this.ctx.getMoreElements().getAllMembers(this.typeElement)).stream().filter(m -> m.getAnnotation(Scope.class) != null).filter(m -> m.getParameters().size() > 0).filter(m -> m.getModifiers().contains((Object)Modifier.PUBLIC)).filter(m -> !m.getModifiers().contains((Object)Modifier.STATIC)).sorted(Comparator.comparing(m -> m.getSimpleName().toString())).map(this::createScopeMethodMeta).collect(Collectors.toList());
        return new ScopeClassMeta(this.typeElement, scopeMethodMetas);
    }

    private ScopeMethodMeta createScopeMethodMeta(ExecutableElement method) {
        ArrayList<ScopeParameterMeta> scopeParameterMetas = new ArrayList<ScopeParameterMeta>(method.getParameters().size());
        Iterator it = method.getParameters().stream().skip(1L).iterator();
        while (it.hasNext()) {
            VariableElement parameter = (VariableElement)it.next();
            boolean isVarArgs = !it.hasNext() && method.isVarArgs();
            ScopeParameterMeta p = this.createScopeParameterMeta(parameter, isVarArgs);
            scopeParameterMetas.add(p);
        }
        return new ScopeMethodMeta(method, scopeParameterMetas);
    }

    private ScopeParameterMeta createScopeParameterMeta(VariableElement parameter, boolean isVarArgs) {
        TypeMirror actualType = this.resolveTypeParameter(parameter.asType());
        return new ScopeParameterMeta(parameter, actualType, isVarArgs);
    }

    private TypeMirror resolveTypeParameter(TypeMirror formalType) {
        TypeParameterDeclaration typeParameterDeclaration = this.ctx.getDeclarations().newTypeParameterDeclarationUsingTypeParams(formalType, this.allTypeParameterDeclarations);
        return typeParameterDeclaration.getActualType();
    }
}

