/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.TypeKindVisitor14;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.BatchResultCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.MultiResultCtType;
import org.seasar.doma.internal.apt.cttype.ResultCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;

public class QueryReturnMeta {
    private final CtType ctType;

    public QueryReturnMeta(CtType ctType) {
        AssertionUtil.assertNotNull((Object)ctType);
        this.ctType = ctType;
    }

    public TypeMirror getBoxedType() {
        return this.ctType.accept(new SimpleCtTypeVisitor<TypeMirror, Void, RuntimeException>(){

            @Override
            public TypeMirror visitBasicCtType(BasicCtType ctType, Void o) {
                return ctType.getBoxedType();
            }

            @Override
            protected TypeMirror defaultAction(CtType ctType, Void o) {
                return ctType.getType();
            }
        }, null);
    }

    public boolean isPrimitiveInt() {
        return this.ctType.getType().getKind() == TypeKind.INT;
    }

    public boolean isPrimitiveIntArray() {
        return this.ctType.getType().accept(new TypeKindVisitor14<Boolean, Void>(Boolean.valueOf(false)){

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return t.getComponentType().getKind() == TypeKind.INT;
            }
        }, null);
    }

    public boolean isPrimitiveVoid() {
        return this.ctType.getType().getKind() == TypeKind.VOID;
    }

    public boolean isResult(final EntityCtType entityCtType) {
        return this.ctType.accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

            @Override
            public Boolean visitResultCtType(ResultCtType ctType, Void aVoid) throws RuntimeException {
                CtType elementCtType = ctType.getElementCtType();
                return elementCtType.isSameType(entityCtType);
            }
        }, null);
    }

    public boolean isBatchResult(final EntityCtType entityCtType) {
        return this.ctType.accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

            @Override
            public Boolean visitBatchResultCtType(BatchResultCtType ctType, Void aVoid) throws RuntimeException {
                CtType elementCtType = ctType.getElementCtType();
                return elementCtType.isSameType(entityCtType);
            }
        }, null);
    }

    public boolean isMultiResult(final EntityCtType entityCtType) {
        return this.ctType.accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

            @Override
            public Boolean visitMultiResultCtType(MultiResultCtType ctType, Void aVoid) throws RuntimeException {
                CtType elementCtType = ctType.getElementCtType();
                return elementCtType.isSameType(entityCtType);
            }
        }, null);
    }

    public TypeMirror getType() {
        return this.ctType.getType();
    }

    public CtType getCtType() {
        return this.ctType;
    }
}

