/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.EntityAnnot;
import org.seasar.doma.internal.apt.annot.MetamodelAnnot;
import org.seasar.doma.internal.apt.generator.EntityMetamodelGenerator;
import org.seasar.doma.internal.apt.generator.EntityTypeGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.JavaFileGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityMetaFactory;
import org.seasar.doma.internal.apt.processor.ElementProcessor;
import org.seasar.doma.internal.apt.processor.ElementProcessorSupport;
import org.seasar.doma.internal.util.AssertionUtil;

public class EntityProcessor
implements ElementProcessor {
    private final RoundContext ctx;
    private final ElementProcessorSupport<EntityMeta> support;
    private final EntityMetaFactory factory;

    public EntityProcessor(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.support = new ElementProcessorSupport(ctx, Entity.class);
        this.factory = new EntityMetaFactory(ctx);
    }

    @Override
    public void process(Set<? extends Element> elements) {
        this.support.processTypeElements(elements, this::processEach);
    }

    private EntityMeta processEach(TypeElement typeElement) {
        EntityMeta meta = this.factory.createTypeElementMeta(typeElement);
        if (!meta.isError()) {
            this.generateEntityType(typeElement, meta);
            if (this.isMetamodelEnabled(meta)) {
                this.generateEntityMetamodel(typeElement, meta);
            }
        }
        return meta;
    }

    private boolean isMetamodelEnabled(EntityMeta meta) {
        EntityAnnot entityAnnot = meta.getEntityAnnot();
        MetamodelAnnot metamodelAnnot = entityAnnot.getMetamodelValue();
        return metamodelAnnot != null || this.ctx.getOptions().isMetamodelEnabled();
    }

    private void generateEntityType(TypeElement typeElement, EntityMeta meta) {
        JavaFileGenerator<EntityMeta> generator = new JavaFileGenerator<EntityMeta>(this.ctx, this::createEntityTypeClassName, this::createEntityTypeGenerator);
        generator.generate(typeElement, meta);
    }

    private ClassName createEntityTypeClassName(TypeElement typeElement, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        return ClassNames.newEntityTypeClassName((CharSequence)binaryName);
    }

    private Generator createEntityTypeGenerator(ClassName className, Printer printer, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new EntityTypeGenerator(this.ctx, className, printer, meta);
    }

    private void generateEntityMetamodel(TypeElement typeElement, EntityMeta meta) {
        JavaFileGenerator<EntityMeta> generator = new JavaFileGenerator<EntityMeta>(this.ctx, this::createEntityMetamodelClassName, this::createEntityMetamodelGenerator);
        generator.generate(typeElement, meta);
    }

    private ClassName createEntityMetamodelClassName(TypeElement typeElement, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        EntityAnnot entityAnnot = meta.getEntityAnnot();
        MetamodelAnnot metamodelAnnot = entityAnnot.getMetamodelValue();
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        String prefix = this.ctx.getOptions().getMetamodelPrefix();
        String suffix = this.ctx.getOptions().getMetamodelSuffix();
        if (metamodelAnnot != null) {
            String prefixValue = metamodelAnnot.getPrefixValue();
            String suffixValue = metamodelAnnot.getSuffixValue();
            if (!prefixValue.isEmpty() || !suffixValue.isEmpty()) {
                prefix = prefixValue;
                suffix = suffixValue;
            }
        }
        return ClassNames.newEntityMetamodelClassNameBuilder((CharSequence)binaryName, (String)prefix, (String)suffix);
    }

    private Generator createEntityMetamodelGenerator(ClassName className, Printer printer, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        ClassName entityTypeName = this.createEntityTypeClassName(meta.getTypeElement(), meta);
        return new EntityMetamodelGenerator(this.ctx, className, printer, meta, entityTypeName);
    }
}

