/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class ReturningAnnot
extends AbstractAnnot {
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private final AnnotationValue include;
    private final AnnotationValue exclude;

    ReturningAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.include = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)INCLUDE);
        this.exclude = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)EXCLUDE);
    }

    public AnnotationValue getInclude() {
        return this.include;
    }

    public AnnotationValue getExclude() {
        return this.exclude;
    }

    public List<String> getIncludeValue() {
        return AnnotationValueUtil.toStringList(this.include);
    }

    public List<String> getExcludeValue() {
        return AnnotationValueUtil.toStringList(this.exclude);
    }
}

