/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;

public class BiFunctionCtType
extends AbstractCtType {
    private final CtType firstArgCtType;
    private final CtType secondArgCtType;
    private final CtType resultCtType;

    BiFunctionCtType(RoundContext ctx, TypeMirror type, CtType firstArgCtType, CtType secondArgCtType, CtType resultCtType) {
        super(ctx, type);
        AssertionUtil.assertNotNull((Object)firstArgCtType, (Object)secondArgCtType, (Object)resultCtType);
        this.firstArgCtType = firstArgCtType;
        this.secondArgCtType = secondArgCtType;
        this.resultCtType = resultCtType;
    }

    public CtType getFirstArgCtType() {
        return this.firstArgCtType;
    }

    public CtType getSecondArgCtType() {
        return this.secondArgCtType;
    }

    public CtType getResultCtType() {
        return this.resultCtType;
    }

    public boolean isRaw() {
        return this.firstArgCtType.isNone() || this.secondArgCtType.isNone() || this.resultCtType.isNone();
    }

    public boolean hasWildcard() {
        return this.firstArgCtType.isWildcard() || this.secondArgCtType.isWildcard() || this.resultCtType.isWildcard();
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitBiFunctionCtType(this, p);
    }
}

