/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.generator.UnwrapOptionalVisitor;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.ScopeClassMeta;
import org.seasar.doma.internal.apt.meta.entity.ScopeMethodMeta;
import org.seasar.doma.internal.apt.meta.entity.ScopeParameterMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.criteria.metamodel.DefaultPropertyMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.EntityTypeProxy;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.entity.EntityType;

public class EntityMetamodelGenerator
extends AbstractGenerator {
    private final EntityMeta entityMeta;
    private final ClassName entityTypeName;

    public EntityMetamodelGenerator(RoundContext ctx, ClassName className, Printer printer, EntityMeta entityMeta, ClassName entityTypeName) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)entityMeta, (Object)entityTypeName);
        this.entityMeta = entityMeta;
        this.entityTypeName = entityTypeName;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    private void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    private void printClass() {
        this.iprint("/** */%n", new Object[0]);
        this.printGenerated();
        this.iprint("public final class %1$s implements %2$s<%3$s> {%n", this.simpleName, EntityMetamodel.class, this.entityMeta.getType());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    private void printFields() {
        this.printQualifiedTableNameField();
        this.printEntityTypeField();
        this.printAllPropertyMetamodelsFields();
        this.printPropertyMetamodelFields();
        this.printScopeFields();
    }

    private void printEntityTypeField() {
        this.iprint("private final %1$s __entityType = %1$s.getSingletonInternal();%n", this.entityTypeName);
        this.print("%n", new Object[0]);
    }

    private void printAllPropertyMetamodelsFields() {
        this.iprint("private final java.util.List<%1$s<?>> __allPropertyMetamodels;%n", PropertyMetamodel.class);
        this.print("%n", new Object[0]);
    }

    private void printQualifiedTableNameField() {
        this.iprint("private final String __qualifiedTableName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printScopeFields() {
        for (ScopeClassMeta scopeClassMeta : this.entityMeta.getScopeClassMetas()) {
            this.iprint("private final %1$s %2$s = new %1$s();%n", scopeClassMeta.getTypeElement(), scopeClassMeta.getIdentifier());
            this.print("%n", new Object[0]);
        }
    }

    private void printConstructors() {
        this.printNoArgsConstructor();
        this.printOneArgConstructor();
    }

    private void printNoArgsConstructor() {
        this.iprint("public %1$s() {%n", this.simpleName);
        this.indent();
        this.iprint("this(\"\");%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printOneArgConstructor() {
        this.iprint("public %1$s(String qualifiedTableName) {%n", this.simpleName);
        this.indent();
        this.iprint("this.__qualifiedTableName = java.util.Objects.requireNonNull(qualifiedTableName);%n", new Object[0]);
        this.iprint("java.util.ArrayList<%1$s<?>> __list = new java.util.ArrayList<>(%2$s);%n", PropertyMetamodel.class, this.entityMeta.getAllPropertyMetas().size());
        for (EntityPropertyMeta p : this.entityMeta.getAllPropertyMetas()) {
            if (p.isEmbedded()) {
                this.iprint("__list.addAll(%1$s.allPropertyMetamodels());%n", p.getName());
                continue;
            }
            this.iprint("__list.add(%1$s);%n", p.getName());
        }
        this.iprint("__allPropertyMetamodels = java.util.Collections.unmodifiableList(__list);%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printPropertyMetamodelFields() {
        UnwrapOptionalVisitor visitor = new UnwrapOptionalVisitor();
        for (EntityPropertyMeta p : this.entityMeta.getAllPropertyMetas()) {
            if (p.isEmbedded()) {
                ClassName className = this.createEmbeddableTypeClassName(p);
                this.iprint("public final %1$s.Metamodel %2$s = new %1$s.Metamodel(__entityType, \"%2$s\");%n", className, p.getName());
            } else {
                Pair<CtType, TypeMirror> pair = p.getCtType().accept(visitor, null);
                this.iprint("public final %1$s<%2$s> %3$s = new %4$s<%2$s>(%5$s.class, __entityType, \"%3$s\");%n", PropertyMetamodel.class, pair.snd, p.getName(), DefaultPropertyMetamodel.class, ((CtType)pair.fst).getQualifiedName());
            }
            this.print("%n", new Object[0]);
        }
    }

    private ClassName createEmbeddableTypeClassName(EntityPropertyMeta p) {
        TypeElement embeddableTypeElement = this.ctx.getMoreTypes().toTypeElement(p.getType());
        if (embeddableTypeElement == null) {
            throw new AptIllegalStateException("embeddableTypeElement");
        }
        Name binaryName = this.ctx.getMoreElements().getBinaryName(embeddableTypeElement);
        return ClassNames.newEmbeddableTypeClassName((CharSequence)binaryName);
    }

    private void printMethods() {
        this.printAsTypeMethod();
        this.printAllPropertyMetamodelsMethod();
        this.printScopeMethods();
    }

    private void printAsTypeMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%2$s> asType() {%n", EntityType.class, this.entityMeta.getType());
        this.indent();
        this.iprint("return __qualifiedTableName.isEmpty() ? __entityType : new %1$s<>(__entityType, __qualifiedTableName);%n", EntityTypeProxy.class);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printAllPropertyMetamodelsMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public java.util.List<%1$s<?>> allPropertyMetamodels() {%n", PropertyMetamodel.class);
        this.indent();
        this.iprint("return __allPropertyMetamodels;%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printScopeMethods() {
        for (ScopeClassMeta scopeClassMeta : this.entityMeta.getScopeClassMetas()) {
            for (ScopeMethodMeta scopeMethodMeta : scopeClassMeta.getMethods()) {
                this.printScopeMethod(scopeClassMeta, scopeMethodMeta);
            }
        }
    }

    private void printScopeMethod(ScopeClassMeta clazz, ScopeMethodMeta method) {
        this.iprint("public %1$s%2$s %3$s(%4$s) {%n", this.buildTypeParameters(method), method.getReturnType(), method.getName(), this.buildParameterList(method));
        this.indent();
        this.iprint("return %1$s.%2$s(this", clazz.getIdentifier(), method.getName());
        if (!method.getParameters().isEmpty()) {
            this.print(", ", new Object[0]);
            this.print(this.buildArgumentList(method), new Object[0]);
        }
        this.print(");%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private String buildTypeParameters(ScopeMethodMeta method) {
        List<? extends TypeParameterElement> typeParameters = method.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        return typeParameters.stream().map(this::buildTypeParameter).collect(Collectors.joining(", ", "<", "> "));
    }

    private String buildTypeParameter(TypeParameterElement element) {
        return element.getSimpleName().toString() + " extends " + element.getBounds().stream().map(TypeMirror::toString).collect(Collectors.joining(" & "));
    }

    private String buildParameterList(ScopeMethodMeta method) {
        return String.join((CharSequence)", ", method.getParameters());
    }

    private String buildArgumentList(ScopeMethodMeta method) {
        return method.getParameters().stream().map(ScopeParameterMeta::getName).collect(Collectors.joining(", "));
    }
}

