/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.generator.ScalarMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.AssignedIdPropertyType;
import org.seasar.doma.jdbc.entity.DefaultPropertyType;
import org.seasar.doma.jdbc.entity.EmbeddedPropertyType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.entity.TenantIdPropertyType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class EntityTypePropertyGenerator
extends AbstractGenerator {
    private final EntityMeta entityMeta;
    private final EntityPropertyMeta propertyMeta;

    EntityTypePropertyGenerator(RoundContext ctx, ClassName className, Printer printer, EntityMeta entityMeta, EntityPropertyMeta entityPropertyMeta) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)entityMeta);
        this.entityMeta = entityMeta;
        this.propertyMeta = entityPropertyMeta;
    }

    @Override
    public void generate() {
        this.printPropertyTypeField();
    }

    private void printPropertyTypeField() {
        if (this.propertyMeta.isEmbedded()) {
            EmbeddableCtTypeVisitor visitor = new EmbeddableCtTypeVisitor();
            EmbeddableCtType embeddableCtType = this.propertyMeta.getCtType().accept(visitor, null);
            this.printEmbeddedPropertyTypeField(embeddableCtType);
        } else {
            ScalarMetaFactory.ScalarMeta scalarMeta = this.propertyMeta.getCtType().accept(new ScalarMetaFactory(), false);
            if (this.propertyMeta.isId()) {
                if (this.propertyMeta.getIdGeneratorMeta() != null) {
                    this.printGeneratedIdPropertyTypeField(scalarMeta);
                } else {
                    this.printAssignedIdPropertyTypeField(scalarMeta);
                }
            } else if (this.propertyMeta.isVersion()) {
                this.printVersionPropertyTypeField(scalarMeta);
            } else if (this.propertyMeta.isTenantId()) {
                this.printTenantIdPropertyTypeField(scalarMeta);
            } else {
                this.printDefaultPropertyTypeField(scalarMeta);
            }
        }
    }

    private void printEmbeddedPropertyTypeField(EmbeddableCtType embeddableCtType) {
        this.print("new %1$s<%2$s, %3$s>(\"%5$s\", %2$s.class, %6$s.getEmbeddablePropertyTypes(\"%5$s\", %2$s.class, __namingType))", EmbeddedPropertyType.class, this.entityMeta.getType(), this.propertyMeta.getType(), null, this.propertyMeta.getName(), embeddableCtType.getTypeCode());
    }

    private void printGeneratedIdPropertyTypeField(ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s, __idGenerator)", GeneratedIdPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), this.propertyMeta.getName(), this.propertyMeta.getColumnName(), this.propertyMeta.isColumnQuoteRequired());
    }

    private void printAssignedIdPropertyTypeField(ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s)", AssignedIdPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), this.propertyMeta.getName(), this.propertyMeta.getColumnName(), this.propertyMeta.isColumnQuoteRequired());
    }

    private void printVersionPropertyTypeField(ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s)", VersionPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), this.propertyMeta.getName(), this.propertyMeta.getColumnName(), this.propertyMeta.isColumnQuoteRequired());
    }

    private void printTenantIdPropertyTypeField(ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s)", TenantIdPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), this.propertyMeta.getName(), this.propertyMeta.getColumnName(), this.propertyMeta.isColumnQuoteRequired());
    }

    private void printDefaultPropertyTypeField(ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s, %11$s, %12$s)", DefaultPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), this.propertyMeta.getName(), this.propertyMeta.getColumnName(), this.propertyMeta.isColumnInsertable(), this.propertyMeta.isColumnUpdatable(), this.propertyMeta.isColumnQuoteRequired());
    }

    private static class EmbeddableCtTypeVisitor
    extends SimpleCtTypeVisitor<EmbeddableCtType, Void, RuntimeException> {
        private EmbeddableCtTypeVisitor() {
        }

        @Override
        public EmbeddableCtType visitEmbeddableCtType(EmbeddableCtType ctType, Void aVoid) throws RuntimeException {
            return ctType;
        }
    }
}

