/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.def.TypeParametersDef;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyNameCollector;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMetaFactory;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

abstract class AbstractQueryMetaFactory<M extends AbstractQueryMeta>
implements QueryMetaFactory {
    final RoundContext ctx;
    final TypeElement daoElement;
    final ExecutableElement methodElement;

    AbstractQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)daoElement, (Object)methodElement);
        this.ctx = ctx;
        this.daoElement = daoElement;
        this.methodElement = methodElement;
    }

    void doTypeParameters(M queryMeta) {
        TypeParametersDef typeParametersDef = this.ctx.getMoreElements().getTypeParametersDef(this.methodElement);
        ((AbstractQueryMeta)queryMeta).setTypeParametersDef(typeParametersDef);
    }

    protected abstract void doReturnType(M var1);

    protected abstract void doParameters(M var1);

    void doThrowTypes(M queryMeta) {
        this.methodElement.getThrownTypes().forEach(arg_0 -> queryMeta.addThrownType(arg_0));
    }

    void validateEntityPropertyNames(TypeMirror entityType, AnnotationMirror annotationMirror, AnnotationValue includeValue, AnnotationValue excludeValue, AnnotationValue duplicateKeysValue) {
        List<String> duplicateKeys;
        List<String> excludedPropertyNames;
        List<String> includedPropertyNames = AnnotationValueUtil.toStringList(includeValue);
        if (includedPropertyNames == null) {
            includedPropertyNames = Collections.emptyList();
        }
        if ((excludedPropertyNames = AnnotationValueUtil.toStringList(excludeValue)) == null) {
            excludedPropertyNames = Collections.emptyList();
        }
        if ((duplicateKeys = AnnotationValueUtil.toStringList(duplicateKeysValue)) == null) {
            duplicateKeys = Collections.emptyList();
        }
        if (!(includedPropertyNames.isEmpty() && excludedPropertyNames.isEmpty() && duplicateKeys.isEmpty())) {
            EntityPropertyNameCollector collector = new EntityPropertyNameCollector(this.ctx);
            Set<String> names = collector.collect(entityType);
            for (String included : includedPropertyNames) {
                if (names.contains(included)) continue;
                throw new AptException((MessageResource)Message.DOMA4084, this.methodElement, annotationMirror, includeValue, new Object[]{included, entityType});
            }
            for (String excluded : excludedPropertyNames) {
                if (names.contains(excluded)) continue;
                throw new AptException((MessageResource)Message.DOMA4085, this.methodElement, annotationMirror, excludeValue, new Object[]{excluded, entityType});
            }
            for (String duplicateKey : duplicateKeys) {
                if (names.contains(duplicateKey)) continue;
                throw new AptException((MessageResource)Message.DOMA4462, this.methodElement, annotationMirror, duplicateKeysValue, new Object[]{duplicateKey, entityType});
            }
        }
    }

    QueryReturnMeta createReturnMeta(QueryMeta queryMeta) {
        QueryReturnMetaFactory factory = new QueryReturnMetaFactory(this.ctx, queryMeta);
        return factory.createQueryReturnMeta();
    }

    QueryParameterMeta createParameterMeta(VariableElement parameter) {
        QueryParameterMetaFactory factory = new QueryParameterMetaFactory(this.ctx, parameter);
        return factory.createQueryParameterMeta();
    }
}

