/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.sql.Array;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ArrayFactoryAnnot;
import org.seasar.doma.internal.apt.meta.query.AbstractCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.ArrayCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class ArrayCreateQueryMetaFactory
extends AbstractCreateQueryMetaFactory<ArrayCreateQueryMeta> {
    public ArrayCreateQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement, Array.class);
    }

    @Override
    public QueryMeta createQueryMeta() {
        ArrayFactoryAnnot arrayFactoryAnnot = this.ctx.getAnnotations().newArrayFactoryAnnot(this.methodElement);
        if (arrayFactoryAnnot == null) {
            return null;
        }
        ArrayCreateQueryMeta queryMeta = new ArrayCreateQueryMeta(this.daoElement, this.methodElement);
        queryMeta.setArrayFactoryAnnot(arrayFactoryAnnot);
        queryMeta.setQueryKind(QueryKind.ARRAY_FACTORY);
        this.doTypeParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doParameters(queryMeta);
        this.doThrowTypes(queryMeta);
        return queryMeta;
    }

    @Override
    protected void doParameters(ArrayCreateQueryMeta queryMeta) {
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.methodElement, new Object[0]);
        }
        QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0));
        if (parameterMeta.getType().getKind() != TypeKind.ARRAY) {
            throw new AptException((MessageResource)Message.DOMA4076, parameterMeta.getElement(), new Object[0]);
        }
        queryMeta.setElementsParameterName(parameterMeta.getName());
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
    }
}

