/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ModifyAnnot;
import org.seasar.doma.internal.apt.annot.ReturningAnnot;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.query.ReturningAnnotValidator;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoModifyQueryMetaFactory
extends AbstractQueryMetaFactory<AutoModifyQueryMeta> {
    public AutoModifyQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    public QueryMeta createQueryMeta() {
        AutoModifyQueryMeta queryMeta = this.createAutoModifyQueryMeta();
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta);
        this.doParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doThrowTypes(queryMeta);
        return queryMeta;
    }

    private AutoModifyQueryMeta createAutoModifyQueryMeta() {
        SqlAnnot sqlAnnot = this.ctx.getAnnotations().newSqlAnnot(this.methodElement);
        if (sqlAnnot != null) {
            return null;
        }
        AutoModifyQueryMeta queryMeta = new AutoModifyQueryMeta(this.daoElement, this.methodElement);
        ModifyAnnot modifyAnnot = this.ctx.getAnnotations().newInsertAnnot(this.methodElement);
        if (modifyAnnot != null && !modifyAnnot.getSqlFileValue()) {
            queryMeta.setModifyAnnot(modifyAnnot);
            queryMeta.setQueryKind(QueryKind.AUTO_INSERT);
            return queryMeta;
        }
        modifyAnnot = this.ctx.getAnnotations().newUpdateAnnot(this.methodElement);
        if (modifyAnnot != null && !modifyAnnot.getSqlFileValue()) {
            queryMeta.setModifyAnnot(modifyAnnot);
            queryMeta.setQueryKind(QueryKind.AUTO_UPDATE);
            return queryMeta;
        }
        modifyAnnot = this.ctx.getAnnotations().newDeleteAnnot(this.methodElement);
        if (modifyAnnot != null && !modifyAnnot.getSqlFileValue()) {
            queryMeta.setModifyAnnot(modifyAnnot);
            queryMeta.setQueryKind(QueryKind.AUTO_DELETE);
            return queryMeta;
        }
        return null;
    }

    @Override
    protected void doReturnType(AutoModifyQueryMeta queryMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        EntityCtType entityCtType = queryMeta.getEntityCtType();
        if (queryMeta.getReturningAnnot() == null) {
            if (entityCtType != null && entityCtType.isImmutable()) {
                if (!returnMeta.isResult(entityCtType)) {
                    throw new AptException((MessageResource)Message.DOMA4222, this.methodElement, new Object[0]);
                }
            } else if (!returnMeta.isPrimitiveInt()) {
                throw new AptException((MessageResource)Message.DOMA4001, this.methodElement, new Object[0]);
            }
        } else if (!returnMeta.isEntity(entityCtType) && !returnMeta.isEntityOptional(entityCtType)) {
            throw new AptException((MessageResource)Message.DOMA4495, this.methodElement, new Object[0]);
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(AutoModifyQueryMeta queryMeta) {
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.methodElement, new Object[0]);
        }
        final QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0));
        EntityCtType entityCtType = parameterMeta.getCtType().accept(new SimpleCtTypeVisitor<EntityCtType, Void, RuntimeException>(){

            @Override
            protected EntityCtType defaultAction(CtType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4003, parameterMeta.getElement(), new Object[0]);
            }

            @Override
            public EntityCtType visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
                return ctType;
            }
        }, null);
        queryMeta.setEntityCtType(entityCtType);
        queryMeta.setEntityParameterName(parameterMeta.getName());
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
        ModifyAnnot modifyAnnot = queryMeta.getModifyAnnot();
        this.validateEntityPropertyNames(entityCtType.getType(), modifyAnnot.getAnnotationMirror(), modifyAnnot.getInclude(), modifyAnnot.getExclude(), modifyAnnot.getDuplicateKeys());
        ReturningAnnot returningAnnot = queryMeta.getReturningAnnot();
        if (returningAnnot != null) {
            ReturningAnnotValidator returningAnnotValidator = new ReturningAnnotValidator(this.ctx, entityCtType.getType(), this.methodElement, returningAnnot);
            returningAnnotValidator.validate();
        }
    }
}

