/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.DefaultQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;

public class DefaultQueryMetaFactory
extends AbstractQueryMetaFactory<DefaultQueryMeta> {
    public DefaultQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    public QueryMeta createQueryMeta() {
        boolean isVirtualDefaultMethod = this.ctx.getMoreElements().isVirtualDefaultMethod(this.daoElement, this.methodElement);
        if (!isVirtualDefaultMethod && !this.methodElement.isDefault()) {
            return null;
        }
        DefaultQueryMeta queryMeta = new DefaultQueryMeta(this.daoElement, this.methodElement, isVirtualDefaultMethod);
        queryMeta.setQueryKind(QueryKind.DEFAULT);
        this.doTypeParameters(queryMeta);
        this.doParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doThrowTypes(queryMeta);
        return queryMeta;
    }

    @Override
    protected void doParameters(DefaultQueryMeta queryMeta) {
        for (VariableElement variableElement : this.methodElement.getParameters()) {
            QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement);
            queryMeta.addParameterMeta(parameterMeta);
            if (!parameterMeta.isBindable()) continue;
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
    }

    @Override
    protected void doReturnType(DefaultQueryMeta queryMeta) {
        QueryReturnMeta resultMeta = this.createReturnMeta(queryMeta);
        queryMeta.setReturnMeta(resultMeta);
    }
}

