/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

class QueryReturnMetaFactory {
    private final RoundContext ctx;
    private final ExecutableElement methodElement;

    public QueryReturnMetaFactory(RoundContext ctx, QueryMeta queryMeta) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)queryMeta);
        this.ctx = ctx;
        this.methodElement = queryMeta.getMethodElement();
    }

    public QueryReturnMeta createQueryReturnMeta() {
        TypeMirror type = this.methodElement.getReturnType();
        CtType ctType = this.ctx.getCtTypes().newCtType(type, new CtTypeValidator());
        return new QueryReturnMeta(ctType);
    }

    private class CtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, AptException> {
        private CtTypeValidator() {
        }

        @Override
        protected Void defaultAction(CtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType domainCtType, Void aVoid) throws AptException {
            if (domainCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4206, QueryReturnMetaFactory.this.methodElement, new Object[]{domainCtType.getQualifiedName()});
            }
            if (domainCtType.hasWildcard() || domainCtType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4207, QueryReturnMetaFactory.this.methodElement, new Object[]{domainCtType.getQualifiedName()});
            }
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType optionalCtType, Void aVoid) throws AptException {
            if (optionalCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4236, QueryReturnMetaFactory.this.methodElement, new Object[]{optionalCtType.getQualifiedName()});
            }
            if (optionalCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4237, QueryReturnMetaFactory.this.methodElement, new Object[]{optionalCtType.getQualifiedName()});
            }
            optionalCtType.getElementCtType().accept(new OptionalElementCtTypeValidator(), null);
            return null;
        }

        @Override
        public Void visitIterableCtType(IterableCtType iterableCtType, Void aVoid) throws AptException {
            if (iterableCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4109, QueryReturnMetaFactory.this.methodElement, new Object[0]);
            }
            if (iterableCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4113, QueryReturnMetaFactory.this.methodElement, new Object[]{iterableCtType.getType()});
            }
            iterableCtType.getElementCtType().accept(new IterableElementCtTypeValidator(), null);
            return null;
        }
    }

    private class IterableElementCtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, AptException> {
        private IterableElementCtTypeValidator() {
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws AptException {
            if (ctType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4210, QueryReturnMetaFactory.this.methodElement, new Object[]{ctType.getQualifiedName()});
            }
            if (ctType.hasWildcard() || ctType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4211, QueryReturnMetaFactory.this.methodElement, new Object[]{ctType.getQualifiedName()});
            }
            return null;
        }
    }

    private class OptionalElementCtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, AptException> {
        private OptionalElementCtTypeValidator() {
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws AptException {
            if (ctType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4238, QueryReturnMetaFactory.this.methodElement, new Object[]{ctType.getQualifiedName()});
            }
            if (ctType.hasWildcard() || ctType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4239, QueryReturnMetaFactory.this.methodElement, new Object[]{ctType.getQualifiedName()});
            }
            return null;
        }
    }
}

