/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ReturningAnnot;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyNameCollector;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class ReturningAnnotValidator {
    private final RoundContext ctx;
    private final TypeMirror entityType;
    private final ExecutableElement method;
    private final ReturningAnnot returningAnnot;

    public ReturningAnnotValidator(RoundContext ctx, TypeMirror entityType, ExecutableElement method, ReturningAnnot returningAnnot) {
        this.ctx = Objects.requireNonNull(ctx);
        this.entityType = Objects.requireNonNull(entityType);
        this.method = Objects.requireNonNull(method);
        this.returningAnnot = Objects.requireNonNull(returningAnnot);
    }

    void validate() {
        List<String> inclusion = this.returningAnnot.getIncludeValue();
        List<String> exclusion = this.returningAnnot.getExcludeValue();
        if (inclusion.isEmpty() && exclusion.isEmpty()) {
            return;
        }
        EntityPropertyNameCollector collector = new EntityPropertyNameCollector(this.ctx);
        Set<String> names = collector.collect(this.entityType);
        for (String value : inclusion) {
            if (names.contains(value)) continue;
            throw new AptException((MessageResource)Message.DOMA4493, this.method, this.returningAnnot.getAnnotationMirror(), this.returningAnnot.getInclude(), new Object[]{value, this.entityType});
        }
        for (String value : exclusion) {
            if (names.contains(value)) continue;
            throw new AptException((MessageResource)Message.DOMA4494, this.method, this.returningAnnot.getAnnotationMirror(), this.returningAnnot.getExclude(), new Object[]{value, this.entityType});
        }
    }
}

