/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.LinkedHashMap;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.BatchModifyAnnot;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.query.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.validator.BatchSqlValidator;
import org.seasar.doma.internal.apt.validator.SqlValidator;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileBatchModifyQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileBatchModifyQueryMeta> {
    public SqlFileBatchModifyQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    public QueryMeta createQueryMeta() {
        SqlFileBatchModifyQueryMeta queryMeta = this.createSqlFileBatchModifyQueryMeta();
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta);
        this.doParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doThrowTypes(queryMeta);
        this.doSqlTemplate(queryMeta, false, queryMeta.isPopulatable());
        return queryMeta;
    }

    private SqlFileBatchModifyQueryMeta createSqlFileBatchModifyQueryMeta() {
        SqlFileBatchModifyQueryMeta queryMeta = new SqlFileBatchModifyQueryMeta(this.daoElement, this.methodElement);
        SqlAnnot sqlAnnot = this.ctx.getAnnotations().newSqlAnnot(this.methodElement);
        queryMeta.setSqlAnnot(sqlAnnot);
        BatchModifyAnnot batchModifyAnnot = this.ctx.getAnnotations().newBatchInsertAnnot(this.methodElement);
        if (batchModifyAnnot != null && this.usesSqlTemplate(sqlAnnot, batchModifyAnnot)) {
            queryMeta.setBatchModifyAnnot(batchModifyAnnot);
            queryMeta.setQueryKind(QueryKind.SQLFILE_BATCH_INSERT);
            return queryMeta;
        }
        batchModifyAnnot = this.ctx.getAnnotations().newBatchUpdateAnnot(this.methodElement);
        if (batchModifyAnnot != null && this.usesSqlTemplate(sqlAnnot, batchModifyAnnot)) {
            queryMeta.setBatchModifyAnnot(batchModifyAnnot);
            queryMeta.setQueryKind(QueryKind.SQLFILE_BATCH_UPDATE);
            return queryMeta;
        }
        batchModifyAnnot = this.ctx.getAnnotations().newBatchDeleteAnnot(this.methodElement);
        if (batchModifyAnnot != null && this.usesSqlTemplate(sqlAnnot, batchModifyAnnot)) {
            queryMeta.setBatchModifyAnnot(batchModifyAnnot);
            queryMeta.setQueryKind(QueryKind.SQLFILE_BATCH_DELETE);
            return queryMeta;
        }
        return null;
    }

    private boolean usesSqlTemplate(SqlAnnot sqlAnnot, BatchModifyAnnot batchModifyAnnot) {
        return sqlAnnot != null || batchModifyAnnot.getSqlFileValue();
    }

    @Override
    protected void doReturnType(SqlFileBatchModifyQueryMeta queryMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        EntityCtType entityCtType = queryMeta.getEntityType();
        if (entityCtType != null && entityCtType.isImmutable()) {
            if (!returnMeta.isBatchResult(entityCtType)) {
                throw new AptException((MessageResource)Message.DOMA4223, this.methodElement, new Object[0]);
            }
        } else if (!returnMeta.isPrimitiveIntArray()) {
            throw new AptException((MessageResource)Message.DOMA4040, this.methodElement, new Object[0]);
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(final SqlFileBatchModifyQueryMeta queryMeta) {
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.methodElement, new Object[0]);
        }
        QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0));
        IterableCtType iterableCtType = parameterMeta.getCtType().accept(new SimpleCtTypeVisitor<IterableCtType, Void, RuntimeException>(){

            @Override
            protected IterableCtType defaultAction(CtType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4042, SqlFileBatchModifyQueryMetaFactory.this.methodElement, new Object[0]);
            }

            @Override
            public IterableCtType visitIterableCtType(IterableCtType ctType, Void p) throws RuntimeException {
                return ctType;
            }
        }, null);
        CtType elementCtType = iterableCtType.getElementCtType();
        queryMeta.setElementCtType(elementCtType);
        queryMeta.setElementsParameterName(parameterMeta.getName());
        elementCtType.accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

            @Override
            public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
                queryMeta.setEntityType(ctType);
                return null;
            }
        }, null);
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
    }

    @Override
    protected SqlValidator createSqlValidator(LinkedHashMap<String, TypeMirror> parameterTypeMap, String sqlFilePath, boolean expandable, boolean populatable) {
        return new BatchSqlValidator(this.ctx, this.methodElement, parameterTypeMap, sqlFilePath, expandable, populatable);
    }
}

