/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.AggregateStrategy;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.generator.AggregateStrategyTypeGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.JavaFileGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.aggregate.AggregateStrategyMeta;
import org.seasar.doma.internal.apt.meta.aggregate.AggregateStrategyMetaFactory;
import org.seasar.doma.internal.apt.processor.ElementProcessor;
import org.seasar.doma.internal.apt.processor.ElementProcessorSupport;
import org.seasar.doma.internal.util.AssertionUtil;

public class AggregateStrategyProcessor
implements ElementProcessor {
    private final RoundContext ctx;
    private final ElementProcessorSupport<AggregateStrategyMeta> support;
    private final AggregateStrategyMetaFactory factory;

    public AggregateStrategyProcessor(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.support = new ElementProcessorSupport(ctx, AggregateStrategy.class);
        this.factory = new AggregateStrategyMetaFactory(ctx);
    }

    @Override
    public void process(Set<? extends Element> elements) {
        this.support.processTypeElements(elements, this::processEach);
    }

    private AggregateStrategyMeta processEach(TypeElement typeElement) {
        AggregateStrategyMeta meta = this.factory.createTypeElementMeta(typeElement);
        if (!meta.isError()) {
            this.generate(typeElement, meta);
        }
        return meta;
    }

    private void generate(TypeElement typeElement, AggregateStrategyMeta meta) {
        JavaFileGenerator<AggregateStrategyMeta> javaFileGenerator = new JavaFileGenerator<AggregateStrategyMeta>(this.ctx, this::createClassName, this::createGenerator);
        javaFileGenerator.generate(typeElement, meta);
    }

    private TypeElementMetaFactory<AggregateStrategyMeta> createTypeElementMetaFactory() {
        return new AggregateStrategyMetaFactory(this.ctx);
    }

    private ClassName createClassName(TypeElement typeElement, AggregateStrategyMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        return ClassNames.newAggregateStrategyTypeClassName((CharSequence)binaryName);
    }

    private Generator createGenerator(ClassName className, Printer printer, AggregateStrategyMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new AggregateStrategyTypeGenerator(this.ctx, className, printer, meta);
    }
}

