/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.Set;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Dao;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.generator.DaoImplGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.JavaFileGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.dao.DaoMeta;
import org.seasar.doma.internal.apt.meta.dao.DaoMetaFactory;
import org.seasar.doma.internal.apt.processor.ElementProcessor;
import org.seasar.doma.internal.apt.processor.ElementProcessorSupport;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ClassUtil;

public class DaoProcessor
implements ElementProcessor {
    private final RoundContext ctx;
    private final ElementProcessorSupport<DaoMeta> support;
    private final DaoMetaFactory factory;
    private final Function<TypeElement, ClassName> classNameProvider;

    public DaoProcessor(RoundContext ctx) {
        this.ctx = ctx;
        this.support = new ElementProcessorSupport(ctx, Dao.class);
        this.factory = new DaoMetaFactory(ctx);
        this.classNameProvider = typeElement -> {
            DaoImplClassNameBuilder builder = new DaoImplClassNameBuilder((TypeElement)typeElement);
            return builder.build();
        };
    }

    @Override
    public void process(Set<? extends Element> elements) {
        this.support.processTypeElements(elements, this::processEach);
    }

    private DaoMeta processEach(TypeElement typeElement) {
        DaoMeta meta = this.factory.createTypeElementMeta(typeElement);
        if (!meta.isError()) {
            this.generate(typeElement, meta);
        }
        return meta;
    }

    private void generate(TypeElement typeElement, DaoMeta meta) {
        JavaFileGenerator<DaoMeta> javaFileGenerator = new JavaFileGenerator<DaoMeta>(this.ctx, this::createClassName, this::createGenerator);
        javaFileGenerator.generate(typeElement, meta);
    }

    private ClassName createClassName(TypeElement typeElement, DaoMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        return this.classNameProvider.apply(typeElement);
    }

    private Generator createGenerator(ClassName className, Printer printer, DaoMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new DaoImplGenerator(this.ctx, className, printer, meta, this.classNameProvider);
    }

    private class DaoImplClassNameBuilder {
        private final TypeElement typeElement;

        private DaoImplClassNameBuilder(TypeElement typeElement) {
            this.typeElement = typeElement;
        }

        protected String prefix() {
            String daoSubpackage;
            String daoPackage = DaoProcessor.this.ctx.getOptions().getDaoPackage();
            if (daoPackage != null) {
                return daoPackage + ".";
            }
            PackageElement packageElement = DaoProcessor.this.ctx.getMoreElements().getPackageOf(this.typeElement);
            Name packageName = packageElement.getQualifiedName();
            Object base = "";
            if (!packageName.isEmpty()) {
                base = String.valueOf(packageName) + ".";
            }
            if ((daoSubpackage = DaoProcessor.this.ctx.getOptions().getDaoSubpackage()) != null) {
                return (String)base + daoSubpackage + ".";
            }
            return base;
        }

        protected String infix() {
            Name binaryName = DaoProcessor.this.ctx.getMoreElements().getBinaryName(this.typeElement);
            String normalizedName = ClassNames.normalizeBinaryName((CharSequence)binaryName);
            return ClassUtil.getSimpleName((String)normalizedName);
        }

        protected String suffix() {
            return DaoProcessor.this.ctx.getOptions().getDaoSuffix();
        }

        public ClassName build() {
            return new ClassName(this.prefix() + this.infix() + this.suffix());
        }
    }
}

