/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.DomainConverters;
import org.seasar.doma.ExternalDomain;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.DomainConvertersAnnot;
import org.seasar.doma.internal.apt.meta.NullElementMeta;
import org.seasar.doma.internal.apt.processor.ElementProcessor;
import org.seasar.doma.internal.apt.processor.ElementProcessorSupport;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class DomainConvertersProcessor
implements ElementProcessor {
    private final RoundContext ctx;
    private final ElementProcessorSupport<NullElementMeta> support;

    public DomainConvertersProcessor(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.support = new ElementProcessorSupport(ctx, DomainConverters.class);
    }

    @Override
    public void process(Set<? extends Element> elements) {
        this.support.processTypeElements(elements, this::validateEach);
    }

    private NullElementMeta validateEach(TypeElement typeElement) {
        DomainConvertersAnnot convertersMirror = this.ctx.getAnnotations().newDomainConvertersAnnot(typeElement);
        for (TypeMirror convType : convertersMirror.getValueValue()) {
            TypeElement convElement = this.ctx.getMoreTypes().toTypeElement(convType);
            if (convElement == null || convElement.getAnnotation(ExternalDomain.class) != null) continue;
            throw new AptException((MessageResource)Message.DOMA4196, (Element)typeElement, convertersMirror.getAnnotationMirror(), new Object[]{convElement.getQualifiedName()});
        }
        return NullElementMeta.INSTANCE;
    }
}

