/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalOptionException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.meta.ElementMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

class ElementProcessorSupport<M extends ElementMeta> {
    private final RoundContext ctx;
    private final Class<? extends Annotation> supportedAnnotationType;

    ElementProcessorSupport(RoundContext ctx, Class<? extends Annotation> supportedAnnotationType) {
        this.ctx = Objects.requireNonNull(ctx);
        this.supportedAnnotationType = Objects.requireNonNull(supportedAnnotationType);
    }

    List<M> processTypeElements(Set<? extends Element> elements, Function<TypeElement, M> handler) {
        return ElementFilter.typesIn(elements).stream().map(it -> this.handleTypeElement((TypeElement)it, handler)).filter(Objects::nonNull).filter(it -> !it.isError()).toList();
    }

    List<M> processMethodElements(Set<? extends Element> elements, Function<ExecutableElement, M> handler) {
        return ElementFilter.methodsIn(elements).stream().map(it -> this.handleMethodElement((ExecutableElement)it, handler)).filter(Objects::nonNull).filter(it -> !it.isError()).toList();
    }

    private M handleTypeElement(TypeElement element, Function<TypeElement, M> handler) {
        return this.handleElement(element, handler, () -> element.getQualifiedName().toString());
    }

    private M handleMethodElement(ExecutableElement element, Function<ExecutableElement, M> handler) {
        return this.handleElement(element, handler, () -> {
            Element owner = element.getEnclosingElement();
            return String.valueOf(owner) + "#" + String.valueOf(element.getSimpleName());
        });
    }

    private <E extends Element> M handleElement(E element, Function<E, M> handler, Supplier<String> elementNameSupplier) {
        Annotation annotation = element.getAnnotation(this.supportedAnnotationType);
        if (annotation == null) {
            return null;
        }
        if (this.ctx.getOptions().isDebugEnabled()) {
            this.ctx.getReporter().debug((MessageResource)Message.DOMA4090, new Object[]{this.getClass().getName(), elementNameSupplier.get()});
        }
        ElementMeta result = null;
        try {
            if (this.ctx.getOptions().isTraceEnabled()) {
                long startTime = System.nanoTime();
                result = (ElementMeta)handler.apply(element);
                long endTime = System.nanoTime();
                long execTimeMillis = TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
                this.ctx.getReporter().debug((MessageResource)Message.DOMA4463, new Object[]{execTimeMillis, this.supportedAnnotationType.getName(), elementNameSupplier.get()});
            } else {
                result = (ElementMeta)handler.apply(element);
            }
        }
        catch (AptException e) {
            this.ctx.getReporter().report(e);
        }
        catch (AptIllegalOptionException e) {
            this.ctx.getReporter().report(Diagnostic.Kind.ERROR, e.getMessage(), element);
            throw e;
        }
        catch (AptIllegalStateException e) {
            String stackTrace = this.getStackTraceAsString(e);
            this.ctx.getReporter().report(Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4039, element, new Object[]{stackTrace});
            throw e;
        }
        catch (AssertionError | RuntimeException e) {
            String stackTrace = this.getStackTraceAsString((Throwable)e);
            this.ctx.getReporter().report(Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4016, element, new Object[]{stackTrace});
            throw e;
        }
        if (this.ctx.getOptions().isDebugEnabled()) {
            this.ctx.getReporter().debug((MessageResource)Message.DOMA4091, new Object[]{this.getClass().getName(), elementNameSupplier.get()});
        }
        return (M)result;
    }

    private String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return ((Object)stringWriter).toString();
    }
}

