/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.seasar.doma.Scope;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.meta.NullElementMeta;
import org.seasar.doma.internal.apt.processor.ElementProcessor;
import org.seasar.doma.internal.apt.processor.ElementProcessorSupport;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class ScopeProcessor
implements ElementProcessor {
    private final RoundContext ctx;
    private final ElementProcessorSupport<NullElementMeta> support;

    public ScopeProcessor(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.support = new ElementProcessorSupport(ctx, Scope.class);
    }

    @Override
    public void process(Set<? extends Element> elements) {
        this.support.processMethodElements(elements, this::validateEach);
    }

    private NullElementMeta validateEach(ExecutableElement method) {
        if (method.getParameters().isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4457, method, new Object[0]);
        }
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers.contains((Object)Modifier.STATIC)) {
            throw new AptException((MessageResource)Message.DOMA4458, method, new Object[0]);
        }
        if (!modifiers.contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4459, method, new Object[0]);
        }
        return NullElementMeta.INSTANCE;
    }
}

