/*
 * Decompiled with CFR 0.152.
 */
package org.secnod.dropwizard.shiro;

import io.dropwizard.ConfiguredBundle;
import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.secnod.dropwizard.shiro.ShiroConfiguration;
import org.secnod.shiro.jersey.AuthInjectionBinder;
import org.secnod.shiro.jersey.AuthorizationFilterFeature;
import org.secnod.shiro.jersey.SubjectFactory;

public abstract class ShiroBundle<T>
implements ConfiguredBundle<T> {
    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) {
        ShiroConfiguration shiroConfig = this.narrow(configuration);
        DropwizardResourceConfig resourceConfig = environment.jersey().getResourceConfig();
        resourceConfig.register((Object)new AuthorizationFilterFeature());
        resourceConfig.register((Object)new SubjectFactory());
        resourceConfig.register((Object)new AuthInjectionBinder());
        Filter shiroFilter = this.createFilter(configuration);
        environment.servlets().addFilter("ShiroFilter", shiroFilter).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{shiroConfig.filterUrlPattern()});
    }

    protected abstract ShiroConfiguration narrow(T var1);

    protected Filter createFilter(final T configuration) {
        ShiroConfiguration shiroConfig = this.narrow(configuration);
        final IniWebEnvironment shiroEnv = new IniWebEnvironment();
        shiroEnv.setConfigLocations(shiroConfig.iniConfigs());
        shiroEnv.init();
        AbstractShiroFilter shiroFilter = new AbstractShiroFilter(){

            public void init() throws Exception {
                Collection<Realm> realms = ShiroBundle.this.createRealms(configuration);
                DefaultWebSecurityManager securityManager = realms.isEmpty() ? shiroEnv.getWebSecurityManager() : new DefaultWebSecurityManager(realms);
                this.setSecurityManager((WebSecurityManager)securityManager);
                this.setFilterChainResolver(shiroEnv.getFilterChainResolver());
            }
        };
        return shiroFilter;
    }

    protected Collection<Realm> createRealms(T configuration) {
        return Collections.emptyList();
    }
}

