/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class AzConv
extends Conversions {
    protected AzConv() {
        super(SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_AZIMUTHAL_2D, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_2D, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new AzConv();
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        switch (destSrfType) {
            case SRFTCOD_LOCAL_SPACE_RECT_2D: {
                retValid = CoordCheck.forLocalSpaceAzimuthal2D(src);
                dest[0] = src[1] * Math.sin(src[0]);
                dest[1] = src[1] * Math.cos(src[0]);
                retValid = CoordCheck.forNaN_2D(dest);
                break;
            }
            case SRFTCOD_UNSPECIFIED: {
                dest[0] = src[0];
                dest[1] = src[1];
            }
        }
        return retValid;
    }
}

