/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF_2D;
import SRM.CacheManager;
import SRM.Const;
import SRM.Coord;
import SRM.Coord2D;
import SRM.Coord3D;
import SRM.CoordCheck;
import SRM.CreateSRF;
import SRM.OpManager;
import SRM.OrmData;
import SRM.OrmDataSet;
import SRM.RtDataSet;
import SRM.SRF_Celestiocentric;
import SRM.SRF_Celestiodetic;
import SRM.SRF_PolarStereographic;
import SRM.SRF_TransverseMercator;
import SRM.SRM_CS_Code;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFSM_Code;
import SRM.SRM_SRFSM_Japan_Rectangular_Plane_CS_Code;
import SRM.SRM_SRFSM_Lambert_NTF_Code;
import SRM.SRM_SRFSM_UTM_Code;
import SRM.SRM_SRFS_Code;
import SRM.SRM_SRFT_Code;
import SRM.SRM_SRF_Code;
import SRM.SrmException;
import java.util.HashMap;

public abstract class BaseSRF
implements Cloneable {
    private SRM_SRF_Code _mySrfCode = SRM_SRF_Code.SRFCOD_UNSPECIFIED;
    private SRM_SRFS_Code _mySrfsCode = SRM_SRFS_Code.SRFSCOD_UNSPECIFIED;
    private SRM_SRFSM_Code _mySrfsMemberCode = null;
    protected SRM_ORM_Code _orm;
    protected SRM_RT_Code _rt;
    protected SRM_SRFT_Code _mySrftCode = SRM_SRFT_Code.SRFTCOD_UNSPECIFIED;
    protected SRM_CS_Code _myCsCode = SRM_CS_Code.CSCOD_UNSPECIFIED;
    protected CacheManager _myOpSeq;
    protected HashMap<String, BaseSRF> _internalSRFs;

    public static BaseSRF createStandardSRF(SRM_SRF_Code srf_code, SRM_RT_Code rt_code) throws SrmException {
        if (srf_code == null) {
            throw new SrmException(8, new String("createStandardSRF: null reference srf code"));
        }
        if (srf_code == SRM_SRF_Code.SRFCOD_UNSPECIFIED) {
            throw new SrmException(8, new String("createStandardSRF: UNSPECIFIED SRF is not valid for this operation"));
        }
        if (rt_code == null) {
            throw new SrmException(8, new String("createStandardSRF: null reference rt code"));
        }
        return CreateSRF.standardSRF(srf_code, rt_code);
    }

    public static BaseSRF createSRFSetMember(SRM_SRFS_Code srf_set, SRM_SRFSM_Code set_member, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (srf_set == null || set_member == null || orm == null || rt == null) {
            throw new SrmException(8, new String("createSRFSetMember: null reference input parameter"));
        }
        if (srf_set == SRM_SRFS_Code.SRFSCOD_UNSPECIFIED) {
            throw new SrmException(8, new String("createSRFSetMember: UNSPECIFIED SRF is not valid for this operation"));
        }
        return CreateSRF.srfSetMember(srf_set, set_member, orm, rt);
    }

    public SRM_SRF_Code getSRFCode() {
        return this._mySrfCode;
    }

    public SRM_SRFT_Code getSRFTemplateCode() {
        return this._mySrftCode;
    }

    public SRM_SRFS_Code getSRFSetCode() {
        return this._mySrfsCode;
    }

    public SRM_SRFSM_Code getSRFSetMemberCode() {
        return this._mySrfsMemberCode;
    }

    public SRM_CS_Code getCSCode() {
        return this._myCsCode;
    }

    public SRM_ORM_Code get_orm() {
        return this._orm;
    }

    public SRM_ORM_Code getOrm() {
        return this._orm;
    }

    public SRM_RT_Code get_rt() {
        return this._rt;
    }

    public SRM_RT_Code getRt() {
        return this._rt;
    }

    public double getA() {
        return new OrmData((SRM_ORM_Code)this.getOrm()).A;
    }

    public double getF() {
        return new OrmData((SRM_ORM_Code)this.getOrm()).F;
    }

    public static boolean querySRFTSupport(SRM_SRFT_Code srft_code) {
        return srft_code != SRM_SRFT_Code.SRFTCOD_UNSPECIFIED;
    }

    static boolean queryORMSupport(SRM_ORM_Code orm_code, SRM_RT_Code rt_code) {
        return RtDataSet.isValidPair(orm_code, rt_code);
    }

    public SRM_Coordinate_Valid_Region_Code changeCoordinateSRF(Coord src, Coord tgt) throws SrmException {
        double[] tgtValues = new double[3];
        if (src == null || tgt == null) {
            throw new SrmException(8, new String("changeCoordinateSRF: null reference input parameter"));
        }
        if (src instanceof Coord3D && tgt instanceof Coord3D) {
            SRM_Coordinate_Valid_Region_Code retValid = OpManager.instance().computeAsArray(src.getSRF(), this, src.getValues(), tgtValues, null);
            ((Coord3D)tgt).setValues(tgtValues);
            return retValid;
        }
        if (src instanceof Coord2D && tgt instanceof Coord2D) {
            double[] srcValues = new double[]{src.getValues()[0], src.getValues()[1], 0.0};
            SRM_Coordinate_Valid_Region_Code retValid = OpManager.instance().computeAsArray(src.getSRF(), this, srcValues, tgtValues, null);
            ((Coord2D)tgt).setValues(tgtValues);
            return retValid;
        }
        throw new SrmException(8, new String("changeCoordinateSRF: Input coordinate of different dimensions"));
    }

    public SRM_Coordinate_Valid_Region_Code checkCoordinate(Coord src) throws SrmException {
        if (src == null) {
            throw new SrmException(8, new String("checkCoordinate: null reference input parameter"));
        }
        if (src.getSRF() != this) {
            throw new SrmException(5, new String("checkCoordinate: Coordinate associated with different SRF"));
        }
        SRM_SRFT_Code myBoundaryTemplateSrf = CoordCheck.getsrfBoundaryDefTemplate(this);
        SRM_Coordinate_Valid_Region_Code retValidity = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        SRM_SRFS_Code mySrfSet = this.getSRFSetCode();
        if (myBoundaryTemplateSrf != this.getSRFTemplateCode()) {
            BaseSRF tmpSrf;
            double[] coord_tgt = new double[3];
            if (this._internalSRFs == null) {
                this._internalSRFs = new HashMap();
            }
            if ((tmpSrf = this._internalSRFs.get("IntCheckBoundSrfT")) == null) {
                tmpSrf = CreateSRF.fromCode(myBoundaryTemplateSrf, this.getOrm(), this.getRt());
                this._internalSRFs.put("IntCheckBoundSrfT", tmpSrf);
            }
            retValidity = OpManager.instance().computeAsArray(this, tmpSrf, src.getValues(), coord_tgt, null);
            if (this.getSRFSetCode() != SRM_SRFS_Code.SRFSCOD_UNSPECIFIED) {
                switch (mySrfSet) {
                    case SRFSCOD_ALABAMA_SPCS: {
                        retValidity = CoordCheck.forALSP_cd(new OrmData(this.getOrm()), ((SRF_TransverseMercator)this).getSRFParameters(), coord_tgt);
                        break;
                    }
                    case SRFSCOD_GTRS_GLOBAL_COORDINATE_SYSTEM: {
                        retValidity = CoordCheck.forGTRS_cd(this.getSRFSetMemberCode(), coord_tgt);
                        break;
                    }
                    case SRFSCOD_JAPAN_RECTANGULAR_PLANE_CS: {
                        retValidity = CoordCheck.forJapan_cd(new OrmData(this.getOrm()), (SRM_SRFSM_Japan_Rectangular_Plane_CS_Code)this.getSRFSetMemberCode(), ((SRF_TransverseMercator)this).getSRFParameters(), coord_tgt);
                        break;
                    }
                    case SRFSCOD_LAMBERT_NTF: {
                        retValidity = CoordCheck.forLNTF_cd(new OrmData(this.getOrm()), (SRM_SRFSM_Lambert_NTF_Code)this.getSRFSetMemberCode(), coord_tgt);
                        break;
                    }
                    case SRFSCOD_UNIVERSAL_POLAR_STEREOGRAPHIC: {
                        retValidity = CoordCheck.forUPS_cd(((SRF_PolarStereographic)this).getSRFParameters(), coord_tgt);
                        break;
                    }
                    case SRFSCOD_UNIVERSAL_TRANSVERSE_MERCATOR: {
                        retValidity = CoordCheck.forUTM_cd(new OrmData(this.getOrm()), ((SRF_TransverseMercator)this).getSRFParameters(), (SRM_SRFSM_UTM_Code)this.getSRFSetMemberCode(), coord_tgt);
                        break;
                    }
                    case SRFSCOD_WISCONSIN_SPCS: {
                        retValidity = CoordCheck.forWISP_cd(new OrmData(this.getOrm()), coord_tgt);
                        break;
                    }
                    default: {
                        throw new SrmException(3, new String("checkCoordinate: Unsupported SRM_SRFS_Code"));
                    }
                }
            }
        } else if (myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC) {
            OrmData ormData = new OrmData(this.getOrm());
            retValidity = CoordCheck.forCelestiodetic(ormData, src.getValues());
            ormData = null;
        } else if (myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_3D || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_LOCOCENTRIC_EUCLIDEAN_3D || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_SOLAR_MAGNETIC_ECLIPTIC || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_SOLAR_MAGNETIC_DIPOLE) {
            retValidity = CoordCheck.forNaN_3D(src.getValues());
        } else if (myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_CYLINDRICAL) {
            retValidity = CoordCheck.forCylindrical(src.getValues());
        } else if (myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_AZIMUTHAL_SPHERICAL) {
            retValidity = CoordCheck.forAzSpherical(src.getValues());
        } else if (myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_CELESTIOMAGNETIC || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_EQUATORIAL_INERTIAL || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_SOLAR_ECLIPTIC || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_SOLAR_EQUATORIAL || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_HELIOSPHERIC_ARIES_ECLIPTIC || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_ECLIPTIC || myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_EQUATORIAL) {
            retValidity = CoordCheck.forSpherical(src.getValues());
        } else if (myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_2D) {
            retValidity = CoordCheck.forNaN_2D(src.getValues());
        } else if (myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_AZIMUTHAL_2D) {
            retValidity = CoordCheck.forLocalSpaceAzimuthal2D(src.getValues());
        } else if (myBoundaryTemplateSrf == SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_POLAR_2D) {
            retValidity = CoordCheck.forLocalSpacePolar(src.getValues());
        }
        return retValidity;
    }

    public static double calculateEuclideanDistance(Coord coord1, Coord coord2) throws SrmException {
        if (coord1 == null || coord2 == null) {
            throw new SrmException(8, new String("calculateEuclideanDistance: null reference input parameter"));
        }
        if (coord1.getSRF() instanceof BaseSRF_2D || coord2.getSRF() instanceof BaseSRF_2D) {
            throw new SrmException(19, new String("calculateEuclideanDistance: Not implemented for 2D coordinates in this release"));
        }
        if (OrmDataSet.getElem((SRM_ORM_Code)coord1.getSRF().getOrm())._reference_orm != OrmDataSet.getElem((SRM_ORM_Code)coord2.getSRF().getOrm())._reference_orm) {
            throw new SrmException(8, new String("calculateEuclideanDistance: coordinates associated with different reference ORMs"));
        }
        double[] tempCcSrcCoord = BaseSRF.interimConv(coord1, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
        double[] tempCcTgtCoord = BaseSRF.interimConv(coord2, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
        double delta_x = tempCcSrcCoord[0] - tempCcTgtCoord[0];
        double delta_y = tempCcSrcCoord[1] - tempCcTgtCoord[1];
        double delta_z = tempCcSrcCoord[2] - tempCcTgtCoord[2];
        return Math.sqrt(Const.square(delta_x) + Const.square(delta_y) + Const.square(delta_z));
    }

    public static String getImplVerInfo() {
        return new String("4.4.0");
    }

    public String toString() {
        String retString = new String();
        retString = retString + "orm: " + this._orm + "\n";
        retString = retString + "rt: " + this._rt;
        return retString;
    }

    public abstract boolean isEqual(BaseSRF var1);

    public BaseSRF makeClone() throws SrmException {
        try {
            return (BaseSRF)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new SrmException(20, new String("BaseSRF.makeClone(): failed"));
        }
    }

    protected void setSrfCode(SRM_SRF_Code srfCode) {
        this._mySrfCode = srfCode;
    }

    protected void setSrfSetCode(SRM_SRFS_Code srfSetCode) {
        this._mySrfsCode = srfSetCode;
    }

    protected void setSrfSetMemberCode(SRM_SRFSM_Code srfSetMemberCode) {
        this._mySrfsMemberCode = srfSetMemberCode;
    }

    protected static double[] interimConv(Coord src_coord, SRM_SRFT_Code tgt_srft) throws SrmException {
        BaseSRF tmpTgtSrf;
        BaseSRF src_srf = src_coord.getSRF();
        double[] tmpTgtCoord = new double[4];
        double[] tmpSrcCoord = new double[4];
        if (src_srf._internalSRFs == null) {
            src_srf._internalSRFs = new HashMap();
        }
        if (tgt_srft == SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC) {
            tmpTgtSrf = src_srf._internalSRFs.get("Interim_Cc");
            if (tmpTgtSrf == null) {
                tmpTgtSrf = new SRF_Celestiocentric(src_srf.getOrm(), src_srf.getRt());
            }
            src_srf._internalSRFs.put("Interim_Cc", tmpTgtSrf);
        } else if (tgt_srft == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC) {
            tmpTgtSrf = src_srf._internalSRFs.get("Interim_Cd");
            if (tmpTgtSrf == null) {
                tmpTgtSrf = new SRF_Celestiodetic(src_srf.getOrm(), src_srf.getRt());
            }
            src_srf._internalSRFs.put("Interim_Cd", tmpTgtSrf);
        } else {
            throw new SrmException(12, "Operation not supported due to SRF incompatibility");
        }
        tmpSrcCoord[0] = src_coord.getValues()[0];
        tmpSrcCoord[1] = src_coord.getValues()[1];
        tmpSrcCoord[2] = src_coord instanceof Coord3D ? src_coord.getValues()[2] : 0.0;
        OpManager.instance().computeAsArray(src_srf, tmpTgtSrf, tmpSrcCoord, tmpTgtCoord, null);
        return tmpTgtCoord;
    }
}

