/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_MapProjection;
import SRM.Const;
import SRM.Coord3D;
import SRM.CoordCheck;
import SRM.Coord_ClassType;
import SRM.CreateSRF;
import SRM.Direction;
import SRM.DirectionSupport;
import SRM.NaturalSetMember;
import SRM.OpManager;
import SRM.Orientation;
import SRM.OrientationMatrix;
import SRM.OrmData;
import SRM.OrmDataSet;
import SRM.SRF_LCE_3D_Params;
import SRM.SRF_LocalTangentSpaceEuclidean;
import SRM.SRF_LococentricEuclidean3D;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_Extended_Valid_Region_Params;
import SRM.SRM_Interval_Type;
import SRM.SRM_Matrix_3x3;
import SRM.SRM_ORM_Code;
import SRM.SRM_ORM_Trans_3D_Params;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFSM_Code;
import SRM.SRM_SRFS_Code;
import SRM.SRM_SRFT_Code;
import SRM.SRM_Valid_Region_Params;
import SRM.SrmException;
import java.util.HashMap;

public abstract class BaseSRF_3D
extends BaseSRF {
    protected SRM_Extended_Valid_Region_Params[] _component_valid_region = new SRM_Extended_Valid_Region_Params[3];
    protected boolean[] _component_is_angular = new boolean[]{false, false, false};

    public abstract Coord3D createCoordinate3D();

    public abstract Coord3D createCoordinate3D(double var1, double var3, double var5);

    public double[] getCoordinate3DValues(Coord3D coord) throws SrmException {
        if (coord == null) {
            throw new SrmException(8, new String("getCoordinate3DValues: null reference input parameter"));
        }
        if (coord.getSRF() != this) {
            throw new SrmException(5, new String("getCoordinate3DValues: Coordinate associated with different SRF"));
        }
        return coord.getValues();
    }

    public SRM_Coordinate_Valid_Region_Code changeCoordinate3DSRF(Coord3D src, Coord3D tgt) throws SrmException {
        double[] tgtValues = new double[3];
        if (src == null || tgt == null) {
            throw new SrmException(8, new String("changeCoordinate3DSRF: null reference input parameters"));
        }
        SRM_Coordinate_Valid_Region_Code retValid = OpManager.instance().computeAsArray(src.getSRF(), this, src.getValues(), tgtValues, null);
        tgt.setValues(tgtValues);
        return retValid;
    }

    public int changeCoordinate3DArraySRF(Coord3D[] src, Coord3D[] tgt, SRM_Coordinate_Valid_Region_Code[] region) throws SrmException {
        boolean has_no_failure = true;
        double[] tgtValues = new double[3];
        if (src.length != tgt.length || src.length != region.length) {
            throw new SrmException(8, new String("changeCoordinate3DArraySRF: inconsistent array size"));
        }
        int retIndex = src.length + 1;
        for (int i = 0; i < src.length && has_no_failure; ++i) {
            try {
                if (src[i] == null || tgt[i] == null) {
                    throw new SrmException(8, new String("changeCoordinate3DArraySRF: null array element"));
                }
                region[i] = OpManager.instance().computeAsArray(src[i].getSRF(), this, src[i].getValues(), tgtValues, null);
                tgt[i].setValues(tgtValues);
                continue;
            }
            catch (SrmException ex) {
                retIndex = i;
                has_no_failure = false;
            }
        }
        return retIndex;
    }

    public void setValidRegion(int component, SRM_Interval_Type type, double lower, double upper) throws SrmException {
        if (component < 1 || component > 3) {
            throw new SrmException(8, "setValidRegion: component out of range [ 1, 3 ]");
        }
        SRM_SRFT_Code srft_code = this.getSRFTemplateCode();
        if (srft_code == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC || srft_code == SRM_SRFT_Code.SRFTCOD_PLANETODETIC) {
            if (component == 1) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setValidRegion: component 1 (longitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!Const.isWellFormedLongitude(lower) || !Const.isWellFormedLongitude(upper)) {
                            throw new SrmException(8, "setValidRegion: component 1 (longitude) out of range (-PI, PI]");
                        }
                        if (lower != upper) break;
                        throw new SrmException(8, "setValidRegion: component 1 (longitude) lower and upper bounds are the same");
                    }
                }
                this._component_is_angular[component] = true;
            } else if (component == 2) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setValidRegion: component 2 (latitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!Const.isWellFormedLatitude(lower) || !Const.isWellFormedLatitude(upper)) {
                            throw new SrmException(8, "setValidRegion: component 2 (latitude) out of range (-PI/2, PI/2)");
                        }
                        if (lower != upper) break;
                        throw new SrmException(8, "setValidRegion: component 2 (latitude) lower and upper bounds are the same");
                    }
                }
                this._component_is_angular[component] = true;
            } else {
                switch (type) {
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(upper <= lower)) break;
                        throw new SrmException(8, "setValidRegion: component 3 (height) lower bound greater than upper bound");
                    }
                }
            }
        } else if (srft_code == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_AZIMUTHAL_SPHERICAL) {
            if (component == 1) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setValidRegion: component 1 (longitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!Const.isWellFormedAzimuth(lower) || !Const.isWellFormedAzimuth(upper)) {
                            throw new SrmException(8, "setValidRegion: component 1 (longitude) out of range (-PI, PI]");
                        }
                        if (lower != upper) break;
                        throw new SrmException(8, "setValidRegion: component 1 (longitude) lower and upper bounds are the same");
                    }
                }
                this._component_is_angular[component] = true;
            } else if (component == 2) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setValidRegion: component 2 (latitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!Const.isWellFormedLatitude(lower) || !Const.isWellFormedLatitude(upper)) {
                            throw new SrmException(8, "setValidRegion: component 2 (latitude) out of range (-PI/2, PI/2)");
                        }
                        if (lower != upper) break;
                        throw new SrmException(8, "setValidRegion: component 2 (latitude) lower and upper bounds are the same");
                    }
                }
                this._component_is_angular[component] = true;
            } else {
                switch (type) {
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (upper <= lower) {
                            throw new SrmException(8, "setValidRegion: component 3 (height) lower bound greater than upper bound");
                        }
                        if (!(upper <= 0.0) && !(lower <= 0.0)) break;
                        throw new SrmException(8, "setValidRegion: component 3 (height) bounds lower than minor semi-axes length");
                    }
                }
            }
        } else if (srft_code == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_CYLINDRICAL) {
            if (component == 1) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setValidRegion: component 1 (longitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!Const.isWellFormedLongitude(lower) || !Const.isWellFormedLongitude(upper)) {
                            throw new SrmException(8, "setValidRegion: component 1 (longitude) out of range (-PI, PI]");
                        }
                        if (lower != upper) break;
                        throw new SrmException(8, "setValidRegion: component 1 (longitude) lower and upper bounds are the same");
                    }
                }
                this._component_is_angular[component] = true;
            } else if (component == 2) {
                switch (type) {
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (upper <= lower) {
                            throw new SrmException(8, "setValidRegion: component 2 (height) lower bound greater than upper bound");
                        }
                        if (!(upper <= 0.0) && !(lower <= 0.0)) break;
                        throw new SrmException(8, "setValidRegion: component 2 (height) bounds lower than minor semi-axes length");
                    }
                }
            }
        } else if (srft_code == SRM_SRFT_Code.SRFTCOD_CELESTIOMAGNETIC || srft_code == SRM_SRFT_Code.SRFTCOD_SOLAR_ECLIPTIC || srft_code == SRM_SRFT_Code.SRFTCOD_SOLAR_EQUATORIAL || srft_code == SRM_SRFT_Code.SRFTCOD_HELIOSPHERIC_ARIES_ECLIPTIC || srft_code == SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_ECLIPTIC || srft_code == SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_EQUATORIAL) {
            if (component == 1) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setValidRegion: component 1 (longitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!Const.isWellFormedLongitude(lower) || !Const.isWellFormedLongitude(upper)) {
                            throw new SrmException(8, "setValidRegion: component 1 (longitude) out of range (-PI, PI]");
                        }
                        if (lower != upper) break;
                        throw new SrmException(8, "setValidRegion: component 1 (longitude) lower and upper bounds are the same");
                    }
                }
                this._component_is_angular[component] = true;
            } else if (component == 2) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setValidRegion: component 2 (latitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!Const.isWellFormedLatitude(lower) || !Const.isWellFormedLatitude(upper)) {
                            throw new SrmException(8, "setValidRegion: component 2 (latitude) out of range (-PI/2, PI/2)");
                        }
                        if (lower != upper) break;
                        throw new SrmException(8, "setValidRegion: component 2 (latitude) lower and upper bounds are the same");
                    }
                }
                this._component_is_angular[component] = true;
            } else {
                switch (type) {
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (upper <= lower) {
                            throw new SrmException(8, "setValidRegion: component 3 (height) lower bound greater than upper bound");
                        }
                        if (!(upper <= 0.0) && !(lower <= 0.0)) break;
                        throw new SrmException(8, "setValidRegion: component 3 (height) bounds lower than minor semi-axes length");
                    }
                }
            }
        } else {
            switch (type) {
                case IVLTYP_OPEN_INTERVAL: 
                case IVLTYP_GE_LT_INTERVAL: 
                case IVLTYP_GT_LE_INTERVAL: 
                case IVLTYP_CLOSED_INTERVAL: {
                    if (!(upper <= lower)) break;
                    throw new SrmException(8, "setValidRegion: int_interval lower bound greater than upper bound");
                }
            }
        }
        if (this._component_valid_region[component - 1] == null) {
            this._component_valid_region[component - 1] = new SRM_Extended_Valid_Region_Params();
        }
        this._component_valid_region[component - 1].type = type;
        this._component_valid_region[component - 1].lower = lower;
        this._component_valid_region[component - 1].upper = upper;
    }

    public void setExtendedValidRegion(int component, SRM_Interval_Type type, double extended_lower, double lower, double upper, double extended_upper) throws SrmException {
        if (component < 1 || component > 3) {
            throw new SrmException(8, "setExtendedValidRegion: component out of range [ 1, 3 ]");
        }
        SRM_SRFT_Code srft_code = this.getSRFTemplateCode();
        if (srft_code == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC || srft_code == SRM_SRFT_Code.SRFTCOD_PLANETODETIC) {
            if (component == 1) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(Const.isWellFormedLongitude(lower) && Const.isWellFormedLongitude(upper) && Const.isWellFormedLongitude(extended_lower) && Const.isWellFormedLongitude(extended_upper))) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) out of range (-PI, PI]");
                        }
                        if (lower == upper) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) lower and upper bounds are the same");
                        }
                        if (lower < upper && (extended_lower > lower || extended_upper < upper)) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) extended bounds falls within valid region");
                        }
                        if (!(lower > upper) || !(extended_lower < lower) && !(extended_upper > upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) extended bounds falls within valid region");
                    }
                }
                this._component_is_angular[component] = true;
            } else if (component == 2) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(Const.isWellFormedLatitude(lower) && Const.isWellFormedLatitude(upper) && Const.isWellFormedLatitude(extended_lower) && Const.isWellFormedLatitude(extended_upper))) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) out of range (-PI/2, PI/2)");
                        }
                        if (lower == upper) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) lower and upper bounds are the same");
                        }
                        if (lower < upper && (extended_lower > lower || extended_upper < upper)) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) extended bounds falls within valid region");
                        }
                        if (!(lower > upper) || !(extended_lower < lower) && !(extended_upper > upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) extended bounds falls within valid region");
                    }
                }
                this._component_is_angular[component] = true;
            } else {
                switch (type) {
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(upper <= lower)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 3 (height) lower bound greater than upper bound");
                    }
                }
            }
        } else if (srft_code == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_AZIMUTHAL_SPHERICAL) {
            if (component == 1) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(Const.isWellFormedAzimuth(lower) && Const.isWellFormedAzimuth(upper) && Const.isWellFormedAzimuth(extended_lower) && Const.isWellFormedAzimuth(extended_upper))) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) out of range (-PI, PI]");
                        }
                        if (lower == upper) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) lower and upper bounds are the same");
                        }
                        if (lower < upper && (extended_lower > lower || extended_upper < upper)) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) extended bounds falls within valid region");
                        }
                        if (!(lower > upper) || !(extended_lower < lower) && !(extended_upper > upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) extended bounds falls within valid region");
                    }
                }
                this._component_is_angular[component] = true;
            } else if (component == 2) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(Const.isWellFormedLatitude(lower) && Const.isWellFormedLatitude(upper) && Const.isWellFormedLatitude(extended_lower) && Const.isWellFormedLatitude(extended_upper))) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) out of range (-PI/2, PI/2)");
                        }
                        if (lower == upper) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) lower and upper bounds are the same");
                        }
                        if (lower < upper && (extended_lower > lower || extended_upper < upper)) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) extended bounds falls within valid region");
                        }
                        if (!(lower > upper) || !(extended_lower < lower) && !(extended_upper > upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) extended bounds falls within valid region");
                    }
                }
                this._component_is_angular[component] = true;
            } else {
                switch (type) {
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (upper <= lower) {
                            throw new SrmException(8, "setExtendedValidRegion: component 3 (height) lower bound greater than upper bound");
                        }
                        if (!(upper <= 0.0) && !(lower <= 0.0)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 3 (height) bounds lower than minor semi-axes length");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: {
                        if (upper <= lower) {
                            throw new SrmException(8, "setExtendedValidRegion: component 3 (height) lower bound greater than upper bound");
                        }
                        if (upper <= 0.0 || lower <= 0.0) {
                            throw new SrmException(8, "setExtendedValidRegion: component 3 (height) bounds lower than minor semi-axes length");
                        }
                        if (!(extended_lower <= 0.0) && !(extended_lower > lower) && !(extended_upper < upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 3 (height) extended bounds falls within valid region");
                    }
                }
            }
        } else if (srft_code == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_CYLINDRICAL) {
            if (component == 1) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(Const.isWellFormedCylindricalAngle(lower) && Const.isWellFormedCylindricalAngle(upper) && Const.isWellFormedCylindricalAngle(extended_lower) && Const.isWellFormedCylindricalAngle(extended_upper))) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) out of range (-PI, PI]");
                        }
                        if (lower == upper) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) lower and upper bounds are the same");
                        }
                        if (lower < upper && (extended_lower > lower || extended_upper < upper)) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) extended bounds falls within valid region");
                        }
                        if (!(lower > upper) || !(extended_lower < lower) && !(extended_upper > upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) extended bounds falls within valid region");
                    }
                }
                this._component_is_angular[component] = true;
            } else if (component == 2) {
                switch (type) {
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (upper <= lower) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (height) lower bound greater than upper bound");
                        }
                        if (!(upper <= 0.0) && !(lower <= 0.0)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 2 (height) bounds lower than minor semi-axes length");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: {
                        if (upper <= lower) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (height) lower bound greater than upper bound");
                        }
                        if (upper <= 0.0 || lower <= 0.0) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (height) bounds lower than minor semi-axes length");
                        }
                        if (!(extended_lower <= 0.0) && !(extended_lower > lower) && !(extended_upper < upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 2 (height) extended bounds falls within valid region");
                    }
                }
            }
        } else if (srft_code == SRM_SRFT_Code.SRFTCOD_CELESTIOMAGNETIC || srft_code == SRM_SRFT_Code.SRFTCOD_SOLAR_ECLIPTIC || srft_code == SRM_SRFT_Code.SRFTCOD_SOLAR_EQUATORIAL || srft_code == SRM_SRFT_Code.SRFTCOD_HELIOSPHERIC_ARIES_ECLIPTIC || srft_code == SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_ECLIPTIC || srft_code == SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_EQUATORIAL) {
            if (component == 1) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(Const.isWellFormedLongitude(lower) && Const.isWellFormedLongitude(upper) && Const.isWellFormedLongitude(extended_lower) && Const.isWellFormedLongitude(extended_upper))) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) out of range (-PI, PI]");
                        }
                        if (lower == upper) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) lower and upper bounds are the same");
                        }
                        if (lower < upper && (extended_lower > lower || extended_upper < upper)) {
                            throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) extended bounds falls within valid region");
                        }
                        if (!(lower > upper) || !(extended_lower < lower) && !(extended_upper > upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 1 (longitude) extended bounds falls within valid region");
                    }
                }
                this._component_is_angular[component] = true;
            } else if (component == 2) {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) cannot be a semi-interval region");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: 
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(Const.isWellFormedLatitude(lower) && Const.isWellFormedLatitude(upper) && Const.isWellFormedLatitude(extended_lower) && Const.isWellFormedLatitude(extended_upper))) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) out of range (-PI/2, PI/2)");
                        }
                        if (lower == upper) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) lower and upper bounds are the same");
                        }
                        if (lower < upper && (extended_lower > lower || extended_upper < upper)) {
                            throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) extended bounds falls within valid region");
                        }
                        if (!(lower > upper) || !(extended_lower < lower) && !(extended_upper > upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 2 (latitude) extended bounds falls within valid region");
                    }
                }
                this._component_is_angular[component] = true;
            } else {
                switch (type) {
                    case IVLTYP_GT_SEMI_INTERVAL: 
                    case IVLTYP_GE_SEMI_INTERVAL: 
                    case IVLTYP_LT_SEMI_INTERVAL: 
                    case IVLTYP_LE_SEMI_INTERVAL: {
                        if (!(upper <= lower)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 3 (height) lower bound greater than upper bound");
                    }
                    case IVLTYP_CLOSED_INTERVAL: {
                        if (!(upper <= 0.0) && !(lower <= 0.0)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 3 (height) bounds lower than minor semi-axes length");
                    }
                    case IVLTYP_OPEN_INTERVAL: 
                    case IVLTYP_GE_LT_INTERVAL: 
                    case IVLTYP_GT_LE_INTERVAL: {
                        if (upper <= 0.0 || lower <= 0.0) {
                            throw new SrmException(8, "setExtendedValidRegion: component 3 (height) bounds lower than minor semi-axes length");
                        }
                        if (!(extended_lower <= 0.0) && !(extended_lower > lower) && !(extended_upper < upper)) break;
                        throw new SrmException(8, "setExtendedValidRegion: component 3 (height) extended bounds falls within valid region");
                    }
                }
            }
        } else {
            switch (type) {
                case IVLTYP_OPEN_INTERVAL: 
                case IVLTYP_GE_LT_INTERVAL: 
                case IVLTYP_GT_LE_INTERVAL: 
                case IVLTYP_CLOSED_INTERVAL: {
                    if (!(upper <= lower)) break;
                    throw new SrmException(8, "setExtendedValidRegion: interval lower bound greater than upper bound");
                }
            }
        }
        if (this._component_valid_region[component - 1] == null) {
            this._component_valid_region[component - 1] = new SRM_Extended_Valid_Region_Params();
        }
        this._component_valid_region[component - 1].type = type;
        this._component_valid_region[component - 1].extended_lower = extended_lower;
        this._component_valid_region[component - 1].lower = lower;
        this._component_valid_region[component - 1].upper = upper;
        this._component_valid_region[component - 1].extended_upper = extended_upper;
    }

    public SRM_Valid_Region_Params getValidRegion(int component) throws SrmException {
        SRM_Valid_Region_Params ret_reg = new SRM_Valid_Region_Params();
        if (component < 1 || component > 3) {
            throw new SrmException(8, "getValidRegion: component out of range [ 1, 3 ]");
        }
        ret_reg.type = this._component_valid_region[component - 1].type;
        ret_reg.lower = this._component_valid_region[component - 1].lower;
        ret_reg.upper = this._component_valid_region[component - 1].upper;
        return ret_reg;
    }

    public SRM_Extended_Valid_Region_Params getExtendedValidRegion(int component) throws SrmException {
        SRM_Extended_Valid_Region_Params ret_reg = new SRM_Extended_Valid_Region_Params();
        if (component < 1 || component > 3) {
            throw new SrmException(8, "getExtendedValidRegion: component out of range [ 1, 3 ]");
        }
        ret_reg.type = this._component_valid_region[component - 1].type;
        ret_reg.extended_lower = this._component_valid_region[component - 1].extended_lower;
        ret_reg.lower = this._component_valid_region[component - 1].lower;
        ret_reg.upper = this._component_valid_region[component - 1].upper;
        ret_reg.extended_upper = this._component_valid_region[component - 1].extended_upper;
        return ret_reg;
    }

    public SRM_Coordinate_Valid_Region_Code changeCoordinate3DSRFObject(Coord3D src, SRM_ORM_Trans_3D_Params hst, Coord3D tgt) throws SrmException {
        double[] tgtValues = new double[3];
        if (src == null || tgt == null || hst == null) {
            throw new SrmException(8, new String("changeCoordinate3DSRFObject: null reference input parameters"));
        }
        SRM_Coordinate_Valid_Region_Code retValid = OpManager.instance().computeAsArray(src.getSRF(), this, src.getValues(), tgtValues, hst);
        tgt.setValues(tgtValues);
        return retValid;
    }

    public int changeCoordinate3DArraySRFObject(Coord3D[] src, SRM_ORM_Trans_3D_Params hst, Coord3D[] tgt, SRM_Coordinate_Valid_Region_Code[] region) throws SrmException {
        boolean has_no_failure = true;
        double[] tgtValues = new double[3];
        if (hst == null) {
            throw new SrmException(8, new String("changeCoordinate3DArraySRFObject: null reference input parameters"));
        }
        if (src.length != tgt.length || src.length != region.length) {
            throw new SrmException(8, new String("changeCoordinate3DArraySRFObject: inconsistent array size"));
        }
        int retIndex = src.length + 1;
        for (int i = 0; i < src.length && has_no_failure; ++i) {
            try {
                if (src[i] == null || tgt[i] == null) {
                    throw new SrmException(8, new String("changeCoordinate3DArraySRFObject: null array element"));
                }
                region[i] = OpManager.instance().computeAsArray(src[i].getSRF(), this, src[i].getValues(), tgtValues, hst);
                tgt[i].setValues(tgtValues);
                continue;
            }
            catch (SrmException ex) {
                retIndex = i;
                has_no_failure = false;
            }
        }
        return retIndex;
    }

    public Direction createDirection(Coord3D ref_coord, double[] vec) throws SrmException {
        if (ref_coord == null || vec == null) {
            throw new SrmException(8, new String("createDirection: null reference input parameter"));
        }
        if (ref_coord.getSRF() != this) {
            throw new SrmException(5, new String("createDirection: Ref. coordinate associated with different SRF"));
        }
        if (vec.length != 3) {
            throw new SrmException(8, new String("createDirection: Input vector is not of size 3"));
        }
        return new Direction(this, ref_coord, vec);
    }

    public Direction createDirection() throws SrmException {
        return new Direction(this, this.createCoordinate3D(), new double[]{Double.NaN, Double.NaN, Double.NaN});
    }

    public void getDirectionValues(Direction direction, Coord3D ref_coord, double[] vec) throws SrmException {
        if (direction == null || ref_coord == null || vec == null) {
            throw new SrmException(8, new String("getDirectionValues: null reference input parameter"));
        }
        if (direction.getSRF() != this) {
            throw new SrmException(5, new String("getDirectionValues: Direction associated with different SRF"));
        }
        if (ref_coord.getSRF() != this) {
            throw new SrmException(5, new String("getDirectionValues: Reference Coordinate associated with different SRF"));
        }
        if (vec.length != 3) {
            throw new SrmException(8, new String("getDirectionValues: Input vector is not of size 3"));
        }
        double[] tmpDir = direction.getVec();
        ref_coord.setValues(direction.getInternalRefCoord().getValues());
        vec[0] = tmpDir[0];
        vec[1] = tmpDir[1];
        vec[2] = tmpDir[2];
    }

    public SRM_Coordinate_Valid_Region_Code changeDirectionSRF(Direction src_dir, Direction tgt_dir) throws SrmException {
        if (src_dir == null || tgt_dir == null) {
            throw new SrmException(8, new String("changeDirectionSRF: null reference input parameter"));
        }
        if (tgt_dir.getSRF() != this) {
            throw new SrmException(8, new String("changeDirectionSRF: Target Direction associated with different SRF"));
        }
        SRM_Coordinate_Valid_Region_Code retValidity = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        double[] dir_values_tgt = new double[3];
        retValidity = this.changeCoordinate3DSRF(src_dir.getInternalRefCoord(), tgt_dir.getInternalRefCoord());
        DirectionSupport.changeDirectionVector((BaseSRF_3D)src_dir.getSRF(), src_dir.getInternalRefCoord(), src_dir.getVec(), this, tgt_dir.getInternalRefCoord(), dir_values_tgt);
        tgt_dir.setVec(dir_values_tgt);
        return retValidity;
    }

    public int changeDirectionArraySRF(Direction[] src_dir, Direction[] tgt_dir, SRM_Coordinate_Valid_Region_Code[] region) throws SrmException {
        boolean has_no_failure = true;
        double[] dir_values_tgt = new double[3];
        if (src_dir.length != tgt_dir.length || src_dir.length != region.length) {
            throw new SrmException(8, new String("changeDirectionArraySRF: inconsistent array size"));
        }
        int retIndex = src_dir.length + 1;
        for (int i = 0; i < src_dir.length && has_no_failure; ++i) {
            try {
                if (src_dir[i] == null || tgt_dir[i] == null) {
                    throw new SrmException(8, new String("changeDirectionArraySRF: null array element"));
                }
                region[i] = this.changeCoordinate3DSRF(src_dir[i].getInternalRefCoord(), tgt_dir[i].getInternalRefCoord());
                DirectionSupport.changeDirectionVector((BaseSRF_3D)src_dir[i].getSRF(), src_dir[i].getInternalRefCoord(), src_dir[i].getVec(), this, tgt_dir[i].getInternalRefCoord(), dir_values_tgt);
                tgt_dir[i].setVec(dir_values_tgt);
                continue;
            }
            catch (SrmException ex) {
                retIndex = i;
                has_no_failure = false;
            }
        }
        return retIndex;
    }

    public SRM_Coordinate_Valid_Region_Code changeDirectionSRFObject(Direction src_dir, SRM_ORM_Trans_3D_Params hst, Direction tgt_dir) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED;
        if (src_dir == null || tgt_dir == null) {
            throw new SrmException(8, new String("changeDirectionSRF: null reference input parameter"));
        }
        if (tgt_dir.getSRF() != this) {
            throw new SrmException(8, new String("changeDirectionSRF: Target Direction associated with different SRF"));
        }
        double[] dir_values_tgt = new double[3];
        try {
            retValid = this.changeCoordinate3DSRFObject(src_dir.getInternalRefCoord(), hst, tgt_dir.getInternalRefCoord());
        }
        catch (SrmException ex) {
            throw new SrmException(12, new String("changeDirectionSRFObject: change reference coodinate SRF not possible"));
        }
        DirectionSupport.changeDirectionVector((BaseSRF_3D)src_dir.getSRF(), src_dir.getInternalRefCoord(), src_dir.getVec(), this, tgt_dir.getInternalRefCoord(), dir_values_tgt);
        tgt_dir.setVec(dir_values_tgt);
        return retValid;
    }

    public int changeDirectionArraySRFObject(Direction[] src_dir, SRM_ORM_Trans_3D_Params hst, Direction[] tgt_dir, SRM_Coordinate_Valid_Region_Code[] region) throws SrmException {
        boolean has_no_failure = true;
        double[] dir_values_tgt = new double[3];
        if (src_dir.length != tgt_dir.length || src_dir.length != region.length) {
            throw new SrmException(8, new String("changeDirectionArraySRF: inconsistent array size"));
        }
        int retIndex = src_dir.length + 1;
        for (int i = 0; i < src_dir.length && has_no_failure; ++i) {
            try {
                if (src_dir[i] == null || tgt_dir[i] == null) {
                    throw new SrmException(8, new String("changeDirectionArraySRF: null array element"));
                }
                region[i] = this.changeCoordinate3DSRFObject(src_dir[i].getInternalRefCoord(), hst, tgt_dir[i].getInternalRefCoord());
                DirectionSupport.changeDirectionVector((BaseSRF_3D)src_dir[i].getSRF(), src_dir[i].getInternalRefCoord(), src_dir[i].getVec(), this, tgt_dir[i].getInternalRefCoord(), dir_values_tgt);
                tgt_dir[i].setVec(dir_values_tgt);
                continue;
            }
            catch (SrmException ex) {
                retIndex = i;
                has_no_failure = false;
            }
        }
        return retIndex;
    }

    public SRM_Coordinate_Valid_Region_Code checkDirection(Direction direction) throws SrmException {
        if (direction == null) {
            throw new SrmException(8, new String("checkDirection: null reference input parameter"));
        }
        if (direction.getSRF() != this) {
            throw new SrmException(5, new String("checkDirection: direction associated with different SRF"));
        }
        SRM_Coordinate_Valid_Region_Code retReg = null;
        retReg = this.checkCoordinate(direction.getInternalRefCoord());
        double[] vec = direction.getVec();
        if (vec[0] * vec[0] + vec[1] * vec[1] + vec[2] * vec[2] <= 1.0E-12) {
            throw new SrmException(7, new String("checkDirection: Direction vector magnitude ~ 0.0 "));
        }
        return retReg;
    }

    public void computeSRFOrientation(Coord3D src_ref_point, Coord3D tgt_ref_point, Orientation out_ori) throws SrmException {
        if (tgt_ref_point.getSRF() != this) {
            throw new SrmException(3, "createSRFOrientation: Target reference coordinate associated with a different SRF");
        }
        LTP_vec src_vec = this.compLTP(src_ref_point.getSRF(), src_ref_point);
        LTP_vec tgt_vec = this.compLTP(this, tgt_ref_point);
        out_ori._set_matrix_base(this.comp_ori_mat(src_vec, tgt_vec));
        out_ori._updateRepData();
    }

    public SRF_LCE_3D_Params getLocalTangentFrameSRFParameters(Coord3D ref_point) throws SrmException {
        SRF_LCE_3D_Params ltf = new SRF_LCE_3D_Params();
        if (ref_point.getSRF() != this) {
            throw new SrmException(3, "getLocalTangentFrameSRFParameters: Reference coordinate associated with a different SRF");
        }
        if (ref_point.getClassType() == Coord_ClassType.LSR_3D) {
            ltf.lococentre[0] = 0.0;
            ltf.lococentre[1] = 0.0;
            ltf.lococentre[2] = 0.0;
        } else if (ref_point.getClassType() == Coord_ClassType.CC_3D) {
            ltf.lococentre[0] = ref_point.getValues()[0];
            ltf.lococentre[1] = ref_point.getValues()[1];
            ltf.lococentre[2] = ref_point.getValues()[2];
        } else {
            double[] tempCcCoord = BaseSRF_3D.interimConv(ref_point, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
            ltf.lococentre[0] = tempCcCoord[0];
            ltf.lococentre[1] = tempCcCoord[1];
            ltf.lococentre[2] = tempCcCoord[2];
        }
        LTP_vec ltp = this.compLTP(this, ref_point);
        System.arraycopy(ltp.r, 0, ltf.primary_axis, 0, 3);
        System.arraycopy(ltp.s, 0, ltf.secondary_axis, 0, 3);
        return ltf;
    }

    public void transformOrientation(Coord3D src_ref_loc, Orientation src_ori, Coord3D tgt_ref_loc, Orientation tgt_ori) throws SrmException {
        OrientationMatrix ori_st = new OrientationMatrix();
        if (tgt_ref_loc.getSRF() != this) {
            throw new SrmException(6, "transformOrientation: Target reference location associated with a different SRF");
        }
        this.computeSRFOrientation(src_ref_loc, tgt_ref_loc, ori_st);
        tgt_ori = OrientationMatrix.compose(ori_st, src_ori);
    }

    public SRM_Coordinate_Valid_Region_Code transformOrientationCommonOrigin(Coord3D src_ref_loc, Orientation src_ori, Coord3D tgt_ref_loc, Orientation tgt_ori) throws SrmException {
        OrientationMatrix ori_st = new OrientationMatrix();
        if (tgt_ref_loc.getSRF() != this) {
            throw new SrmException(6, "transformOrientationCommonOrigin: Target reference location associated with a different SRF");
        }
        SRM_Coordinate_Valid_Region_Code ret_reg = this.changeCoordinate3DSRF(src_ref_loc, tgt_ref_loc);
        this.computeSRFOrientation(src_ref_loc, tgt_ref_loc, ori_st);
        tgt_ori = OrientationMatrix.compose(ori_st, src_ori);
        return ret_reg;
    }

    public void transformVectorInBodyFrame(Coord3D src_ref_loc, Orientation src_ori, double[] src_vec, Coord3D tgt_ref_loc, double[] tgt_vec) throws SrmException {
        OrientationMatrix ori_st = new OrientationMatrix();
        if (tgt_ref_loc.getSRF() != this) {
            throw new SrmException(6, "transformVectorInBodyFrame: Target reference location associated with a different SRF");
        }
        this.computeSRFOrientation(src_ref_loc, tgt_ref_loc, ori_st);
        tgt_vec = OrientationMatrix.compose(ori_st, src_ori).transformVector(src_vec);
    }

    public SRM_Coordinate_Valid_Region_Code transformVectorInBodyFrameCommonOrigin(Coord3D src_ref_loc, Orientation src_ori, double[] src_vec, Coord3D tgt_ref_loc, double[] tgt_vec) throws SrmException {
        OrientationMatrix ori_st = new OrientationMatrix();
        if (tgt_ref_loc.getSRF() != this) {
            throw new SrmException(6, "transformVectorInBodyFrameCommonOrigin: Target reference location associated with a different SRF");
        }
        SRM_Coordinate_Valid_Region_Code ret_reg = this.changeCoordinate3DSRF(src_ref_loc, tgt_ref_loc);
        this.computeSRFOrientation(src_ref_loc, tgt_ref_loc, ori_st);
        tgt_vec = OrientationMatrix.compose(ori_st, src_ori).transformVector(src_vec);
        return ret_reg;
    }

    public void transformVector(Coord3D src_ref_loc, double[] src_vec, Coord3D tgt_ref_loc, double[] tgt_vec) throws SrmException {
        OrientationMatrix ori_st = new OrientationMatrix();
        if (tgt_ref_loc.getSRF() != this) {
            throw new SrmException(6, "transformVector: Target reference location associated with a different SRF");
        }
        this.computeSRFOrientation(src_ref_loc, tgt_ref_loc, ori_st);
        tgt_vec = ori_st.transformVector(src_vec);
    }

    public SRM_Coordinate_Valid_Region_Code transformVectorCommonOrigin(Coord3D src_ref_loc, double[] src_vec, Coord3D tgt_ref_loc, double[] tgt_vec) throws SrmException {
        OrientationMatrix ori_st = new OrientationMatrix();
        if (tgt_ref_loc.getSRF() != this) {
            throw new SrmException(6, "transformVectorCommonOrigin: Target reference location associated with a different SRF");
        }
        SRM_Coordinate_Valid_Region_Code ret_reg = this.changeCoordinate3DSRF(src_ref_loc, tgt_ref_loc);
        this.computeSRFOrientation(src_ref_loc, tgt_ref_loc, ori_st);
        tgt_vec = ori_st.transformVector(src_vec);
        return ret_reg;
    }

    public SRF_LococentricEuclidean3D createLococentricEuclidean3DSRF(Coord3D lococentre, Direction primary_axis, Direction secondary_axis) throws SrmException {
        if (lococentre.getSRF() != this) {
            throw new SrmException(8, "createLococentricEuclidean3DSRF: lococentre associated with a different SRF ");
        }
        if (primary_axis.getSRF() != this) {
            throw new SrmException(7, "createLococentricEuclidean3DSRF: primary axis associated with a different SRF");
        }
        if (secondary_axis.getSRF() != this) {
            throw new SrmException(7, "createLococentricEuclidean3DSRF: secondary axis associated with a different SRF");
        }
        SRF_LCE_3D_Params lce_params = new SRF_LCE_3D_Params();
        LTP_vec ltp_pri = new LTP_vec();
        LTP_vec ltp_sec = new LTP_vec();
        double[] pri_t = new double[3];
        double[] sec_t = new double[3];
        double dot_proc = 0.0;
        try {
            System.arraycopy(BaseSRF_3D.interimConv(lococentre, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC), 0, lce_params.lococentre, 0, 3);
        }
        catch (SrmException ex) {
            throw new SrmException(20, "createLococentricEuclidean3DSRF: Unable to determine lococentre");
        }
        ltp_pri = this.compLTP(this, primary_axis.getRefCoord());
        System.arraycopy(Const.cross_product(ltp_pri.r, ltp_pri.s), 0, pri_t, 0, 3);
        if (primary_axis.getRefCoord().isEqual(secondary_axis.getRefCoord())) {
            System.arraycopy(ltp_pri.r, 0, ltp_sec.r, 0, 3);
            System.arraycopy(ltp_pri.s, 0, ltp_sec.s, 0, 3);
            System.arraycopy(pri_t, 0, sec_t, 0, 3);
        } else {
            ltp_sec = this.compLTP(this, secondary_axis.getRefCoord());
            System.arraycopy(Const.cross_product(ltp_sec.r, ltp_sec.s), 0, sec_t, 0, 3);
        }
        Const.ConstTimesVect(ltp_pri.r, primary_axis.getVectorComp1());
        Const.ConstTimesVect(ltp_pri.s, primary_axis.getVectorComp2());
        Const.ConstTimesVect(pri_t, primary_axis.getVectorComp3());
        lce_params.primary_axis = Const.vectSum(pri_t, Const.vectSum(ltp_pri.r, ltp_pri.s));
        Const.ConstTimesVect(ltp_sec.r, secondary_axis.getVectorComp1());
        Const.ConstTimesVect(ltp_sec.s, secondary_axis.getVectorComp2());
        Const.ConstTimesVect(sec_t, secondary_axis.getVectorComp3());
        lce_params.secondary_axis = Const.vectSum(sec_t, Const.vectSum(ltp_sec.r, ltp_sec.s));
        if (!Const.isEqual(Const.vectDotProd(lce_params.primary_axis, lce_params.secondary_axis), 0.0, 1.0E-6)) {
            throw new SrmException(8, "createLococentricEuclidean3DSRF: the input direction vectors are not orthogonal");
        }
        Const.normalizeDirection(lce_params.primary_axis);
        Const.normalizeDirection(lce_params.secondary_axis);
        return new SRF_LococentricEuclidean3D(this.getOrm(), this.getRt(), lce_params);
    }

    public static double calculateEuclideanDistance(Coord3D coord1, Coord3D coord2) throws SrmException {
        double[] tempCcSrcCoord = new double[3];
        double[] tempCcTgtCoord = new double[3];
        if (coord1 == null || coord2 == null) {
            throw new SrmException(8, new String("calculateEuclideanDistance: null reference input parameter"));
        }
        if (OrmDataSet.getElem((SRM_ORM_Code)coord1.getSRF().getOrm())._reference_orm != OrmDataSet.getElem((SRM_ORM_Code)coord2.getSRF().getOrm())._reference_orm) {
            throw new SrmException(8, new String("calculateEuclideanDistance: coordinates associated with different reference ORMs"));
        }
        tempCcSrcCoord = BaseSRF_3D.interimConv(coord1, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
        tempCcTgtCoord = BaseSRF_3D.interimConv(coord2, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
        double delta_x = tempCcSrcCoord[0] - tempCcTgtCoord[0];
        double delta_y = tempCcSrcCoord[1] - tempCcTgtCoord[1];
        double delta_z = tempCcSrcCoord[2] - tempCcTgtCoord[2];
        return Math.sqrt(Const.square(delta_x) + Const.square(delta_y) + Const.square(delta_z));
    }

    public SRM_SRFSM_Code getNaturalSRFSetMemberCode(Coord3D src_coord, SRM_ORM_Code orm_dst, SRM_RT_Code rt_dst, SRM_SRFS_Code tgt_srfs) throws SrmException {
        if (src_coord == null || orm_dst == null || rt_dst == null || tgt_srfs == null) {
            throw new SrmException(8, new String("getNaturalSRFSetMemberCode: null reference input parameter"));
        }
        if (src_coord.getSRF() != this) {
            throw new SrmException(5, new String("getNaturalSRFSetMemberCode: Coordinate associated with different SRF"));
        }
        return this.getMemberCode(src_coord.getValues(), orm_dst, rt_dst, tgt_srfs);
    }

    public BaseSRF_3D getNaturalSRFSetMember(Coord3D src_coord, SRM_ORM_Code orm_dst, SRM_RT_Code rt_dst, SRM_SRFS_Code tgt_srfs) throws SrmException {
        if (src_coord == null || orm_dst == null || rt_dst == null || tgt_srfs == null) {
            throw new SrmException(8, new String("getNaturalSRFSetMemberCode: null reference input parameter"));
        }
        if (src_coord.getSRF() != this) {
            throw new SrmException(5, new String("getNaturalSRFSetMemberCode: Coordinate associated with different SRF"));
        }
        SRM_SRFSM_Code tmpMemberCode = this.getMemberCode(src_coord.getValues(), orm_dst, rt_dst, tgt_srfs);
        return (BaseSRF_3D)CreateSRF.srfSetMember(tgt_srfs, tmpMemberCode, orm_dst, rt_dst);
    }

    protected SRM_SRFSM_Code getMemberCode(double[] src_coord, SRM_ORM_Code orm_dst, SRM_RT_Code rt_dst, SRM_SRFS_Code tgt_srfs) throws SrmException {
        SRM_SRFSM_Code retSetMember;
        BaseSRF tmpSrf;
        double[] coord_tgt = new double[3];
        if (tgt_srfs == SRM_SRFS_Code.SRFSCOD_UNSPECIFIED) {
            throw new SrmException(8, new String("getNaturalSRFSetMemberCode: UNSPECIFIED SRF Set is not valid for this operation"));
        }
        if (this._internalSRFs == null) {
            this._internalSRFs = new HashMap();
        }
        if ((tmpSrf = (BaseSRF)this._internalSRFs.get("TgtBoundSrfT" + orm_dst + (Object)((Object)tgt_srfs))) == null) {
            SRM_SRFT_Code myBoundaryTemplateSrf = CoordCheck.getsrfsBoundaryDefTemplate(tgt_srfs);
            tmpSrf = CreateSRF.fromCode(myBoundaryTemplateSrf, orm_dst, rt_dst);
            this._internalSRFs.put("NatRegTgtBoundSrfT" + orm_dst + (Object)((Object)tgt_srfs), tmpSrf);
        }
        try {
            OpManager.instance().computeAsArray(this, tmpSrf, src_coord, coord_tgt, null);
        }
        catch (SrmException ex) {
            throw new SrmException(3, new String("No natural set member code for this coordinate"));
        }
        if (tgt_srfs == SRM_SRFS_Code.SRFSCOD_ALABAMA_SPCS) {
            retSetMember = NaturalSetMember.forALSP(coord_tgt);
        } else if (tgt_srfs == SRM_SRFS_Code.SRFSCOD_LAMBERT_NTF) {
            retSetMember = NaturalSetMember.forLAMBERT_NTF(coord_tgt);
        } else if (tgt_srfs == SRM_SRFS_Code.SRFSCOD_GTRS_GLOBAL_COORDINATE_SYSTEM) {
            retSetMember = NaturalSetMember.forGTRS(coord_tgt);
        } else if (tgt_srfs == SRM_SRFS_Code.SRFSCOD_JAPAN_RECTANGULAR_PLANE_CS) {
            retSetMember = NaturalSetMember.forJPRP(coord_tgt);
        } else if (tgt_srfs == SRM_SRFS_Code.SRFSCOD_UNIVERSAL_POLAR_STEREOGRAPHIC) {
            retSetMember = NaturalSetMember.forUPS(coord_tgt);
        } else if (tgt_srfs == SRM_SRFS_Code.SRFSCOD_UNIVERSAL_TRANSVERSE_MERCATOR) {
            retSetMember = NaturalSetMember.forUTM(coord_tgt);
        } else if (tgt_srfs == SRM_SRFS_Code.SRFSCOD_WISCONSIN_SPCS) {
            retSetMember = NaturalSetMember.forWISP(coord_tgt);
        } else {
            throw new SrmException(20, new String("getNaturalSRFSetMemberCode: Inactionable error"));
        }
        return retSetMember;
    }

    protected LTP_vec compLTP(BaseSRF srf, Coord3D coord) throws SrmException {
        LTP_vec ltp = new LTP_vec();
        block0 : switch (srf.getCSCode()) {
            case CSCOD_UNSPECIFIED: {
                throw new SrmException(20, "Received SRF with CSCOD_UNSPECIFIED");
            }
            case CSCOD_EUCLIDEAN_3D: {
                ltp.r[0] = 1.0;
                ltp.s[1] = 1.0;
                break;
            }
            case CSCOD_LOCOCENT_EUCLIDEAN_3D: {
                switch (srf.getSRFTemplateCode()) {
                    case SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN: {
                        double slon = Math.sin(((SRF_LocalTangentSpaceEuclidean)srf).get_geodetic_longitude());
                        double clon = Math.cos(((SRF_LocalTangentSpaceEuclidean)srf).get_geodetic_longitude());
                        double slat = Math.sin(((SRF_LocalTangentSpaceEuclidean)srf).get_geodetic_latitude());
                        double clat = Math.cos(((SRF_LocalTangentSpaceEuclidean)srf).get_geodetic_latitude());
                        double sa = Math.sin(((SRF_LocalTangentSpaceEuclidean)srf).get_azimuth());
                        double ca = Math.cos(((SRF_LocalTangentSpaceEuclidean)srf).get_azimuth());
                        ltp.r[0] = -slon * ca + clon * slat * sa;
                        ltp.r[1] = clon * ca + slon * slat * sa;
                        ltp.r[2] = -clat * sa;
                        ltp.s[0] = -slon * sa - clon * slat * ca;
                        ltp.s[1] = clon * sa - slon * slat * ca;
                        ltp.s[2] = clat * ca;
                        break block0;
                    }
                    case SRFTCOD_LOCOCENTRIC_EUCLIDEAN_3D: {
                        System.arraycopy(((SRF_LococentricEuclidean3D)srf).get_primary_axis(), 0, ltp.r, 0, 3);
                        System.arraycopy(((SRF_LococentricEuclidean3D)srf).get_secondary_axis(), 0, ltp.s, 0, 3);
                        break block0;
                    }
                    case SRFTCOD_LOCAL_SPACE_RECT_3D: {
                        throw new SrmException(12, "unable to determine local tangent frame for abstract LSR_3D");
                    }
                }
                throw new SrmException(20, "Received SRF with CSCOD_UNSPECIFIED");
            }
            case CSCOD_EQUATORIAL_SPHERICAL: {
                double lon = coord.getValues()[0];
                double lat = coord.getValues()[1];
                double slon = Math.sin(lon);
                double clon = Math.cos(lon);
                double slat = Math.sin(lat);
                double clat = Math.cos(lat);
                ltp.r[0] = -slon;
                ltp.r[1] = clon;
                ltp.r[2] = 0.0;
                ltp.s[0] = -slat * clon;
                ltp.s[1] = -slat * slon;
                ltp.s[2] = clat;
                break;
            }
            case CSCOD_GEODETIC: {
                double lon = coord.getValues()[0];
                double lat = coord.getValues()[1];
                double slon = Math.sin(lon);
                double clon = Math.cos(lon);
                double slat = Math.sin(lat);
                double clat = Math.cos(lat);
                ltp.r[0] = -slon;
                ltp.r[1] = clon;
                ltp.r[2] = 0.0;
                ltp.s[0] = -slat * clon;
                ltp.s[1] = -slat * slon;
                ltp.s[2] = clat;
                break;
            }
            case CSCOD_PLANETODETIC: {
                double lat = coord.getValues()[0];
                double lon = coord.getValues()[1];
                double slon = Math.sin(lon);
                double clon = Math.cos(lon);
                double slat = Math.sin(lat);
                double clat = Math.cos(lat);
                ltp.r[0] = -slat * clon;
                ltp.r[1] = -slat * slon;
                ltp.r[2] = clat;
                ltp.s[0] = slon;
                ltp.s[1] = -clon;
                ltp.s[2] = 0.0;
                break;
            }
            case CSCOD_OBLIQUE_MERCATOR_SPHERICAL: 
            case CSCOD_TRANSVERSE_MERCATOR: 
            case CSCOD_LAMBERT_CONFORMAL_CONIC: 
            case CSCOD_POLAR_STEREOGRAPHIC: {
                double[] tempCdCoord = BaseSRF_3D.interimConv(coord, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC);
                if (((BaseSRF_MapProjection)srf)._ormData == null) {
                    ((BaseSRF_MapProjection)srf)._ormData = new OrmData(srf.getOrm());
                }
                double com = ((BaseSRF_MapProjection)srf).comCalculation(((BaseSRF_MapProjection)srf)._ormData, tempCdCoord);
                double lon = tempCdCoord[0];
                double lat = tempCdCoord[1];
                double slon = Math.sin(lon);
                double clon = Math.cos(lon);
                double slat = Math.sin(lat);
                double clat = Math.cos(lat);
                double scom = Math.sin(com);
                double ccom = Math.cos(com);
                ltp.r[0] = -slon * ccom + clon * slat * scom;
                ltp.r[1] = clon * ccom + slon * slat * scom;
                ltp.r[2] = -clat * scom;
                ltp.s[0] = -slon * scom - clon * slat * ccom;
                ltp.s[1] = clon * scom - slon * slat * ccom;
                ltp.s[2] = clat * ccom;
                break;
            }
            case CSCOD_MERCATOR: 
            case CSCOD_EQUIDISTANT_CYLINDRICAL: {
                double[] tempCdCoord = BaseSRF_3D.interimConv(coord, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC);
                if (((BaseSRF_MapProjection)srf)._ormData == null) {
                    ((BaseSRF_MapProjection)srf)._ormData = new OrmData(srf.getOrm());
                }
                double lon = tempCdCoord[0];
                double lat = tempCdCoord[1];
                double slon = Math.sin(lon);
                double clon = Math.cos(lon);
                double slat = Math.sin(lat);
                double clat = Math.cos(lat);
                ltp.r[0] = -slon;
                ltp.r[1] = clon;
                ltp.r[2] = 0.0;
                ltp.s[0] = -slat;
                ltp.s[1] = -slat * slon;
                ltp.s[2] = clat;
                break;
            }
            case CSCOD_LOCOCENT_AZIMUTHAL_SPHERICAL: {
                double alpha = coord.getValues()[0];
                double theta = coord.getValues()[2];
                double salpha = Math.sin(alpha);
                double calpha = Math.cos(alpha);
                double stheta = Math.sin(theta);
                double ctheta = Math.cos(theta);
                ltp.r[0] = calpha;
                ltp.r[1] = -salpha;
                ltp.r[2] = 0.0;
                ltp.s[0] = ctheta * salpha;
                ltp.s[1] = ctheta * calpha;
                ltp.s[2] = stheta;
                break;
            }
            case CSCOD_LOCOCENTRIC_CYLINDRICAL: {
                double ctheta;
                double theta = coord.getValues()[1];
                double stheta = Math.sin(theta);
                ltp.r[0] = ctheta = Math.cos(theta);
                ltp.r[1] = stheta;
                ltp.r[2] = 0.0;
                ltp.s[0] = -stheta;
                ltp.s[1] = ctheta;
                ltp.s[2] = 0.0;
                break;
            }
            default: {
                throw new SrmException(12, "compute LTP: operation not supported for this SRF");
            }
        }
        return ltp;
    }

    protected SRM_Matrix_3x3 comp_ori_mat(LTP_vec src, LTP_vec tgt) {
        SRM_Matrix_3x3 mat = new SRM_Matrix_3x3();
        double[] src_t = Const.cross_product(src.r, src.s);
        double[] tgt_t = Const.cross_product(tgt.r, tgt.s);
        mat.m[0][0] = Const.dot_product(src.r, tgt.r);
        mat.m[0][1] = Const.dot_product(src.s, tgt.r);
        mat.m[0][2] = Const.dot_product(src_t, tgt.r);
        mat.m[1][0] = Const.dot_product(src.r, tgt.s);
        mat.m[1][1] = Const.dot_product(src.s, tgt.s);
        mat.m[1][2] = Const.dot_product(src_t, tgt.s);
        mat.m[2][0] = Const.dot_product(src.r, tgt_t);
        mat.m[2][1] = Const.dot_product(src.s, tgt_t);
        mat.m[2][2] = Const.dot_product(src_t, tgt_t);
        return mat;
    }

    private class LTP_vec {
        double[] r = new double[3];
        double[] s = new double[3];

        private LTP_vec() {
        }
    }
}

