/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF_WithEllipsoidalHeight;
import SRM.CoordSurf;
import SRM.OrmData;
import SRM.SRM_Extended_Valid_Region_Params;
import SRM.SRM_Interval_Type;
import SRM.SRM_SRFT_Code;
import SRM.SRM_Valid_Region_Params;
import SRM.SrmException;

public abstract class BaseSRF_MapProjection
extends BaseSRF_WithEllipsoidalHeight {
    protected OrmData _ormData;
    private SRM_Extended_Valid_Region_Params[] _component_valid_gd_region = new SRM_Extended_Valid_Region_Params[2];

    public void setValidGeodeticRegion(int component, SRM_Interval_Type type, double lower, double upper) throws SrmException {
        if (component < 1 || component > 2) {
            throw new SrmException(8, "setValidGeodeticRegion: component out of range [ 1, 2 ]");
        }
        switch (type) {
            case IVLTYP_GT_SEMI_INTERVAL: 
            case IVLTYP_GE_SEMI_INTERVAL: 
            case IVLTYP_LT_SEMI_INTERVAL: 
            case IVLTYP_LE_SEMI_INTERVAL: {
                throw new SrmException(8, "setValidGeodeticRegion: cannot be a semi-interval region");
            }
            case IVLTYP_OPEN_INTERVAL: 
            case IVLTYP_GE_LT_INTERVAL: 
            case IVLTYP_GT_LE_INTERVAL: 
            case IVLTYP_CLOSED_INTERVAL: {
                if (lower == upper) {
                    throw new SrmException(8, "setValidGeodeticRegion: lower and upper bounds are the same");
                }
                if (component == 1 && lower <= -Math.PI && lower > Math.PI && upper <= -Math.PI && upper > Math.PI) {
                    throw new SrmException(8, "setValidGeodeticRegion: component 1 (longitude) out of range (-PI, PI]");
                }
                if (component != 2 || !(lower <= -1.5707963267948966) || !(lower >= 1.5707963267948966) || !(upper <= -1.5707963267948966) || !(upper >= 1.5707963267948966)) break;
                throw new SrmException(8, "setValidGeodeticRegion: component 2 (latitude) out of range (-PI/2, PI/2)");
            }
        }
        if (this._component_valid_gd_region[component - 1] == null) {
            this._component_valid_gd_region[component - 1] = new SRM_Extended_Valid_Region_Params();
        }
        this._component_valid_gd_region[component - 1].type = type;
        this._component_valid_gd_region[component - 1].lower = lower;
        this._component_valid_gd_region[component - 1].upper = upper;
    }

    public void setExtendedValidGeodeticRegion(int component, SRM_Interval_Type type, double extended_lower, double lower, double upper, double extended_upper) throws SrmException {
        if (component < 1 || component > 2) {
            throw new SrmException(8, "setExtendedValidGeodeticRegion: component out of range [ 1, 2 ]");
        }
        switch (type) {
            case IVLTYP_GT_SEMI_INTERVAL: 
            case IVLTYP_GE_SEMI_INTERVAL: 
            case IVLTYP_LT_SEMI_INTERVAL: 
            case IVLTYP_LE_SEMI_INTERVAL: {
                throw new SrmException(8, "setExtendedValidGeodeticRegion: cannot be a semi-interval region");
            }
            case IVLTYP_OPEN_INTERVAL: 
            case IVLTYP_GE_LT_INTERVAL: 
            case IVLTYP_GT_LE_INTERVAL: 
            case IVLTYP_CLOSED_INTERVAL: {
                if (lower == upper) {
                    throw new SrmException(8, "setExtendedValidGeodeticRegion: lower and upper bounds are the same");
                }
                if (component == 1 && lower <= -Math.PI && lower > Math.PI && upper <= -Math.PI && upper > Math.PI) {
                    throw new SrmException(8, "setExtendedValidGeodeticRegion: component 1 (longitude) out of range (-PI, PI]");
                }
                if (component == 2 && lower <= -1.5707963267948966 && lower >= 1.5707963267948966 && upper <= -1.5707963267948966 && upper >= 1.5707963267948966) {
                    throw new SrmException(8, "setExtendedValidGeodeticRegion: component 2 (latitude) out of range (-PI/2, PI/2)");
                }
                if (lower < upper && (extended_lower > lower || extended_upper < upper)) {
                    throw new SrmException(8, "setExtendedValidGeodeticRegion: extended bounds falls within valid region");
                }
                if (!(lower > upper) || !(extended_lower < lower) && !(extended_upper > upper)) break;
                throw new SrmException(8, "setExtendedValidGeodeticRegion: extended bounds falls within valid region");
            }
        }
        if (this._component_valid_gd_region[component - 1] == null) {
            this._component_valid_gd_region[component - 1] = new SRM_Extended_Valid_Region_Params();
        }
        this._component_valid_gd_region[component - 1].type = type;
        this._component_valid_gd_region[component - 1].extended_lower = extended_lower;
        this._component_valid_gd_region[component - 1].lower = lower;
        this._component_valid_gd_region[component - 1].upper = upper;
        this._component_valid_gd_region[component - 1].extended_upper = extended_upper;
    }

    public SRM_Valid_Region_Params getValidGeodeticRegion(int component) throws SrmException {
        SRM_Valid_Region_Params ret_reg = new SRM_Valid_Region_Params();
        if (component < 1 || component > 2) {
            throw new SrmException(8, "getValidGeodeticRegion: component out of range [ 1, 2 ]");
        }
        ret_reg.type = this._component_valid_gd_region[component - 1].type;
        ret_reg.lower = this._component_valid_gd_region[component - 1].lower;
        ret_reg.upper = this._component_valid_gd_region[component - 1].upper;
        return ret_reg;
    }

    public SRM_Extended_Valid_Region_Params getExtendedValidGeodeticRegion(int component) throws SrmException {
        SRM_Extended_Valid_Region_Params ret_reg = new SRM_Extended_Valid_Region_Params();
        if (component < 1 || component > 2) {
            throw new SrmException(8, "getExtendedValidGeodeticRegion: component out of range [ 1, 2 ]");
        }
        ret_reg.type = this._component_valid_gd_region[component - 1].type;
        ret_reg.extended_lower = this._component_valid_gd_region[component - 1].extended_lower;
        ret_reg.lower = this._component_valid_gd_region[component - 1].lower;
        ret_reg.upper = this._component_valid_gd_region[component - 1].upper;
        ret_reg.extended_upper = this._component_valid_gd_region[component - 1].extended_upper;
        return ret_reg;
    }

    public double calculateConvergenceOfTheMeridian(CoordSurf surf_coord) throws SrmException {
        if (surf_coord == null) {
            throw new SrmException(8, "calculateConvergenceOfTheMeridian: Input parameter is null");
        }
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, new String("calculateConvergenceOfTheMeridian: input coordinate not in this SRF"));
        }
        if (this._ormData == null) {
            this._ormData = new OrmData(this._orm);
        }
        double[] tgtCdCoord = BaseSRF_MapProjection.interimConv(surf_coord, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC);
        return this.comCalculation(this._ormData, tgtCdCoord);
    }

    public double calculatePointScale(CoordSurf surf_coord) throws SrmException {
        if (surf_coord == null) {
            throw new SrmException(8, "calculatePointScale: Input parameter is null");
        }
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, "calculatePointScale: input coordinate not in this SRF");
        }
        if (this._ormData == null) {
            this._ormData = new OrmData(this._orm);
        }
        double[] tgtCdCoord = BaseSRF_MapProjection.interimConv(surf_coord, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC);
        return this.pointScaleCalculation(this._ormData, tgtCdCoord);
    }

    public double calculateMapAzimuth(CoordSurf src_coord, CoordSurf des_coord) throws SrmException {
        double ret_azimuth = 0.0;
        if (src_coord.getSRF() != this || des_coord.getSRF() != this) {
            throw new SrmException(5, new String("calculateMapAzimuth: input coordinate not in this SRF"));
        }
        if (src_coord.getValues()[1] == des_coord.getValues()[1] && src_coord.getValues()[2] == des_coord.getValues()[2]) {
            throw new SrmException(8, new String("calculateMapAzimuth: the source and destination coordinates are the same"));
        }
        ret_azimuth = Math.atan2(des_coord.getValues()[0] - src_coord.getValues()[0], des_coord.getValues()[1] - src_coord.getValues()[1]);
        if (ret_azimuth < 0.0) {
            ret_azimuth += Math.PI * 2;
        }
        return ret_azimuth;
    }

    protected abstract double comCalculation(OrmData var1, double[] var2) throws SrmException;

    protected abstract double pointScaleCalculation(OrmData var1, double[] var2) throws SrmException;
}

