/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Conversions;
import SRM.FunctionMap;
import SRM.SRM_SRFT_Code;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bfs {
    private static Bfs _bfs = new Bfs();

    public static Bfs instance() {
        return _bfs;
    }

    public Vector<SRM_SRFT_Code> GetConversionPath(SRM_SRFT_Code source, SRM_SRFT_Code destination) {
        int i;
        boolean[] visited_node = new boolean[27];
        SRM_SRFT_Code[] parent_node = new SRM_SRFT_Code[27];
        int[] distance = new int[27];
        Vector<SRM_SRFT_Code> lococentre = new Vector<SRM_SRFT_Code>();
        Vector<SRM_SRFT_Code> path = new Vector<SRM_SRFT_Code>();
        Vector<SRM_SRFT_Code> returnPath = new Vector<SRM_SRFT_Code>();
        for (i = 0; i <= 26; ++i) {
            visited_node[i] = false;
            parent_node[i] = SRM_SRFT_Code.SRFTCOD_UNSPECIFIED;
            distance[i] = -1;
        }
        if (source != destination) {
            visited_node[source.toInt()] = true;
            distance[source.toInt()] = 0;
            this.queue(lococentre, source);
            while (!lococentre.isEmpty()) {
                SRM_SRFT_Code node;
                SRM_SRFT_Code current_node = this.dequeue(lococentre);
                if (current_node == destination) {
                    node = current_node;
                    do {
                        this.queue(path, node);
                    } while ((node = parent_node[node.toInt()]) != source);
                    this.queue(path, node);
                    for (i = 0; i < path.size(); ++i) {
                        returnPath.insertElementAt(path.elementAt(i), 0);
                    }
                    return returnPath;
                }
                int index = 0;
                Conversions conv = FunctionMap.instance().get(current_node);
                node = conv != null ? conv.getDest()[index] : SRM_SRFT_Code.SRFTCOD_UNSPECIFIED;
                while (node != SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
                    if (!visited_node[node.toInt()]) {
                        this.queue(lococentre, node);
                        visited_node[node.toInt()] = true;
                        distance[node.toInt()] = distance[current_node.toInt()] + 1;
                        parent_node[node.toInt()] = current_node;
                    }
                    visited_node[current_node.toInt()] = true;
                    conv = FunctionMap.instance().get(current_node);
                    if (conv != null) {
                        node = conv.getDest()[index++];
                        continue;
                    }
                    node = SRM_SRFT_Code.SRFTCOD_UNSPECIFIED;
                }
            }
        } else {
            boolean firstRound = true;
            distance[source.toInt()] = 0;
            this.queue(lococentre, source);
            while (!lococentre.isEmpty()) {
                SRM_SRFT_Code node;
                SRM_SRFT_Code current_node = this.dequeue(lococentre);
                if (current_node == destination && !firstRound) {
                    node = current_node;
                    do {
                        this.queue(path, node);
                    } while ((node = parent_node[node.toInt()]) != source);
                    this.queue(path, node);
                    for (int i2 = 0; i2 < path.size(); ++i2) {
                        returnPath.insertElementAt(path.elementAt(i2), 0);
                    }
                    return returnPath;
                }
                firstRound = false;
                int index = 0;
                Conversions conv = FunctionMap.instance().get(current_node);
                node = conv != null ? conv.getDest()[index] : SRM_SRFT_Code.SRFTCOD_UNSPECIFIED;
                while (node != SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
                    if (!visited_node[node.toInt()]) {
                        this.queue(lococentre, node);
                        visited_node[node.toInt()] = true;
                        distance[node.toInt()] = distance[current_node.toInt()] + 1;
                        parent_node[node.toInt()] = current_node;
                    }
                    if (current_node != source) {
                        visited_node[current_node.toInt()] = true;
                    }
                    if ((conv = FunctionMap.instance().get(current_node)) != null) {
                        node = conv.getDest()[index++];
                        continue;
                    }
                    node = SRM_SRFT_Code.SRFTCOD_UNSPECIFIED;
                }
            }
        }
        return null;
    }

    private void queue(Vector<SRM_SRFT_Code> lococentre, SRM_SRFT_Code node) {
        lococentre.add(node);
    }

    private SRM_SRFT_Code dequeue(Vector<SRM_SRFT_Code> lococentre) {
        return lococentre.remove(0);
    }
}

