/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.OrmData;
import SRM.SRF_EC_Params;
import SRM.SRF_EquidistantCylindrical;
import SRM.SRF_LCC_Params;
import SRM.SRF_LambertConformalConic;
import SRM.SRF_M_Params;
import SRM.SRF_Mercator;
import SRM.SRF_OM_Params;
import SRM.SRF_ObliqueMercatorSpherical;
import SRM.SRF_PS_Params;
import SRM.SRF_PolarStereographic;
import SRM.SRF_TM_Params;
import SRM.SRF_TransverseMercator;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_Polar_Aspect;
import SRM.SRM_SRFSM_Japan_Rectangular_Plane_CS_Code;
import SRM.SRM_SRFSM_UTM_Code;
import SRM.SRM_SRFS_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class CdetConv
extends Conversions {
    private ToTmerConst _toTmerConst;
    private ToMercConst _toMercConst;
    private ToLccConst1 _toLccConst1;
    private ToLccConst2 _toLccConst2;
    private ToOmerConst _toOmerConst;
    private ToEqcyConst _toEqcyConst;
    private ToPostConst _toPostConst;

    protected CdetConv() {
        super(SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, SRM_SRFT_Code.SRFTCOD_LAMBERT_CONFORMAL_CONIC, SRM_SRFT_Code.SRFTCOD_TRANSVERSE_MERCATOR, SRM_SRFT_Code.SRFTCOD_MERCATOR, SRM_SRFT_Code.SRFTCOD_PLANETODETIC, SRM_SRFT_Code.SRFTCOD_OBLIQUE_MERCATOR_SPHERICAL, SRM_SRFT_Code.SRFTCOD_EQUIDISTANT_CYLINDRICAL, SRM_SRFT_Code.SRFTCOD_POLAR_STEREOGRAPHIC, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new CdetConv();
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        switch (destSrfType) {
            case SRFTCOD_CELESTIOCENTRIC: {
                retValid = CoordCheck.forCelestiodetic(this.getOrmData(), src);
                this.toCcen(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forNaN_3D(dest);
                break;
            }
            case SRFTCOD_TRANSVERSE_MERCATOR: {
                switch (destSrf.getSRFSetCode()) {
                    case SRFSCOD_ALABAMA_SPCS: {
                        retValid = CoordCheck.forALSP_cd(this.getOrmData(), ((SRF_TransverseMercator)destSrf).getSRFParameters(), src);
                        break;
                    }
                    case SRFSCOD_JAPAN_RECTANGULAR_PLANE_CS: {
                        retValid = CoordCheck.forJapan_cd(this.getOrmData(), (SRM_SRFSM_Japan_Rectangular_Plane_CS_Code)destSrf.getSRFSetMemberCode(), ((SRF_TransverseMercator)destSrf).getSRFParameters(), src);
                        break;
                    }
                    case SRFSCOD_UNIVERSAL_TRANSVERSE_MERCATOR: {
                        retValid = CoordCheck.forUTM_cd(this.getOrmData(), ((SRF_TransverseMercator)destSrf).getSRFParameters(), (SRM_SRFSM_UTM_Code)destSrf.getSRFSetMemberCode(), src);
                        break;
                    }
                    default: {
                        retValid = CoordCheck.forTransverseMercator_cd(this.getOrmData(), ((SRF_TransverseMercator)destSrf).getSRFParameters(), src);
                    }
                }
                this.toTmer(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forNaN_3D(dest);
                dest[0] = dest[0] + ((SRF_TransverseMercator)destSrf).get_false_easting();
                dest[1] = dest[1] + ((SRF_TransverseMercator)destSrf).get_false_northing();
                break;
            }
            case SRFTCOD_MERCATOR: {
                retValid = CoordCheck.forCelestiodetic(this.getOrmData(), src);
                this.toMerc(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forNaN_3D(dest);
                dest[0] = dest[0] + ((SRF_Mercator)destSrf).get_false_easting();
                dest[1] = dest[1] + ((SRF_Mercator)destSrf).get_false_northing();
                break;
            }
            case SRFTCOD_LAMBERT_CONFORMAL_CONIC: {
                retValid = CoordCheck.forCelestiodetic(this.getOrmData(), src);
                this.toLcc(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forNaN_3D(dest);
                dest[0] = dest[0] + ((SRF_LambertConformalConic)destSrf).get_false_easting();
                dest[1] = dest[1] + ((SRF_LambertConformalConic)destSrf).get_false_northing();
                break;
            }
            case SRFTCOD_PLANETODETIC: {
                retValid = CoordCheck.forCelestiodetic(this.getOrmData(), src);
                dest[1] = -src[0];
                dest[0] = src[1];
                dest[2] = src[2];
                break;
            }
            case SRFTCOD_OBLIQUE_MERCATOR_SPHERICAL: {
                this.toOmer(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forNaN_3D(dest);
                dest[0] = dest[0] + ((SRF_ObliqueMercatorSpherical)destSrf).get_false_easting();
                dest[1] = dest[1] + ((SRF_ObliqueMercatorSpherical)destSrf).get_false_northing();
                break;
            }
            case SRFTCOD_EQUIDISTANT_CYLINDRICAL: {
                retValid = CoordCheck.forEquidistantCylindrical_cd(this.getOrmData(), src);
                this.toEqcy(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forNaN_3D(dest);
                dest[0] = dest[0] + ((SRF_EquidistantCylindrical)destSrf).get_false_easting();
                dest[1] = dest[1] + ((SRF_EquidistantCylindrical)destSrf).get_false_northing();
                break;
            }
            case SRFTCOD_POLAR_STEREOGRAPHIC: {
                retValid = destSrf.getSRFSetCode() == SRM_SRFS_Code.SRFSCOD_UNIVERSAL_POLAR_STEREOGRAPHIC ? CoordCheck.forUPS_cd(((SRF_PolarStereographic)destSrf).getSRFParameters(), src) : CoordCheck.forPolarStereographic_cd(((SRF_PolarStereographic)destSrf).getSRFParameters(), src);
                this.toPost(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forNaN_3D(dest);
                dest[0] = dest[0] + ((SRF_PolarStereographic)destSrf).get_false_easting();
                dest[1] = dest[1] + ((SRF_PolarStereographic)destSrf).get_false_northing();
                break;
            }
            case SRFTCOD_UNSPECIFIED: {
                dest[0] = src[0];
                dest[1] = src[1];
                dest[2] = src[2];
            }
        }
        return retValid;
    }

    private void toCcen(BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest) throws SrmException {
        double Rnc2a2;
        double rn;
        double srcLon = src[0];
        double srcLat = src[1];
        double srcHeight = src[2];
        OrmData e_constants = this.getOrmData();
        double slat = Math.sin(srcLat);
        if (e_constants.Eps != 0.0) {
            double temp = e_constants.Eps25 * slat * slat;
            temp = 0.5 - temp;
            temp += (temp - 0.25) / temp;
            rn = e_constants.A / temp;
            Rnc2a2 = rn * e_constants.C2 / e_constants.A2;
        } else {
            Rnc2a2 = rn = e_constants.A;
        }
        double Rnhc = (rn + srcHeight) * Math.cos(srcLat);
        dest[0] = Rnhc * Math.cos(srcLon);
        dest[1] = Rnhc * Math.sin(srcLon);
        dest[2] = (Rnc2a2 + srcHeight) * slat;
    }

    protected void toTmer(SRF_TM_Params params, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double ONE_POINT_ONE_DEGREES = 0.019198621771937624;
        double TWO_POINT_FOUR_DEGREES = 0.04188790204786391;
        double FOUR_POINT_ZERO_DEGREES = 0.06981317007977318;
        OrmData e_constants = this.getOrmData();
        if (this._toTmerConst == null) {
            this._toTmerConst = new ToTmerConst(e_constants, params);
        }
        double source_lon = source_generic_coordinate[0];
        double source_lat = source_generic_coordinate[1];
        double source_elv = source_generic_coordinate[2];
        double al = 0.0;
        double al2 = 0.0;
        double lambda_star = 0.0;
        double sin_lat = 0.0;
        double cos_lat = 0.0;
        double Sm = 0.0;
        double tan_lat_squared = 0.0;
        double tan_lat = 0.0;
        double sin_squared_lat = 0.0;
        sin_lat = Math.sin(source_lat);
        cos_lat = Math.cos(source_lat);
        tan_lat = cos_lat != 0.0 ? sin_lat / cos_lat : 0.0;
        tan_lat_squared = Const.square(tan_lat);
        sin_squared_lat = Const.square(sin_lat);
        lambda_star = Const.getLambdaStar(source_lon, this._toTmerConst.longitude_origin);
        al = lambda_star * cos_lat;
        al2 = al * al;
        if (e_constants.Eps != 0.0) {
            double Fn;
            double Fe;
            double polx1;
            double cee = e_constants.Epps2 * cos_lat * cos_lat;
            double cee_squared = Const.square(cee);
            double Rn = Const.computeRn(sin_squared_lat, e_constants);
            Sm = Const.arcLength(this._toTmerConst.arclength_spec, source_lat, sin_lat, cos_lat);
            if (Math.abs(lambda_star) <= 0.019198621771937624) {
                polx1 = 1.0 - tan_lat_squared + cee;
                double poly1 = 5.0 - tan_lat_squared;
                Fe = 1.0 + al2 * polx1 * this._toTmerConst.Cdb6;
                Fn = 0.5 + al2 * poly1 * this._toTmerConst.Cdb24;
            } else if (Math.abs(lambda_star) <= 0.04188790204786391) {
                polx1 = 1.0 - tan_lat_squared + cee;
                double polx2 = 5.0 + tan_lat_squared * (tan_lat_squared - 18.0);
                double poly1 = 5.0 - tan_lat_squared + cee * (9.0 + 4.0 * cee);
                Fe = 1.0 + al2 * (polx1 * this._toTmerConst.Cdb6 + al2 * polx2 * this._toTmerConst.Cdb120);
                Fn = 0.5 + al2 * poly1 * this._toTmerConst.Cdb24;
            } else if (Math.abs(lambda_star) <= 0.06981317007977318) {
                polx1 = 1.0 - tan_lat_squared + cee;
                double tmp_polx2 = 5.0 + tan_lat_squared * (tan_lat_squared - 18.0);
                double polx2 = tmp_polx2 + cee * (14.0 - 58.0 * tan_lat_squared);
                double poly1 = 5.0 - tan_lat_squared + cee * (9.0 + 4.0 * cee);
                double tmp_poly2 = 61.0 + tan_lat_squared * (tan_lat_squared - 58.0);
                double poly2 = tmp_poly2 + cee * (270.0 - 330.0 * tan_lat_squared);
                Fe = 1.0 + al2 * (polx1 * this._toTmerConst.Cdb6 + al2 * polx2 * this._toTmerConst.Cdb120);
                Fn = 0.5 + al2 * (poly1 * this._toTmerConst.Cdb24 + al2 * poly2 * this._toTmerConst.Cdb720);
            } else {
                polx1 = 1.0 - tan_lat_squared + cee;
                double tx2 = cee_squared * (13.0 + cee * 4.0 - tan_lat_squared * (64.0 + 24.0 * cee));
                double polx2 = tx2 + 5.0 + tan_lat_squared * (tan_lat_squared - 18.0) + cee * (14.0 - 58.0 * tan_lat_squared);
                double polx3 = 61.0 + tan_lat_squared * (-479.0 + tan_lat_squared * (179.0 - tan_lat_squared));
                double poly1 = 5.0 - tan_lat_squared + cee * (9.0 + 4.0 * cee);
                double tmp_poly2 = 61.0 + tan_lat_squared * (tan_lat_squared - 58.0);
                double poly2 = tmp_poly2 + cee * (270.0 - 330.0 * tan_lat_squared);
                double tmp_ty2 = poly2 + 445.0 * Const.square(cee);
                double tmp2_ty2 = tmp_ty2 + 324.0 * Const.cube(cee) - 680.0 * tan_lat_squared * Const.square(cee);
                double ty2 = tmp2_ty2 + 88.0 * Const.square(cee) * Const.square(cee) - 600.0 * tan_lat_squared * Const.cube(cee);
                double new_poly2 = ty2 - 192.0 * tan_lat_squared * Const.square(cee) * Const.square(cee);
                double new_poly3 = 1385.0 + tan_lat_squared * (-3111.0 + tan_lat_squared * (543.0 - tan_lat_squared));
                Fe = 1.0 + al2 * (polx1 * this._toTmerConst.Cdb6 + al2 * (polx2 * this._toTmerConst.Cdb120 + al2 * polx3 * this._toTmerConst.Cdb5040));
                Fn = 0.5 + al2 * (poly1 * this._toTmerConst.Cdb24 + al2 * (new_poly2 * this._toTmerConst.Cdb720 + al2 * new_poly3 * this._toTmerConst.Cdb40320));
            }
            double easting = Fe * al * this._toTmerConst.CScale * Rn;
            double northing = this._toTmerConst.CScale * (Sm - this._toTmerConst.smz + Rn * tan_lat * al2 * Fn);
            dest_generic_coordinate[0] = easting;
            dest_generic_coordinate[1] = northing;
        } else {
            double Rn = this._toTmerConst.CScale * e_constants.A;
            dest_generic_coordinate[0] = Rn * Const.atanh(cos_lat * Math.sin(lambda_star));
            dest_generic_coordinate[1] = Rn * (Math.atan(tan_lat / Math.cos(lambda_star)) - this._toTmerConst.latitude_origin);
        }
        dest_generic_coordinate[2] = source_elv;
    }

    private void toTmer(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        this.toTmer(((SRF_TransverseMercator)destSrf).getSRFParameters(), source_generic_coordinate, dest_generic_coordinate);
    }

    private void toMerc(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double p;
        OrmData e_constants = this.getOrmData();
        if (this._toMercConst == null) {
            this._toMercConst = new ToMercConst(e_constants, ((SRF_Mercator)destSrf).getSRFParameters());
        }
        double source_lon = Const.getLambdaStar(source_generic_coordinate[0], this._toMercConst.longitude_origin);
        double source_lat = source_generic_coordinate[1];
        double source_elv = source_generic_coordinate[2];
        double sin_lat = Math.sin(source_lat);
        if (e_constants.Eps != 0.0) {
            double abs_sin_lat = Math.abs(sin_lat);
            p = abs_sin_lat <= 0.619591884457987 ? this._toMercConst.CR11 + (this._toMercConst.CR12 * abs_sin_lat + this._toMercConst.CR13) / (this._toMercConst.CR14 + abs_sin_lat * (this._toMercConst.CR15 + abs_sin_lat)) : this._toMercConst.CR21 + (this._toMercConst.CR22 * abs_sin_lat + this._toMercConst.CR23) / (this._toMercConst.CR24 + abs_sin_lat * (this._toMercConst.CR25 + abs_sin_lat));
            if (sin_lat < 0.0) {
                p = 1.0 / p;
            }
            p *= Math.sqrt((1.0 + sin_lat) / (1.0 - sin_lat));
        } else {
            p = Math.sqrt((1.0 + sin_lat) / (1.0 - sin_lat));
        }
        source_lon = Const.fix_longitude(source_lon);
        double dest_x = this._toMercConst.scale * e_constants.A * source_lon;
        double dest_y = this._toMercConst.scale * e_constants.A * Math.log(p);
        dest_generic_coordinate[0] = dest_x;
        dest_generic_coordinate[1] = dest_y;
        dest_generic_coordinate[2] = source_elv;
    }

    private void toOmer(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        OrmData e_constants = this.getOrmData();
        if (this._toOmerConst == null) {
            this._toOmerConst = new ToOmerConst(e_constants, ((SRF_ObliqueMercatorSpherical)destSrf).getSRFParameters());
        }
        double source_lon = source_generic_coordinate[0];
        double source_lat = source_generic_coordinate[1];
        double source_elv = source_generic_coordinate[2];
        double sin_phi = 0.0;
        double cos_phi = 0.0;
        double sin_lambda = 0.0;
        double cos_lambda = 0.0;
        double p1 = 0.0;
        double p2 = 0.0;
        double sin_lambda_minus_lambda_0 = 0.0;
        double cos_lambda_minus_lambda_0 = 0.0;
        sin_lambda = Math.sin(source_lon);
        cos_lambda = Math.cos(source_lon);
        sin_phi = Math.sin(source_lat);
        cos_phi = Math.cos(source_lat);
        sin_lambda_minus_lambda_0 = sin_lambda * this._toOmerConst.cl0 - cos_lambda * this._toOmerConst.sl0;
        cos_lambda_minus_lambda_0 = cos_lambda * this._toOmerConst.cl0 + sin_lambda * this._toOmerConst.sl0;
        p1 = this._toOmerConst.sa0 * sin_phi + this._toOmerConst.ca0 * cos_phi * sin_lambda_minus_lambda_0;
        p2 = -this._toOmerConst.ca0 * sin_phi + this._toOmerConst.sa0 * cos_phi * sin_lambda_minus_lambda_0;
        double dest_x = this._toOmerConst.ak0 * Math.atan2(p1, cos_phi * cos_lambda_minus_lambda_0);
        double dest_y = 0.5 * this._toOmerConst.ak0 * Math.log((1.0 - p2) / (1.0 + p2));
        dest_generic_coordinate[0] = dest_x;
        dest_generic_coordinate[1] = dest_y;
        dest_generic_coordinate[2] = source_elv;
    }

    private void toLcc(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double latitude2;
        double latitude1 = ((SRF_LambertConformalConic)destSrf).get_latitude1();
        if (Math.abs(latitude1 - (latitude2 = ((SRF_LambertConformalConic)destSrf).get_latitude2())) < 1.0E-4) {
            this.toLcc1(srcSrf, destSrf, source_generic_coordinate, dest_generic_coordinate);
        } else {
            this.toLcc2(srcSrf, destSrf, source_generic_coordinate, dest_generic_coordinate);
        }
    }

    protected void toLcc1(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double p;
        OrmData e_constants = this.getOrmData();
        if (this._toLccConst1 == null) {
            this._toLccConst1 = new ToLccConst1(e_constants, ((SRF_LambertConformalConic)destSrf).getSRFParameters());
        }
        double source_lon = source_generic_coordinate[0];
        double source_lat = source_generic_coordinate[1];
        double source_elv = source_generic_coordinate[2];
        double sl = Math.sin(source_lat);
        if (e_constants.Eps != 0.0) {
            double esl = e_constants.Eps * sl;
            p = Math.pow((1.0 + esl) / (1.0 - esl), e_constants.EpsH);
        } else {
            p = 1.0;
        }
        double r = this._toLccConst1._rz * Math.pow(this._toLccConst1._pz * (p *= Math.tan(0.7853981633974483 - 0.5 * source_lat)), this._toLccConst1._xl);
        double dlon = Const.getLambdaStar(source_lon, this._toLccConst1._xlonz);
        double arg = this._toLccConst1._xl * dlon;
        double s1 = Math.sin(arg);
        double t = Math.cos(arg);
        double dest_x = r * s1;
        double dest_y = this._toLccConst1._rho_origin - r * t;
        if (this._toLccConst1._xl < 0.0) {
            dest_x = -dest_x;
            dest_y = -dest_y;
        }
        dest_generic_coordinate[0] = dest_x;
        dest_generic_coordinate[1] = dest_y;
        dest_generic_coordinate[2] = source_elv;
    }

    protected void toLcc2(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double p;
        OrmData e_constants = this.getOrmData();
        if (this._toLccConst2 == null) {
            this._toLccConst2 = new ToLccConst2(e_constants, ((SRF_LambertConformalConic)destSrf).getSRFParameters());
        }
        double source_lon = source_generic_coordinate[0];
        double source_lat = source_generic_coordinate[1];
        double source_elv = source_generic_coordinate[2];
        double sl = Math.sin(source_lat);
        if (e_constants.Eps != 0.0) {
            double esl = e_constants.Eps * sl;
            p = Math.pow((1.0 + esl) / (1.0 - esl), e_constants.EpsH);
        } else {
            p = 1.0;
        }
        double r = this._toLccConst2._rx * Math.pow(this._toLccConst2._p1 * (p *= Math.tan(0.7853981633974483 - 0.5 * source_lat)), this._toLccConst2._xl);
        double dlon = Const.getLambdaStar(source_lon, this._toLccConst2._xlonz);
        double arg = this._toLccConst2._xl * dlon;
        double s1 = Math.sin(arg);
        double t = Math.cos(arg);
        double dest_x = r * s1;
        double dest_y = this._toLccConst2._rz - r * t;
        if (this._toLccConst2._xl < 0.0) {
            dest_x = -dest_x;
            dest_y = -dest_y;
        }
        dest_generic_coordinate[0] = dest_x;
        dest_generic_coordinate[1] = dest_y;
        dest_generic_coordinate[2] = source_elv;
    }

    protected void toEqcy(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        OrmData e_constants = this.getOrmData();
        double source_lon = source_generic_coordinate[0];
        double source_lat = source_generic_coordinate[1];
        double source_elv = source_generic_coordinate[2];
        if (this._toEqcyConst == null) {
            this._toEqcyConst = new ToEqcyConst(e_constants, ((SRF_EquidistantCylindrical)destSrf).getSRFParameters());
        }
        double lambda_star = Const.getLambdaStar(source_lon, this._toEqcyConst.longitude_origin);
        dest_generic_coordinate[0] = e_constants.A * this._toEqcyConst.scale_factor * lambda_star;
        dest_generic_coordinate[1] = e_constants.Eps2 != 0.0 ? Const.arcLength(this._toEqcyConst.al, source_lat, Math.sin(source_lat), Math.cos(source_lat)) : source_lat * e_constants.A;
        dest_generic_coordinate[2] = source_elv;
    }

    protected void toPost(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        OrmData e_constants = this.getOrmData();
        if (this._toPostConst == null) {
            this._toPostConst = new ToPostConst(e_constants, ((SRF_PolarStereographic)destSrf).getSRFParameters());
        }
        double source_lon = source_generic_coordinate[0] * this._toPostConst.polar_aspect_constant;
        double source_lat = source_generic_coordinate[1] * this._toPostConst.polar_aspect_constant;
        double sin_lat = Math.sin(source_lat);
        double sin_lon = Math.sin(source_lon);
        double rho = Double.NaN;
        double P = Double.NaN;
        double T = Double.NaN;
        double scale_factor = this._toPostConst.scale_factor;
        double cos_lat = Math.cos(source_lat);
        double cos_lon = Math.cos(source_lon);
        double cos_lat_inv = 1.0 / cos_lat;
        if (e_constants.Eps != 0.0) {
            P = Const.power_p_approx(this._toPostConst.cr1, this._toPostConst.cr2, sin_lat);
            T = (1.0 - sin_lat) * cos_lat_inv / P;
            rho = 2.0 * e_constants.A * scale_factor * T * this._toPostConst.e;
            double cos_arg = cos_lon * this._toPostConst.cos_origin_lon + sin_lon * this._toPostConst.sin_origin_lon;
            double sin_arg = sin_lon * this._toPostConst.cos_origin_lon - cos_lon * this._toPostConst.sin_origin_lon;
            dest_generic_coordinate[0] = rho * sin_arg * this._toPostConst.polar_aspect_constant;
            dest_generic_coordinate[1] = -rho * cos_arg * this._toPostConst.polar_aspect_constant;
            dest_generic_coordinate[2] = source_generic_coordinate[2];
        } else {
            T = (1.0 - sin_lat) * cos_lat_inv;
            dest_generic_coordinate[0] = 2.0 * e_constants.A * scale_factor * T * (sin_lon * this._toPostConst.cos_origin_lon - cos_lon * this._toPostConst.sin_origin_lon) * this._toPostConst.polar_aspect_constant;
            dest_generic_coordinate[1] = -2.0 * e_constants.A * scale_factor * T * (cos_lon * this._toPostConst.cos_origin_lon + sin_lon * this._toPostConst.sin_origin_lon) * this._toPostConst.polar_aspect_constant;
            dest_generic_coordinate[2] = source_generic_coordinate[2];
        }
    }

    private class ToPostConst {
        double false_easting;
        double false_northing;
        double m0;
        double eps_factor;
        double origin_lon;
        double t_of_lat_origin_inv;
        double k0;
        double scale_factor;
        double P0;
        double xmc;
        double tc;
        double tc_inv;
        double e;
        double e_inv;
        double[] cr1 = new double[5];
        double[] cr2 = new double[5];
        double cos_origin_lon;
        double sin_origin_lon;
        double polar_aspect_constant;
        SRM_Polar_Aspect polar_aspect;

        public ToPostConst(OrmData e_constants, SRF_PS_Params params) {
            double polar_aspect_sign = 1.0;
            this.polar_aspect = params.polar_aspect;
            this.false_easting = params.false_easting;
            this.false_northing = params.false_northing;
            this.k0 = params.central_scale;
            this.scale_factor = params.central_scale;
            if (this.polar_aspect == SRM_Polar_Aspect.PLRASP_SOUTH) {
                polar_aspect_sign = -1.0;
                this.polar_aspect_constant = -1.0;
            } else {
                polar_aspect_sign = 1.0;
                this.polar_aspect_constant = 1.0;
            }
            double origin_longitude = polar_aspect_sign * params.origin_longitude;
            this.eps_factor = Double.NaN;
            this.origin_lon = origin_longitude;
            this.P0 = Const.power_p(e_constants, 1.0);
            this.e = e_constants.A * this.P0 * e_constants.B_inv;
            this.e_inv = 1.0 / this.e;
            if (e_constants.Eps != 0.0) {
                Const.init_power_p_series(e_constants, this.cr1, this.cr2);
            } else {
                for (int i = 0; i < 5; ++i) {
                    this.cr1[i] = Double.NaN;
                    this.cr2[i] = Double.NaN;
                }
            }
            this.sin_origin_lon = Math.sin(this.origin_lon);
            this.cos_origin_lon = Math.cos(this.origin_lon);
        }
    }

    private class ToEqcyConst {
        double longitude_origin;
        double scale_factor;
        Const.ArcLengthConst al;

        public ToEqcyConst(OrmData e_constants, SRF_EC_Params params) {
            this.longitude_origin = params.origin_longitude;
            this.scale_factor = params.central_scale;
            this.al = new Const.ArcLengthConst(e_constants);
        }
    }

    private class ToLccConst2 {
        double _CR11;
        double _CR12;
        double _CR13;
        double _CR14;
        double _CR15;
        double _CR21;
        double _CR22;
        double _CR23;
        double _CR24;
        double _CR25;
        double _xlonz;
        double _rx;
        double _rz;
        double _p1;
        double _xl;

        public ToLccConst2(OrmData e_constants, SRF_LCC_Params params) {
            double xl;
            double rn12;
            double phiz1 = params.latitude1;
            double phiz2 = params.latitude2;
            this._xlonz = params.origin_longitude;
            double latitude_origin = params.origin_latitude;
            if (e_constants.Eps != 0.0) {
                double AA1 = 1.0000000000349;
                double AA2 = -0.643155723158021;
                double AA3 = -0.333332134894985;
                double AA4 = -2.41457540671514E-5;
                double AA5 = 0.143376648162652;
                double AA6 = 0.356844276587295;
                double AA7 = -0.333332875955149;
                double AA8 = 0.0;
                double AA9 = 0.0;
                double BB1 = AA1;
                double BB2 = e_constants.Eps2 * AA2;
                double BB3 = e_constants.Eps2 * (AA3 + e_constants.Eps * (AA4 + e_constants.Eps * AA5));
                double BB4 = e_constants.Eps2 * AA6;
                double BB5 = e_constants.Eps2 * (AA7 + e_constants.Eps * (AA8 + e_constants.Eps * AA9));
                this._CR11 = BB3 / BB5 - 1.87E-12;
                this._CR12 = (BB2 - BB4 * BB3 / BB5) / BB5;
                this._CR13 = (BB1 - BB3 / BB5) / BB5;
                this._CR14 = 1.0 / BB5;
                this._CR15 = BB4 / BB5;
                double AB1 = 0.999999999957885;
                double AB2 = -1.15979311942142;
                double AB3 = -0.333339671395063;
                double AB4 = 2.76473457331734E-4;
                double AB5 = 0.587786240368508;
                double AB6 = -0.159793128888088;
                double AB7 = -0.33333346598215;
                double AB8 = 7.46505041501704E-5;
                double AB9 = -0.0701559218182283;
                BB1 = AB1;
                BB2 = e_constants.Eps2 * AB2;
                BB3 = e_constants.Eps2 * (AB3 + e_constants.Eps * (AB4 + e_constants.Eps * AB5));
                BB4 = e_constants.Eps2 * AB6;
                BB5 = e_constants.Eps2 * (AB7 + e_constants.Eps * (AB8 + e_constants.Eps * AB9));
                this._CR21 = BB3 / BB5 - 2.689E-12;
                this._CR22 = (BB2 - BB4 * BB3 / BB5) / BB5;
                this._CR23 = (BB1 - BB3 / BB5) / BB5;
                this._CR24 = 1.0 / BB5;
                this._CR25 = BB4 / BB5;
            }
            double sfx = Math.sin(latitude_origin);
            double s1 = Math.sin(phiz1);
            double s2 = Math.sin(phiz2);
            double s12 = s1 * s1;
            double c12 = 1.0 - s12;
            double s22 = s2 * s2;
            double c22 = 1.0 - s22;
            double pz = Math.tan(0.7853981633974483 + 0.5 * latitude_origin);
            double p1 = Math.tan(0.7853981633974483 + 0.5 * phiz1);
            double p2 = Math.tan(0.7853981633974483 + 0.5 * phiz2);
            if (e_constants.Eps != 0.0) {
                pz *= Math.pow((1.0 - e_constants.Eps * sfx) / (e_constants.Eps * sfx + 1.0), e_constants.EpsH);
                rn12 = e_constants.A2 / (1.0 - e_constants.Eps2 * s12);
                double rn22 = e_constants.A2 / (1.0 - e_constants.Eps2 * s22);
                double temp = (p2 *= Math.pow((1.0 - e_constants.Eps * s2) / (e_constants.Eps * s2 + 1.0), e_constants.EpsH)) / (p1 *= Math.pow((1.0 - e_constants.Eps * s1) / (e_constants.Eps * s1 + 1.0), e_constants.EpsH));
                xl = 0.5 * Math.log(rn12 * c12 / (c22 * rn22)) / Math.log(temp);
            } else {
                rn12 = e_constants.A2;
                double temp = p2 / p1;
                xl = 0.5 * Math.log(c12 / c22) / Math.log(temp);
            }
            double rx2 = rn12 * c12 / (xl * xl);
            double rx = Math.sqrt(rx2);
            double rz = rx * Math.pow(p1 / pz, xl);
            this._rx = rx;
            this._rz = rz;
            this._xl = xl;
            this._p1 = p1;
        }
    }

    private class ToLccConst1 {
        double _CR11;
        double _CR12;
        double _CR13;
        double _CR14;
        double _CR15;
        double _CR21;
        double _CR22;
        double _CR23;
        double _CR24;
        double _CR25;
        double _xlonz;
        double _xl;
        double _pz;
        double _rz;
        double _rho_origin;

        public ToLccConst1(OrmData e_constants, SRF_LCC_Params params) {
            double rz;
            double phiz = params.latitude1;
            this._xlonz = params.origin_longitude;
            double latitude_origin = params.origin_latitude;
            double xl = Math.sin(phiz);
            double xl2 = xl * xl;
            double pz = Math.tan(0.7853981633974483 + 0.5 * phiz);
            double sin_org = Math.sin(latitude_origin);
            double porg = Math.tan(0.7853981633974483 + 0.5 * latitude_origin);
            if (e_constants.Eps != 0.0) {
                double AA1 = 1.0000000000349;
                double AA2 = -0.643155723158021;
                double AA3 = -0.333332134894985;
                double AA4 = -2.41457540671514E-5;
                double AA5 = 0.143376648162652;
                double AA6 = 0.356844276587295;
                double AA7 = -0.333332875955149;
                double AA8 = 0.0;
                double AA9 = 0.0;
                double BB1 = AA1;
                double BB2 = e_constants.Eps2 * AA2;
                double BB3 = e_constants.Eps2 * (AA3 + e_constants.Eps * (AA4 + e_constants.Eps * AA5));
                double BB4 = e_constants.Eps2 * AA6;
                double BB5 = e_constants.Eps2 * (AA7 + e_constants.Eps * (AA8 + e_constants.Eps * AA9));
                this._CR11 = BB3 / BB5 - 1.87E-12;
                this._CR12 = (BB2 - BB4 * BB3 / BB5) / BB5;
                this._CR13 = (BB1 - BB3 / BB5) / BB5;
                this._CR14 = 1.0 / BB5;
                this._CR15 = BB4 / BB5;
                double AB1 = 0.999999999957885;
                double AB2 = -1.15979311942142;
                double AB3 = -0.333339671395063;
                double AB4 = 2.76473457331734E-4;
                double AB5 = 0.587786240368508;
                double AB6 = -0.159793128888088;
                double AB7 = -0.33333346598215;
                double AB8 = 7.46505041501704E-5;
                double AB9 = -0.0701559218182283;
                BB1 = AB1;
                BB2 = e_constants.Eps2 * AB2;
                BB3 = e_constants.Eps2 * (AB3 + e_constants.Eps * (AB4 + e_constants.Eps * AB5));
                BB4 = e_constants.Eps2 * AB6;
                BB5 = e_constants.Eps2 * (AB7 + e_constants.Eps * (AB8 + e_constants.Eps * AB9));
                this._CR21 = BB3 / BB5 - 2.689E-12;
                this._CR22 = (BB2 - BB4 * BB3 / BB5) / BB5;
                this._CR23 = (BB1 - BB3 / BB5) / BB5;
                this._CR24 = 1.0 / BB5;
                this._CR25 = BB4 / BB5;
                pz = Math.pow((1.0 - e_constants.Eps * xl) / (e_constants.Eps * xl + 1.0), e_constants.EpsH) * pz;
                porg = Math.pow((1.0 - e_constants.Eps * sin_org) / (e_constants.Eps * sin_org + 1.0), e_constants.EpsH) * porg;
                rz = e_constants.A * Math.cos(phiz) / (xl * Math.sqrt(1.0 - e_constants.Eps2 * xl2));
            } else {
                rz = e_constants.A * Math.cos(phiz) / xl;
            }
            this._xl = xl;
            this._pz = pz;
            this._rz = rz;
            pz = Math.abs(porg) <= 1.0E-12 ? 0.0 : (pz /= porg);
            this._rho_origin = rz * Math.pow(pz, xl);
        }
    }

    private class ToOmerConst {
        double sa0;
        double ca0;
        double cl0;
        double sl0;
        double ak0;
        double lambda_0;

        public ToOmerConst(OrmData e_constants, SRF_OM_Params params) {
            double sin_lat1 = 0.0;
            double cos_lat1 = 0.0;
            double sin_lat2 = 0.0;
            double cos_lat2 = 0.0;
            double sin_lon1 = 0.0;
            double cos_lon1 = 0.0;
            double sin_lon2 = 0.0;
            double cos_lon2 = 0.0;
            double p0 = 0.0;
            double q0 = 0.0;
            double alpha_0 = 0.0;
            double sin_lambda_1_minus_lambda_0 = 0.0;
            double sin_lambda_2_minus_lambda_0 = 0.0;
            sin_lat1 = Math.sin(params.latitude1);
            cos_lat1 = Math.cos(params.latitude1);
            sin_lat2 = Math.sin(params.latitude2);
            cos_lat2 = Math.cos(params.latitude2);
            sin_lon1 = Math.sin(params.longitude1);
            cos_lon1 = Math.cos(params.longitude1);
            sin_lon2 = Math.sin(params.longitude2);
            cos_lon2 = Math.cos(params.longitude2);
            p0 = cos_lat1 * sin_lat2 * sin_lon1 - sin_lat1 * cos_lat2 * sin_lon2;
            q0 = cos_lat1 * sin_lat2 * cos_lon1 - sin_lat1 * cos_lat2 * cos_lon2;
            this.lambda_0 = Math.atan2(p0, q0);
            this.cl0 = Math.cos(this.lambda_0);
            this.sl0 = Math.sin(this.lambda_0);
            sin_lambda_1_minus_lambda_0 = sin_lon1 * this.cl0 - cos_lon1 * this.sl0;
            sin_lambda_2_minus_lambda_0 = sin_lon2 * this.cl0 - cos_lon2 * this.sl0;
            alpha_0 = Math.abs(sin_lambda_1_minus_lambda_0) >= Math.abs(sin_lambda_2_minus_lambda_0) ? Math.atan(sin_lat1 / (cos_lat1 * sin_lambda_1_minus_lambda_0)) : Math.atan(sin_lat2 / (cos_lat2 * sin_lambda_2_minus_lambda_0));
            this.sa0 = Math.sin(alpha_0);
            this.ca0 = Math.cos(alpha_0);
            this.ak0 = e_constants.A * params.central_scale;
        }
    }

    private class ToMercConst {
        double CR11;
        double CR12;
        double CR13;
        double CR14;
        double CR15;
        double CR21;
        double CR22;
        double CR23;
        double CR24;
        double CR25;
        double scale;
        double longitude_origin;

        public ToMercConst(OrmData e_constants, SRF_M_Params params) {
            this.longitude_origin = params.origin_longitude;
            this.scale = params.central_scale;
            if (e_constants.Eps2 != 0.0) {
                double AA1 = 1.0000000000349;
                double AA2 = -0.643155723158021;
                double AA3 = -0.333332134894985;
                double AA4 = -2.41457540671514E-5;
                double AA5 = 0.143376648162652;
                double AA6 = 0.356844276587295;
                double AA7 = -0.333332875955149;
                double AA8 = 0.0;
                double AA9 = 0.0;
                double BB1 = AA1;
                double BB2 = e_constants.Eps2 * AA2;
                double BB3 = e_constants.Eps2 * (AA3 + e_constants.Eps * (AA4 + e_constants.Eps * AA5));
                double BB4 = e_constants.Eps2 * AA6;
                double BB5 = e_constants.Eps2 * (AA7 + e_constants.Eps * (AA8 + e_constants.Eps * AA9));
                this.CR11 = BB3 / BB5 - 1.87E-12;
                this.CR12 = (BB2 - BB4 * BB3 / BB5) / BB5;
                this.CR13 = (BB1 - BB3 / BB5) / BB5;
                this.CR14 = 1.0 / BB5;
                this.CR15 = BB4 / BB5;
                double AB1 = 0.999999999957885;
                double AB2 = -1.15979311942142;
                double AB3 = -0.333339671395063;
                double AB4 = 2.76473457331734E-4;
                double AB5 = 0.587786240368508;
                double AB6 = -0.159793128888088;
                double AB7 = -0.33333346598215;
                double AB8 = 7.46505041501704E-5;
                double AB9 = -0.0701559218182283;
                BB1 = AB1;
                BB2 = e_constants.Eps2 * AB2;
                BB3 = e_constants.Eps2 * (AB3 + e_constants.Eps * (AB4 + e_constants.Eps * AB5));
                BB4 = e_constants.Eps2 * AB6;
                BB5 = e_constants.Eps2 * (AB7 + e_constants.Eps * (AB8 + e_constants.Eps * AB9));
                this.CR21 = BB3 / BB5 + 2.689E-12;
                this.CR22 = (BB2 - BB4 * BB3 / BB5) / BB5;
                this.CR23 = (BB1 - BB3 / BB5) / BB5;
                this.CR24 = 1.0 / BB5;
                this.CR25 = BB4 / BB5;
            }
        }
    }

    private class ToTmerConst {
        double Cdb6;
        double Cdb24;
        double Cdb120;
        double Cdb720;
        double Cdb5040;
        double Cdb40320;
        double CScale;
        double latitude_origin;
        double longitude_origin;
        double smz;
        Const.ArcLengthConst arclength_spec;

        public ToTmerConst(OrmData e_constants, SRF_TM_Params params) {
            this.latitude_origin = params.origin_latitude;
            this.longitude_origin = params.origin_longitude;
            this.CScale = params.central_scale;
            this.Cdb6 = 0.166666666666667;
            this.Cdb24 = 0.0416666666666667;
            this.Cdb120 = 0.00833333333333333;
            this.Cdb720 = 0.00138888888888888;
            this.Cdb5040 = 1.984126984126984E-4;
            this.Cdb40320 = 2.48015873015873E-5;
            if (e_constants.Eps != 0.0) {
                this.smz = Const.exactArcLength(e_constants.A, e_constants.C, e_constants.Eps2, this.latitude_origin);
                this.arclength_spec = new Const.ArcLengthConst(e_constants);
            } else {
                this.smz = e_constants.A * this.latitude_origin;
            }
        }
    }
}

