/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Const;
import SRM.Coord;
import SRM.Coord2D;
import SRM.Coord_ClassType;
import SRM.SRF_LocalSpaceAzimuthal;

public class Coord2D_LocalSpaceAzimuthal
extends Coord2D {
    public Coord2D_LocalSpaceAzimuthal(SRF_LocalSpaceAzimuthal srf) {
        super(srf, Coord_ClassType.LSA_2D);
        this.setValues(Double.NaN, Double.NaN);
    }

    public Coord2D_LocalSpaceAzimuthal(SRF_LocalSpaceAzimuthal srf, double azimuth, double radius) {
        super(srf, Coord_ClassType.LSA_2D);
        this.setValues(azimuth, radius);
    }

    public Coord2D_LocalSpaceAzimuthal(Coord2D_LocalSpaceAzimuthal original) {
        super(original.getSRF(), Coord_ClassType.LSA_2D);
        this.setValues(original._values[0], original._values[1]);
    }

    public void setValues(double azimuth, double radius) {
        this._values[0] = azimuth;
        this._values[1] = radius;
    }

    public double get_azimuth() {
        return this._values[0];
    }

    public double get_radius() {
        return this._values[1];
    }

    public void set_azimuth(double value) {
        this._values[0] = value;
    }

    public void set_radius(double value) {
        this._values[1] = value;
    }

    public boolean isEqual(Coord coord) {
        if (coord == null) {
            return false;
        }
        double[] tmp = coord.getValues();
        return coord instanceof Coord2D_LocalSpaceAzimuthal && Const.isEqual(this._values[0], tmp[0], 1.0E-6) && Const.isEqual(this._values[1], tmp[1], 1.0E-6);
    }

    public String toString() {
        return new String("[ " + this._values[0] + ", " + this._values[1] + " ]");
    }
}

