/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Coord;
import SRM.Coord_ClassType;
import SRM.SrmException;

public abstract class CoordSurf
extends Coord {
    protected double[] _values = new double[2];

    protected CoordSurf(BaseSRF assocSRF, Coord_ClassType type) {
        super(assocSRF, type);
    }

    public double[] getValues() {
        return this._values;
    }

    public void setValues(double[] values) throws SrmException {
        try {
            this._values[0] = values[0];
            this._values[1] = values[1];
        }
        catch (RuntimeException primary_axis) {
            throw new SrmException(8, new String("CoordSurf.setValues: Input array size different than 2"));
        }
    }

    public boolean isEqual(Coord coord) {
        if (coord == null) {
            return false;
        }
        double[] tmp = coord.getValues();
        return this.getClass() == coord.getClass() && Const.isEqual(this._values[0], tmp[0], 1.0E-6) && Const.isEqual(this._values[1], tmp[1], 1.0E-6);
    }

    public void copyTo(CoordSurf coord) throws SrmException {
        if (coord == null) {
            throw new SrmException(8, new String("CoordSurf.copyTo: Input coordinate reference is null"));
        }
        if (this.getSRF() != coord.getSRF()) {
            throw new SrmException(5, new String("CoordSurf.copyTo: Input coordinate not of the same SRF"));
        }
        coord._values[0] = this._values[0];
        coord._values[1] = this._values[1];
    }
}

