/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Coord3D;
import SRM.SrmException;

public class Direction
implements Cloneable {
    private BaseSRF _srf;
    protected Coord3D _ref_coord;
    protected double[] _vec = new double[3];

    public BaseSRF getSRF() {
        return this._srf;
    }

    public Coord3D getRefCoord() throws SrmException {
        try {
            return (Coord3D)this._ref_coord.makeClone();
        }
        catch (SrmException ex) {
            throw new SrmException(20, new String("Direction.getRefCoord: Unable to return reference location"));
        }
    }

    public double[] getVec() {
        return this._vec;
    }

    public double getVectorComp1() {
        return this._vec[0];
    }

    public double getVectorComp2() {
        return this._vec[1];
    }

    public double getVectorComp3() {
        return this._vec[2];
    }

    public double getVectorComp(int n) throws SrmException {
        if (n < 1 || n > 3) {
            throw new SrmException(8, new String("Direction.getVectorComp: Vector component index out of bound"));
        }
        return this._vec[n - 1];
    }

    public void setVec(double[] vec) throws SrmException {
        try {
            this._vec[0] = vec[0];
            this._vec[1] = vec[1];
            this._vec[2] = vec[2];
        }
        catch (RuntimeException primary_axis) {
            throw new SrmException(8, new String("Direction.setVec: Input vector size different than 3"));
        }
    }

    public void setVectorComp(double comp1, double comp2, double comp3) {
        this._vec[0] = comp1;
        this._vec[1] = comp2;
        this._vec[2] = comp3;
    }

    public void setVectorComp(int n, double comp) throws SrmException {
        if (n < 1 || n > 3) {
            throw new SrmException(8, new String("Direction.setVectorComp: Vector component index out of bound"));
        }
        this._vec[n - 1] = comp;
    }

    public void copyTo(Direction dir) throws SrmException {
        if (dir == null) {
            throw new SrmException(8, new String("Direction.copyTo: Input direction reference is null"));
        }
        if (this._ref_coord != dir._ref_coord) {
            throw new SrmException(5, new String("Direciton.copyTo: Input direction not referring to the same reference coordinate"));
        }
        dir._vec[0] = this._vec[0];
        dir._vec[1] = this._vec[1];
        dir._vec[2] = this._vec[2];
    }

    public Direction makeClone() throws SrmException {
        try {
            return (Direction)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new SrmException(20, new String("Direction.makeClone(): failed"));
        }
    }

    public boolean isEqual(Direction dir) {
        return dir != null && this._srf == dir._srf && this._ref_coord == dir._ref_coord && Const.isEqual(this._vec[0], dir._vec[0], 1.0E-6) && Const.isEqual(this._vec[1], dir._vec[1], 1.0E-6) && Const.isEqual(this._vec[2], dir._vec[2], 1.0E-6);
    }

    public String toString() {
        return "[ " + this._vec[0] + ", " + this._vec[1] + ", " + this._vec[2] + " ]";
    }

    protected Direction(BaseSRF srf, Coord3D ref_coord, double[] vec) {
        this._srf = srf;
        this._ref_coord = ref_coord;
        this._vec = vec;
    }

    protected Coord3D getInternalRefCoord() {
        return this._ref_coord;
    }
}

