/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_3D;
import SRM.Const;
import SRM.Coord3D;
import SRM.DShiftConv;
import SRM.LteSupport;
import SRM.SRF_LTSE_Params;
import SRM.SRF_LocalTangentSpaceEuclidean;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class DirectionSupport {
    DirectionSupport() {
    }

    private static SRM_SRFT_Code GetDirectionTreatmentFrameid(SRM_SRFT_Code srft_code) {
        SRM_SRFT_Code retCode = srft_code == SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC ? SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC : (srft_code == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN || srft_code == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC || srft_code == SRM_SRFT_Code.SRFTCOD_PLANETODETIC || srft_code == SRM_SRFT_Code.SRFTCOD_MERCATOR || srft_code == SRM_SRFT_Code.SRFTCOD_OBLIQUE_MERCATOR_SPHERICAL || srft_code == SRM_SRFT_Code.SRFTCOD_TRANSVERSE_MERCATOR || srft_code == SRM_SRFT_Code.SRFTCOD_LAMBERT_CONFORMAL_CONIC || srft_code == SRM_SRFT_Code.SRFTCOD_POLAR_STEREOGRAPHIC || srft_code == SRM_SRFT_Code.SRFTCOD_EQUIDISTANT_CYLINDRICAL ? SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN : SRM_SRFT_Code.SRFTCOD_UNSPECIFIED);
        return retCode;
    }

    private static int GetDirectionCase(BaseSRF srcSrf, BaseSRF tgtSrf) {
        int retCase = 0;
        SRM_SRFT_Code frame_id_src = DirectionSupport.GetDirectionTreatmentFrameid(srcSrf.getSRFTemplateCode());
        SRM_SRFT_Code frame_id_tgt = DirectionSupport.GetDirectionTreatmentFrameid(tgtSrf.getSRFTemplateCode());
        if (frame_id_tgt == SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC) {
            if (frame_id_src == SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC) {
                retCase = 1;
            } else if (frame_id_src == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN) {
                retCase = 2;
            }
        } else if (frame_id_tgt == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN) {
            if (frame_id_src == SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC) {
                retCase = 3;
            } else if (frame_id_src == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN) {
                retCase = 4;
            }
        }
        return retCase;
    }

    protected static void changeDirectionVector(BaseSRF_3D srcSrf, Coord3D ref_loc_src, double[] dir_values_src, BaseSRF_3D tgtSrf, Coord3D ref_loc_tgt, double[] dir_values_tgt) throws SrmException {
        double[] temp_vector = new double[3];
        double[] temp_vector2 = new double[3];
        DShiftConv dShift = new DShiftConv();
        dShift.setDShiftConst(srcSrf.getOrm(), srcSrf.getRt(), tgtSrf.getOrm(), tgtSrf.getRt());
        try {
            switch (DirectionSupport.GetDirectionCase(srcSrf, tgtSrf)) {
                case 1: {
                    Const.multMatrixSubsetVector(dShift._Tst, dir_values_src, dir_values_tgt, 3);
                    Const.normalizeDirection(dir_values_tgt);
                    break;
                }
                case 2: {
                    double[][] F = new double[4][4];
                    if (srcSrf instanceof SRF_LocalTangentSpaceEuclidean) {
                        SRF_LTSE_Params lteParams = ((SRF_LocalTangentSpaceEuclidean)srcSrf).getSRFParameters();
                        LteSupport.LTP_Rotation_Matrix_F(F, lteParams.geodetic_longitude, lteParams.geodetic_latitude, lteParams.azimuth);
                    } else {
                        LteSupport.LTP_Rotation_Matrix_F(F, ref_loc_src.getValues()[0], ref_loc_src.getValues()[1], 0.0);
                    }
                    Const.multMatrixSubsetVector(F, dir_values_src, temp_vector, 3);
                    Const.multMatrixSubsetVector(dShift._Tst, temp_vector, dir_values_tgt, 3);
                    Const.normalizeDirection(dir_values_tgt);
                    break;
                }
                case 3: {
                    double[][] F = new double[4][4];
                    double[][] F_inv = new double[4][4];
                    if (tgtSrf instanceof SRF_LocalTangentSpaceEuclidean) {
                        SRF_LTSE_Params lteParams = ((SRF_LocalTangentSpaceEuclidean)tgtSrf).getSRFParameters();
                        LteSupport.LTP_Rotation_Matrix_F(F, lteParams.geodetic_longitude, lteParams.geodetic_latitude, lteParams.azimuth);
                    } else {
                        LteSupport.LTP_Rotation_Matrix_F(F, ref_loc_tgt.getValues()[0], ref_loc_tgt.getValues()[1], 0.0);
                    }
                    Const.invert(F, F_inv);
                    Const.multMatrixSubsetVector(dShift._Tst, dir_values_src, temp_vector, 3);
                    Const.multMatrixSubsetVector(F_inv, temp_vector, dir_values_tgt, 3);
                    Const.normalizeDirection(dir_values_tgt);
                    break;
                }
                case 4: {
                    SRF_LTSE_Params lteParams;
                    double[][] src_F = new double[4][4];
                    double[][] tgt_F = new double[4][4];
                    double[][] tgt_F_inv = new double[4][4];
                    if (srcSrf instanceof SRF_LocalTangentSpaceEuclidean) {
                        lteParams = ((SRF_LocalTangentSpaceEuclidean)srcSrf).getSRFParameters();
                        LteSupport.LTP_Rotation_Matrix_F(src_F, lteParams.geodetic_longitude, lteParams.geodetic_latitude, lteParams.azimuth);
                    } else {
                        LteSupport.LTP_Rotation_Matrix_F(src_F, ref_loc_src.getValues()[0], ref_loc_src.getValues()[1], 0.0);
                    }
                    if (tgtSrf instanceof SRF_LocalTangentSpaceEuclidean) {
                        lteParams = ((SRF_LocalTangentSpaceEuclidean)tgtSrf).getSRFParameters();
                        LteSupport.LTP_Rotation_Matrix_F(tgt_F, lteParams.geodetic_longitude, lteParams.geodetic_latitude, lteParams.azimuth);
                    } else {
                        LteSupport.LTP_Rotation_Matrix_F(tgt_F, ref_loc_tgt.getValues()[0], ref_loc_tgt.getValues()[1], 0.0);
                    }
                    Const.invert(tgt_F, tgt_F_inv);
                    Const.multMatrixSubsetVector(src_F, dir_values_src, temp_vector, 3);
                    Const.multMatrixSubsetVector(dShift._Tst, temp_vector, temp_vector2, 3);
                    Const.multMatrixSubsetVector(tgt_F_inv, temp_vector2, dir_values_tgt, 3);
                    Const.normalizeDirection(dir_values_tgt);
                    break;
                }
                default: {
                    throw new SrmException(12, new String("changeDirectionSRF: case not supported"));
                }
            }
            if (dir_values_tgt[0] == 1.0) {
                throw new SrmException(12, new String("changeDirectionSRF: case not supported"));
            }
        }
        catch (SrmException ex) {
            throw new SrmException(20, new String("changeDirectionSRF: inactionable error"));
        }
    }
}

