/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.GcsGtrsDataSet;
import SRM.SrmException;

class GtrsDataSet
extends GcsGtrsDataSet {
    public static int TABLE_SIZE = 49896;
    private static int ROWS = 180;
    private static GtrsDataSet[] table = new GtrsDataSet[]{new GtrsDataSet(1, -89.5, -165.0, 30.0, 0.03333333333333333, 12, 165.0, 30.0), new GtrsDataSet(13, -88.5, -165.0, 30.0, 0.03333333333333333, 24, 165.0, 30.0), new GtrsDataSet(25, -87.5, -172.5, 15.0, 0.06666666666666667, 48, 172.5, 15.0), new GtrsDataSet(49, -86.5, -172.5, 15.0, 0.06666666666666667, 72, 172.5, 15.0), new GtrsDataSet(73, -85.5, -175.0, 10.0, 0.1, 108, 175.0, 10.0), new GtrsDataSet(109, -84.5, -175.0, 10.0, 0.1, 144, 175.0, 10.0), new GtrsDataSet(145, -83.5, -177.0, 6.0, 0.16666666666666666, 204, 177.0, 6.0), new GtrsDataSet(205, -82.5, -177.0, 6.0, 0.16666666666666666, 264, 177.0, 6.0), new GtrsDataSet(265, -81.5, -177.0, 6.0, 0.16666666666666666, 324, 177.0, 6.0), new GtrsDataSet(325, -80.5, -177.0, 6.0, 0.16666666666666666, 384, 177.0, 6.0), new GtrsDataSet(385, -79.5, -177.5, 5.0, 0.2, 456, 177.5, 5.0), new GtrsDataSet(457, -78.5, -177.5, 5.0, 0.2, 528, 177.5, 5.0), new GtrsDataSet(529, -77.5, -178.5, 3.0, 0.3333333333333333, 648, 178.5, 3.0), new GtrsDataSet(649, -76.5, -178.5, 3.0, 0.3333333333333333, 768, 178.5, 3.0), new GtrsDataSet(769, -75.5, -178.5, 3.0, 0.3333333333333333, 888, 178.5, 3.0), new GtrsDataSet(889, -74.5, -178.5, 3.0, 0.3333333333333333, 1008, 178.5, 3.0), new GtrsDataSet(1009, -73.5, -178.5, 3.0, 0.3333333333333333, 1128, 178.5, 3.0), new GtrsDataSet(1129, -72.5, -178.5, 3.0, 0.3333333333333333, 1248, 178.5, 3.0), new GtrsDataSet(1249, -71.5, -178.5, 3.0, 0.3333333333333333, 1368, 178.5, 3.0), new GtrsDataSet(1369, -70.5, -179.0, 2.0, 0.5, 1548, 179.0, 2.0), new GtrsDataSet(1549, -69.5, -179.0, 2.0, 0.5, 1728, 179.0, 2.0), new GtrsDataSet(1729, -68.5, -179.0, 2.0, 0.5, 1908, 179.0, 2.0), new GtrsDataSet(1909, -67.5, -179.0, 2.0, 0.5, 2088, 179.0, 2.0), new GtrsDataSet(2089, -66.5, -179.0, 2.0, 0.5, 2268, 179.0, 2.0), new GtrsDataSet(2269, -65.5, -179.0, 2.0, 0.5, 2448, 179.0, 2.0), new GtrsDataSet(2449, -64.5, -179.0, 2.0, 0.5, 2628, 179.0, 2.0), new GtrsDataSet(2629, -63.5, -179.0, 2.0, 0.5, 2808, 179.0, 2.0), new GtrsDataSet(2809, -62.5, -179.0, 2.0, 0.5, 2988, 179.0, 2.0), new GtrsDataSet(2989, -61.5, -179.0, 2.0, 0.5, 3168, 179.0, 2.0), new GtrsDataSet(3169, -60.5, -179.0, 2.0, 0.5, 3348, 179.0, 2.0), new GtrsDataSet(3349, -59.5, -179.5, 1.0, 1.0, 3708, 179.5, 1.0), new GtrsDataSet(3709, -58.5, -179.5, 1.0, 1.0, 4068, 179.5, 1.0), new GtrsDataSet(4069, -57.5, -179.5, 1.0, 1.0, 4428, 179.5, 1.0), new GtrsDataSet(4429, -56.5, -179.5, 1.0, 1.0, 4788, 179.5, 1.0), new GtrsDataSet(4789, -55.5, -179.5, 1.0, 1.0, 5148, 179.5, 1.0), new GtrsDataSet(5149, -54.5, -179.5, 1.0, 1.0, 5508, 179.5, 1.0), new GtrsDataSet(5509, -53.5, -179.5, 1.0, 1.0, 5868, 179.5, 1.0), new GtrsDataSet(5869, -52.5, -179.5, 1.0, 1.0, 6228, 179.5, 1.0), new GtrsDataSet(6229, -51.5, -179.5, 1.0, 1.0, 6588, 179.5, 1.0), new GtrsDataSet(6589, -50.5, -179.5, 1.0, 1.0, 6948, 179.5, 1.0), new GtrsDataSet(6949, -49.5, -179.5, 1.0, 1.0, 7308, 179.5, 1.0), new GtrsDataSet(7309, -48.5, -179.5, 1.0, 1.0, 7668, 179.5, 1.0), new GtrsDataSet(7669, -47.5, -179.5, 1.0, 1.0, 8028, 179.5, 1.0), new GtrsDataSet(8029, -46.5, -179.5, 1.0, 1.0, 8388, 179.5, 1.0), new GtrsDataSet(8389, -45.5, -179.5, 1.0, 1.0, 8748, 179.5, 1.0), new GtrsDataSet(8749, -44.5, -179.5, 1.0, 1.0, 9108, 179.5, 1.0), new GtrsDataSet(9109, -43.5, -179.5, 1.0, 1.0, 9468, 179.5, 1.0), new GtrsDataSet(9469, -42.5, -179.5, 1.0, 1.0, 9828, 179.5, 1.0), new GtrsDataSet(9829, -41.5, -179.5, 1.0, 1.0, 10188, 179.5, 1.0), new GtrsDataSet(10189, -40.5, -179.5, 1.0, 1.0, 10548, 179.5, 1.0), new GtrsDataSet(10549, -39.5, -179.5, 1.0, 1.0, 10908, 179.5, 1.0), new GtrsDataSet(10909, -38.5, -179.5, 1.0, 1.0, 11268, 179.5, 1.0), new GtrsDataSet(11269, -37.5, -179.5, 1.0, 1.0, 11628, 179.5, 1.0), new GtrsDataSet(11629, -36.5, -179.5, 1.0, 1.0, 11988, 179.5, 1.0), new GtrsDataSet(11989, -35.5, -179.5, 1.0, 1.0, 12348, 179.5, 1.0), new GtrsDataSet(12349, -34.5, -179.5, 1.0, 1.0, 12708, 179.5, 1.0), new GtrsDataSet(12709, -33.5, -179.5, 1.0, 1.0, 13068, 179.5, 1.0), new GtrsDataSet(13069, -32.5, -179.5, 1.0, 1.0, 13428, 179.5, 1.0), new GtrsDataSet(13429, -31.5, -179.5, 1.0, 1.0, 13788, 179.5, 1.0), new GtrsDataSet(13789, -30.5, -179.5, 1.0, 1.0, 14148, 179.5, 1.0), new GtrsDataSet(14149, -29.5, -179.5, 1.0, 1.0, 14508, 179.5, 1.0), new GtrsDataSet(14509, -28.5, -179.5, 1.0, 1.0, 14868, 179.5, 1.0), new GtrsDataSet(14869, -27.5, -179.5, 1.0, 1.0, 15228, 179.5, 1.0), new GtrsDataSet(15229, -26.5, -179.5, 1.0, 1.0, 15588, 179.5, 1.0), new GtrsDataSet(15589, -25.5, -179.5, 1.0, 1.0, 15948, 179.5, 1.0), new GtrsDataSet(15949, -24.5, -179.5, 1.0, 1.0, 16308, 179.5, 1.0), new GtrsDataSet(16309, -23.5, -179.5, 1.0, 1.0, 16668, 179.5, 1.0), new GtrsDataSet(16669, -22.5, -179.5, 1.0, 1.0, 17028, 179.5, 1.0), new GtrsDataSet(17029, -21.5, -179.5, 1.0, 1.0, 17388, 179.5, 1.0), new GtrsDataSet(17389, -20.5, -179.5, 1.0, 1.0, 17748, 179.5, 1.0), new GtrsDataSet(17749, -19.5, -179.5, 1.0, 1.0, 18108, 179.5, 1.0), new GtrsDataSet(18109, -18.5, -179.5, 1.0, 1.0, 18468, 179.5, 1.0), new GtrsDataSet(18469, -17.5, -179.5, 1.0, 1.0, 18828, 179.5, 1.0), new GtrsDataSet(18829, -16.5, -179.5, 1.0, 1.0, 19188, 179.5, 1.0), new GtrsDataSet(19189, -15.5, -179.5, 1.0, 1.0, 19548, 179.5, 1.0), new GtrsDataSet(19549, -14.5, -179.5, 1.0, 1.0, 19908, 179.5, 1.0), new GtrsDataSet(19909, -13.5, -179.5, 1.0, 1.0, 20268, 179.5, 1.0), new GtrsDataSet(20269, -12.5, -179.5, 1.0, 1.0, 20628, 179.5, 1.0), new GtrsDataSet(20629, -11.5, -179.5, 1.0, 1.0, 20988, 179.5, 1.0), new GtrsDataSet(20989, -10.5, -179.5, 1.0, 1.0, 21348, 179.5, 1.0), new GtrsDataSet(21349, -9.5, -179.5, 1.0, 1.0, 21708, 179.5, 1.0), new GtrsDataSet(21709, -8.5, -179.5, 1.0, 1.0, 22068, 179.5, 1.0), new GtrsDataSet(22069, -7.5, -179.5, 1.0, 1.0, 22428, 179.5, 1.0), new GtrsDataSet(22429, -6.5, -179.5, 1.0, 1.0, 22788, 179.5, 1.0), new GtrsDataSet(22789, -5.5, -179.5, 1.0, 1.0, 23148, 179.5, 1.0), new GtrsDataSet(23149, -4.5, -179.5, 1.0, 1.0, 23508, 179.5, 1.0), new GtrsDataSet(23509, -3.5, -179.5, 1.0, 1.0, 23868, 179.5, 1.0), new GtrsDataSet(23869, -2.5, -179.5, 1.0, 1.0, 24228, 179.5, 1.0), new GtrsDataSet(24229, -1.5, -179.5, 1.0, 1.0, 24588, 179.5, 1.0), new GtrsDataSet(24589, -0.5, -179.5, 1.0, 1.0, 24948, 179.5, 1.0), new GtrsDataSet(24949, 0.5, -179.5, 1.0, 1.0, 25308, 179.5, 1.0), new GtrsDataSet(25309, 1.5, -179.5, 1.0, 1.0, 25668, 179.5, 1.0), new GtrsDataSet(25669, 2.5, -179.5, 1.0, 1.0, 26028, 179.5, 1.0), new GtrsDataSet(26029, 3.5, -179.5, 1.0, 1.0, 26388, 179.5, 1.0), new GtrsDataSet(26389, 4.5, -179.5, 1.0, 1.0, 26748, 179.5, 1.0), new GtrsDataSet(26749, 5.5, -179.5, 1.0, 1.0, 27108, 179.5, 1.0), new GtrsDataSet(27109, 6.5, -179.5, 1.0, 1.0, 27468, 179.5, 1.0), new GtrsDataSet(27469, 7.5, -179.5, 1.0, 1.0, 27828, 179.5, 1.0), new GtrsDataSet(27829, 8.5, -179.5, 1.0, 1.0, 28188, 179.5, 1.0), new GtrsDataSet(28189, 9.5, -179.5, 1.0, 1.0, 28548, 179.5, 1.0), new GtrsDataSet(28549, 10.5, -179.5, 1.0, 1.0, 28908, 179.5, 1.0), new GtrsDataSet(28909, 11.5, -179.5, 1.0, 1.0, 29268, 179.5, 1.0), new GtrsDataSet(29269, 12.5, -179.5, 1.0, 1.0, 29628, 179.5, 1.0), new GtrsDataSet(29629, 13.5, -179.5, 1.0, 1.0, 29988, 179.5, 1.0), new GtrsDataSet(29989, 14.5, -179.5, 1.0, 1.0, 30348, 179.5, 1.0), new GtrsDataSet(30349, 15.5, -179.5, 1.0, 1.0, 30708, 179.5, 1.0), new GtrsDataSet(30709, 16.5, -179.5, 1.0, 1.0, 31068, 179.5, 1.0), new GtrsDataSet(31069, 17.5, -179.5, 1.0, 1.0, 31428, 179.5, 1.0), new GtrsDataSet(31429, 18.5, -179.5, 1.0, 1.0, 31788, 179.5, 1.0), new GtrsDataSet(31789, 19.5, -179.5, 1.0, 1.0, 32148, 179.5, 1.0), new GtrsDataSet(32149, 20.5, -179.5, 1.0, 1.0, 32508, 179.5, 1.0), new GtrsDataSet(32509, 21.5, -179.5, 1.0, 1.0, 32868, 179.5, 1.0), new GtrsDataSet(32869, 22.5, -179.5, 1.0, 1.0, 33228, 179.5, 1.0), new GtrsDataSet(33229, 23.5, -179.5, 1.0, 1.0, 33588, 179.5, 1.0), new GtrsDataSet(33589, 24.5, -179.5, 1.0, 1.0, 33948, 179.5, 1.0), new GtrsDataSet(33949, 25.5, -179.5, 1.0, 1.0, 34308, 179.5, 1.0), new GtrsDataSet(34309, 26.5, -179.5, 1.0, 1.0, 34668, 179.5, 1.0), new GtrsDataSet(34669, 27.5, -179.5, 1.0, 1.0, 35028, 179.5, 1.0), new GtrsDataSet(35029, 28.5, -179.5, 1.0, 1.0, 35388, 179.5, 1.0), new GtrsDataSet(35389, 29.5, -179.5, 1.0, 1.0, 35748, 179.5, 1.0), new GtrsDataSet(35749, 30.5, -179.5, 1.0, 1.0, 36108, 179.5, 1.0), new GtrsDataSet(36109, 31.5, -179.5, 1.0, 1.0, 36468, 179.5, 1.0), new GtrsDataSet(36469, 32.5, -179.5, 1.0, 1.0, 36828, 179.5, 1.0), new GtrsDataSet(36829, 33.5, -179.5, 1.0, 1.0, 37188, 179.5, 1.0), new GtrsDataSet(37189, 34.5, -179.5, 1.0, 1.0, 37548, 179.5, 1.0), new GtrsDataSet(37549, 35.5, -179.5, 1.0, 1.0, 37908, 179.5, 1.0), new GtrsDataSet(37909, 36.5, -179.5, 1.0, 1.0, 38268, 179.5, 1.0), new GtrsDataSet(38269, 37.5, -179.5, 1.0, 1.0, 38628, 179.5, 1.0), new GtrsDataSet(38629, 38.5, -179.5, 1.0, 1.0, 38988, 179.5, 1.0), new GtrsDataSet(38989, 39.5, -179.5, 1.0, 1.0, 39348, 179.5, 1.0), new GtrsDataSet(39349, 40.5, -179.5, 1.0, 1.0, 39708, 179.5, 1.0), new GtrsDataSet(39709, 41.5, -179.5, 1.0, 1.0, 40068, 179.5, 1.0), new GtrsDataSet(40069, 42.5, -179.5, 1.0, 1.0, 40428, 179.5, 1.0), new GtrsDataSet(40429, 43.5, -179.5, 1.0, 1.0, 40788, 179.5, 1.0), new GtrsDataSet(40789, 44.5, -179.5, 1.0, 1.0, 41148, 179.5, 1.0), new GtrsDataSet(41149, 45.5, -179.5, 1.0, 1.0, 41508, 179.5, 1.0), new GtrsDataSet(41509, 46.5, -179.5, 1.0, 1.0, 41868, 179.5, 1.0), new GtrsDataSet(41869, 47.5, -179.5, 1.0, 1.0, 42228, 179.5, 1.0), new GtrsDataSet(42229, 48.5, -179.5, 1.0, 1.0, 42588, 179.5, 1.0), new GtrsDataSet(42589, 49.5, -179.5, 1.0, 1.0, 42948, 179.5, 1.0), new GtrsDataSet(42949, 50.5, -179.5, 1.0, 1.0, 43308, 179.5, 1.0), new GtrsDataSet(43309, 51.5, -179.5, 1.0, 1.0, 43668, 179.5, 1.0), new GtrsDataSet(43669, 52.5, -179.5, 1.0, 1.0, 44028, 179.5, 1.0), new GtrsDataSet(44029, 53.5, -179.5, 1.0, 1.0, 44388, 179.5, 1.0), new GtrsDataSet(44389, 54.5, -179.5, 1.0, 1.0, 44748, 179.5, 1.0), new GtrsDataSet(44749, 55.5, -179.5, 1.0, 1.0, 45108, 179.5, 1.0), new GtrsDataSet(45109, 56.5, -179.5, 1.0, 1.0, 45468, 179.5, 1.0), new GtrsDataSet(45469, 57.5, -179.5, 1.0, 1.0, 45828, 179.5, 1.0), new GtrsDataSet(45829, 58.5, -179.5, 1.0, 1.0, 46188, 179.5, 1.0), new GtrsDataSet(46189, 59.5, -179.5, 1.0, 1.0, 46548, 179.5, 1.0), new GtrsDataSet(46549, 60.5, -179.0, 2.0, 0.5, 46728, 179.0, 2.0), new GtrsDataSet(46729, 61.5, -179.0, 2.0, 0.5, 46908, 179.0, 2.0), new GtrsDataSet(46909, 62.5, -179.0, 2.0, 0.5, 47088, 179.0, 2.0), new GtrsDataSet(47089, 63.5, -179.0, 2.0, 0.5, 47268, 179.0, 2.0), new GtrsDataSet(47269, 64.5, -179.0, 2.0, 0.5, 47448, 179.0, 2.0), new GtrsDataSet(47449, 65.5, -179.0, 2.0, 0.5, 47628, 179.0, 2.0), new GtrsDataSet(47629, 66.5, -179.0, 2.0, 0.5, 47808, 179.0, 2.0), new GtrsDataSet(47809, 67.5, -179.0, 2.0, 0.5, 47988, 179.0, 2.0), new GtrsDataSet(47989, 68.5, -179.0, 2.0, 0.5, 48168, 179.0, 2.0), new GtrsDataSet(48169, 69.5, -179.0, 2.0, 0.5, 48348, 179.0, 2.0), new GtrsDataSet(48349, 70.5, -179.0, 2.0, 0.5, 48528, 179.0, 2.0), new GtrsDataSet(48529, 71.5, -178.5, 3.0, 0.3333333333333333, 48648, 178.5, 3.0), new GtrsDataSet(48649, 72.5, -178.5, 3.0, 0.3333333333333333, 48768, 178.5, 3.0), new GtrsDataSet(48769, 73.5, -178.5, 3.0, 0.3333333333333333, 48888, 178.5, 3.0), new GtrsDataSet(48889, 74.5, -178.5, 3.0, 0.3333333333333333, 49008, 178.5, 3.0), new GtrsDataSet(49009, 75.5, -178.5, 3.0, 0.3333333333333333, 49128, 178.5, 3.0), new GtrsDataSet(49129, 76.5, -178.5, 3.0, 0.3333333333333333, 49248, 178.5, 3.0), new GtrsDataSet(49249, 77.5, -178.5, 3.0, 0.3333333333333333, 49368, 178.5, 3.0), new GtrsDataSet(49369, 78.5, -177.5, 5.0, 0.2, 49440, 177.5, 5.0), new GtrsDataSet(49441, 79.5, -177.5, 5.0, 0.2, 49512, 177.5, 5.0), new GtrsDataSet(49513, 80.5, -177.0, 6.0, 0.16666666666666666, 49572, 177.0, 6.0), new GtrsDataSet(49573, 81.5, -177.0, 6.0, 0.16666666666666666, 49632, 177.0, 6.0), new GtrsDataSet(49633, 82.5, -177.0, 6.0, 0.16666666666666666, 49692, 177.0, 6.0), new GtrsDataSet(49693, 83.5, -177.0, 6.0, 0.16666666666666666, 49752, 177.0, 6.0), new GtrsDataSet(49753, 84.5, -175.0, 10.0, 0.1, 49788, 175.0, 10.0), new GtrsDataSet(49789, 85.5, -175.0, 10.0, 0.1, 49824, 175.0, 10.0), new GtrsDataSet(49825, 86.5, -172.5, 15.0, 0.06666666666666667, 49848, 172.5, 15.0), new GtrsDataSet(49849, 87.5, -172.5, 15.0, 0.06666666666666667, 49872, 172.5, 15.0), new GtrsDataSet(49873, 88.5, -165.0, 30.0, 0.03333333333333333, 49884, 165.0, 30.0), new GtrsDataSet(49885, 89.5, -165.0, 30.0, 0.03333333333333333, 49896, 165.0, 30.0)};

    private GtrsDataSet(int minimum_cell_id, double row_lat, double starting_lon, double cell_width, double cell_width_inv, int maximum_cell_id, double irreg_cell_lon, double irreg_cell_width) {
        super(minimum_cell_id, row_lat, starting_lon, cell_width, cell_width_inv, maximum_cell_id, irreg_cell_lon, irreg_cell_width);
    }

    protected static GtrsDataSet getElem(int GtrsCellId) throws SrmException {
        int lower = 0;
        int upper = ROWS - 1;
        int current = 0;
        boolean found = false;
        if (GtrsCellId < 1 || GtrsCellId > TABLE_SIZE) {
            throw new SrmException(8, new String("Invalid GTRS Cell id (Valid range [1; 49896])"));
        }
        while (!found) {
            current = lower + (upper - lower) / 2;
            if (GtrsCellId >= GtrsDataSet.table[current]._minimum_cell_id && GtrsCellId <= GtrsDataSet.table[current]._maximum_cell_id) {
                found = true;
                continue;
            }
            if (GtrsCellId > GtrsDataSet.table[current]._maximum_cell_id) {
                lower = current + 1;
                continue;
            }
            upper = current - 1;
        }
        if (!found) {
            throw new SrmException(20, new String("Internal Error (find GTRS cell)"));
        }
        return table[current];
    }

    protected static int getNaturalCell(double[] coord) throws SrmException {
        int lat_index = (int)(Math.floor(coord[1] * 57.29577951308232) + 90.0);
        return GtrsDataSet.table[lat_index]._minimum_cell_id + (int)Math.floor((coord[0] * 57.29577951308232 + 180.0) * GtrsDataSet.table[lat_index]._cell_width_inv);
    }

    protected static double getCellOrigLon(int GtrsCellId, GtrsDataSet data) throws SrmException {
        if (GtrsCellId != data._maximum_cell_id) {
            return ((double)(GtrsCellId - data._minimum_cell_id) * data._cell_width + data._starting_lon) * (Math.PI / 180);
        }
        return data._irreg_cell_lon * (Math.PI / 180);
    }

    protected static double getCellOrigLat(GtrsDataSet data) throws SrmException {
        return data._row_lat * (Math.PI / 180);
    }

    protected static double getCellOrigLonMinExtent(int GtrsCellId, GtrsDataSet data) throws SrmException {
        if (GtrsCellId != data._maximum_cell_id) {
            return ((double)(GtrsCellId - data._minimum_cell_id) * data._cell_width + data._starting_lon - data._cell_width * 0.5) * (Math.PI / 180);
        }
        return ((double)(GtrsCellId - data._minimum_cell_id) * data._cell_width + data._starting_lon - data._irreg_cell_width * 0.5) * (Math.PI / 180);
    }

    protected static double getCellOrigLonMaxExtent(int GtrsCellId, GtrsDataSet data) throws SrmException {
        if (GtrsCellId != data._maximum_cell_id) {
            return ((double)(GtrsCellId - data._minimum_cell_id) * data._cell_width + data._starting_lon + data._cell_width * 0.5) * (Math.PI / 180);
        }
        return ((double)(GtrsCellId - data._minimum_cell_id) * data._cell_width + data._starting_lon + data._irreg_cell_width * 0.5) * (Math.PI / 180);
    }
}

