/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.OrmData;
import SRM.SRF_LCC_Params;
import SRM.SRF_LambertConformalConic;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class LccConv
extends Conversions {
    private ToCdetConst1 _toCdetConst1;
    private ToCdetConst2 _toCdetConst2;

    public LccConv() {
        super(SRM_SRFT_Code.SRFTCOD_LAMBERT_CONFORMAL_CONIC, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new LccConv();
    }

    public SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC) {
            src[0] = src[0] - ((SRF_LambertConformalConic)srcSrf).get_false_easting();
            src[1] = src[1] - ((SRF_LambertConformalConic)srcSrf).get_false_northing();
            this.toCdet(srcSrf, destSrf, src, dest);
            retValid = CoordCheck.forCelestiodetic(this.getOrmData(), dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected void toCdet(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coord, double[] dest_generic_coord) throws SrmException {
        double latitude2;
        double latitude1 = ((SRF_LambertConformalConic)srcSrf).get_latitude1();
        if (Math.abs(latitude1 - (latitude2 = ((SRF_LambertConformalConic)srcSrf).get_latitude2())) < 1.0E-6) {
            this.toCdet1(srcSrf, destSrf, source_generic_coord, dest_generic_coord);
        } else {
            this.toCdet2(srcSrf, destSrf, source_generic_coord, dest_generic_coord);
        }
    }

    protected void toCdet1(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double dest_lat;
        OrmData e_constants = this.getOrmData();
        if (this._toCdetConst1 == null) {
            this._toCdetConst1 = new ToCdetConst1(e_constants, ((SRF_LambertConformalConic)srcSrf).getSRFParameters());
        }
        double source_x = source_generic_coordinate[0];
        double source_y = source_generic_coordinate[1];
        double source_z = source_generic_coordinate[2];
        if (this._toCdetConst1._xl < 0.0) {
            source_x = -source_x;
            source_y = -source_y;
        }
        double drz = this._toCdetConst1._rho_origin - source_y;
        double thet = Math.atan2(source_x, drz);
        double dest_lon = thet / this._toCdetConst1._xl + this._toCdetConst1._xlonz;
        double r2 = source_x * source_x + drz * drz;
        double tanz2 = Math.pow(r2 / this._toCdetConst1._rz2, this._toCdetConst1._ex) / this._toCdetConst1._pz;
        if (e_constants.Eps != 0.0) {
            double t2 = tanz2 * tanz2;
            double den = 1.0 + t2;
            double cki = 2.0 * tanz2 / den;
            double ski = (1.0 - t2) / den;
            double sk2 = ski * ski;
            double z = 2.0 * Math.atan(tanz2);
            double xki = 1.5707963267948966 - z;
            dest_lat = xki + ski * cki * (this._toCdetConst1._b1 + sk2 * (this._toCdetConst1._b2 + sk2 * (this._toCdetConst1._b3 + sk2 * this._toCdetConst1._b4)));
        } else {
            dest_lat = 1.5707963267948966 - 2.0 * Math.atan(tanz2);
        }
        dest_generic_coordinate[0] = dest_lon = Const.fix_longitude(dest_lon);
        dest_generic_coordinate[1] = dest_lat;
        dest_generic_coordinate[2] = source_z;
    }

    protected void toCdet2(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double dest_lat;
        OrmData e_constants = this.getOrmData();
        if (this._toCdetConst2 == null) {
            this._toCdetConst2 = new ToCdetConst2(e_constants, ((SRF_LambertConformalConic)srcSrf).getSRFParameters());
        }
        double source_x = source_generic_coordinate[0];
        double source_y = source_generic_coordinate[1];
        double source_z = source_generic_coordinate[2];
        if (this._toCdetConst2._xl < 0.0) {
            source_x = -source_x;
            source_y = -source_y;
        }
        double drz = this._toCdetConst2._rz - source_y;
        double r2 = source_x * source_x + drz * drz;
        double tanz2 = Math.pow(r2 / this._toCdetConst2._rz2, this._toCdetConst2._ex) / this._toCdetConst2._p1;
        if (e_constants.Eps != 0.0) {
            double t2 = tanz2 * tanz2;
            double den = 1.0 + t2;
            double cki = 2.0 * tanz2 / den;
            double ski = (1.0 - t2) / den;
            double sk2 = ski * ski;
            double z = 2.0 * Math.atan(tanz2);
            double xki = 1.5707963267948966 - z;
            dest_lat = xki + ski * cki * (this._toCdetConst2._b1 + sk2 * (this._toCdetConst2._b2 + sk2 * (this._toCdetConst2._b3 + sk2 * this._toCdetConst2._b4)));
        } else {
            dest_lat = 1.5707963267948966 - 2.0 * Math.atan(tanz2);
        }
        double thet = Math.atan2(source_x, drz);
        double dest_lon = thet / this._toCdetConst2._xl + this._toCdetConst2._xlonz;
        dest_generic_coordinate[0] = dest_lon = Const.fix_longitude(dest_lon);
        dest_generic_coordinate[1] = dest_lat;
        dest_generic_coordinate[2] = source_z;
    }

    private class ToCdetConst2 {
        double _b1;
        double _b2;
        double _b3;
        double _b4;
        double _xlonz;
        double _rz;
        double _xl;
        double _ex;
        double _rz2;
        double _p1;

        public ToCdetConst2(OrmData e_constants, SRF_LCC_Params params) {
            double xl;
            double rn12;
            double phiz1 = params.latitude1;
            double phiz2 = params.latitude2;
            this._xlonz = params.origin_longitude;
            double latitude_origin = params.origin_latitude;
            double pa2 = e_constants.Eps2 / 2.0 + Math.pow(e_constants.Eps2, 2.0) * 5.0 / 24.0;
            double pa4 = Math.pow(e_constants.Eps2, 2.0) * 7.0 / 48.0 + Math.pow(e_constants.Eps2, 3.0) * 29.0 / 240.0;
            double pa6 = Math.pow(e_constants.Eps2, 3.0) * 7.0 / 120.0 + Math.pow(e_constants.Eps2, 4.0) * 81.0 / 1120.0;
            double pa8 = Math.pow(e_constants.Eps2, 4.0) * 4279.0 / 161280.0;
            this._b1 = (pa2 += Math.pow(e_constants.Eps2, 3.0) / 12.0 + Math.pow(e_constants.Eps2, 4.0) * 13.0 / 360.0) * 2.0 + (pa4 += Math.pow(e_constants.Eps2, 4.0) * 811.0 / 11520.0) * 4.0 + pa6 * 6.0 + pa8 * 8.0;
            this._b2 = pa4 * -8.0 - pa6 * 32.0 - pa8 * 80.0;
            this._b3 = pa6 * 32.0 + pa8 * 192.0;
            this._b4 = pa8 * -128.0;
            double sfx = Math.sin(latitude_origin);
            double s1 = Math.sin(phiz1);
            double s2 = Math.sin(phiz2);
            double s12 = s1 * s1;
            double c12 = 1.0 - s12;
            double s22 = s2 * s2;
            double c22 = 1.0 - s22;
            double pz = Math.tan(0.7853981633974483 + 0.5 * latitude_origin);
            double p1 = Math.tan(0.7853981633974483 + 0.5 * phiz1);
            double p2 = Math.tan(0.7853981633974483 + 0.5 * phiz2);
            if (e_constants.Eps != 0.0) {
                pz *= Math.pow((1.0 - e_constants.Eps * sfx) / (e_constants.Eps * sfx + 1.0), e_constants.EpsH);
                rn12 = e_constants.A2 / (1.0 - e_constants.Eps2 * s12);
                double rn22 = e_constants.A2 / (1.0 - e_constants.Eps2 * s22);
                double temp = (p2 *= Math.pow((1.0 - e_constants.Eps * s2) / (e_constants.Eps * s2 + 1.0), e_constants.EpsH)) / (p1 *= Math.pow((1.0 - e_constants.Eps * s1) / (e_constants.Eps * s1 + 1.0), e_constants.EpsH));
                xl = 0.5 * Math.log(rn12 * c12 / (c22 * rn22)) / Math.log(temp);
            } else {
                double temp = p2 / p1;
                rn12 = e_constants.A2;
                xl = 0.5 * Math.log(c12 / c22) / Math.log(temp);
            }
            double rz2 = rn12 * c12 / (xl * xl);
            double rz = Math.sqrt(rz2) * Math.pow(p1 / pz, xl);
            double ex = 1.0 / (xl + xl);
            this._rz = rz;
            this._xl = xl;
            this._ex = ex;
            this._rz2 = rz2;
            this._p1 = p1;
        }
    }

    private class ToCdetConst1 {
        double _b1;
        double _b2;
        double _b3;
        double _b4;
        double _xlonz;
        double _xl;
        double _pz;
        double _rz;
        double _rz2;
        double _ex;
        double _rho_origin;

        public ToCdetConst1(OrmData e_constants, SRF_LCC_Params params) {
            double rz;
            double phiz = params.latitude1;
            this._xlonz = params.origin_longitude;
            double latitude_origin = params.origin_latitude;
            double sin_org = Math.sin(latitude_origin);
            double porg = Math.tan(0.7853981633974483 + 0.5 * latitude_origin);
            double xl = Math.sin(phiz);
            double ex = 1.0 / (xl + xl);
            double xl2 = xl * xl;
            double pz = Math.tan(0.7853981633974483 + 0.5 * phiz);
            if (e_constants.Eps != 0.0) {
                double pa2 = e_constants.Eps2 / 2.0 + Math.pow(e_constants.Eps2, 2.0) * 5.0 / 24.0;
                double pa4 = Math.pow(e_constants.Eps2, 2.0) * 7.0 / 48.0 + Math.pow(e_constants.Eps2, 3.0) * 29.0 / 240.0;
                double pa6 = Math.pow(e_constants.Eps2, 3.0) * 7.0 / 120.0 + Math.pow(e_constants.Eps2, 4.0) * 81.0 / 1120.0;
                double pa8 = Math.pow(e_constants.Eps2, 4.0) * 4279.0 / 161280.0;
                this._b1 = (pa2 += Math.pow(e_constants.Eps2, 3.0) / 12.0 + Math.pow(e_constants.Eps2, 4.0) * 13.0 / 360.0) * 2.0 + (pa4 += Math.pow(e_constants.Eps2, 4.0) * 811.0 / 11520.0) * 4.0 + pa6 * 6.0 + pa8 * 8.0;
                this._b2 = pa4 * -8.0 - pa6 * 32.0 - pa8 * 80.0;
                this._b3 = pa6 * 32.0 + pa8 * 192.0;
                this._b4 = pa8 * -128.0;
                pz = Math.pow((1.0 - e_constants.Eps * xl) / (e_constants.Eps * xl + 1.0), e_constants.EpsH) * pz;
                rz = e_constants.A * Math.cos(phiz) / (xl * Math.sqrt(1.0 - e_constants.Eps2 * xl2));
                porg = Math.pow((1.0 - e_constants.Eps * sin_org) / (e_constants.Eps * sin_org + 1.0), e_constants.EpsH) * porg;
            } else {
                rz = e_constants.A * Math.cos(phiz) / xl;
            }
            double rz2 = rz * rz;
            this._pz = pz;
            this._rz = rz;
            this._rz2 = rz2;
            this._xl = xl;
            this._ex = ex;
            pz = Math.abs(porg) <= 1.0E-12 ? 0.0 : (pz /= porg);
            this._rho_origin = rz * Math.pow(pz, xl);
        }
    }
}

