/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.SRF_LCE_3D_Params;
import SRM.SRF_LococentricEuclidean3D;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class LceConv
extends Conversions {
    private ToCcenConst _toCcenConst;

    protected LceConv() {
        super(SRM_SRFT_Code.SRFTCOD_LOCOCENTRIC_EUCLIDEAN_3D, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new LceConv();
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC) {
            if (this._toCcenConst == null) {
                this._toCcenConst = new ToCcenConst(((SRF_LococentricEuclidean3D)srcSrf).getSRFParameters());
            }
            for (int i = 0; i < 3; ++i) {
                dest[i] = this._toCcenConst.lococentre[i] + src[0] * this._toCcenConst.primary_axis[i] + src[1] * this._toCcenConst.secondary_axis[i] + src[2] * this._toCcenConst.xprod_rs[i];
            }
            dest[3] = 0.0;
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    private class ToCcenConst {
        double[] lococentre = new double[3];
        double[] primary_axis = new double[3];
        double[] secondary_axis = new double[3];
        double[] xprod_rs = new double[3];

        public ToCcenConst(SRF_LCE_3D_Params params) {
            Const.vectCrossProd(params.primary_axis, params.secondary_axis, this.xprod_rs);
            for (int i = 0; i < 3; ++i) {
                this.lococentre[i] = params.lococentre[i];
                this.primary_axis[i] = params.primary_axis[i];
                this.secondary_axis[i] = params.secondary_axis[i];
            }
        }
    }
}

