/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class LctpConv
extends Conversions {
    protected LctpConv() {
        super(SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_CYLINDRICAL, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new LctpConv();
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN) {
            retValid = CoordCheck.forCylindrical(src);
            this.toLte(srcSrf, destSrf, src, dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected void toLte(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coord, double[] dest_generic_coord) throws SrmException {
        dest_generic_coord[0] = source_generic_coord[1] * Math.cos(source_generic_coord[0]);
        dest_generic_coord[1] = source_generic_coord[1] * Math.sin(source_generic_coord[0]);
        dest_generic_coord[2] = source_generic_coord[2];
    }
}

