/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.OrmData;
import SRM.SRF_LTSE_Params;
import SRM.SRF_LT_Params;
import SRM.SRF_LocalTangentSpaceAzimuthalSpherical;
import SRM.SRF_LocalTangentSpaceCylindrical;
import SRM.SRF_LocalTangentSpaceEuclidean;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFS_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

public class LteConv
extends Conversions {
    private ToCcenConst _toCcenConst;

    public LteConv() {
        super(SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_CYLINDRICAL, SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_AZIMUTHAL_SPHERICAL, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new LteConv();
    }

    public SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC) {
            if (srcSrf.getSRFSetCode() == SRM_SRFS_Code.SRFSCOD_GTRS_GLOBAL_COORDINATE_SYSTEM) {
                retValid = CoordCheck.forGTRS(src);
            }
            if (srcSrf instanceof SRF_LocalTangentSpaceEuclidean) {
                src[0] = src[0] - ((SRF_LocalTangentSpaceEuclidean)srcSrf).get_x_false_origin();
                src[1] = src[1] - ((SRF_LocalTangentSpaceEuclidean)srcSrf).get_y_false_origin();
            }
            this.toCcen(srcSrf, destSrf, src, dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_CYLINDRICAL) {
            this.toLtsc(srcSrf, destSrf, src, dest);
            retValid = CoordCheck.forCylindrical(dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_AZIMUTHAL_SPHERICAL) {
            this.toAzSphere(srcSrf, destSrf, src, dest);
            retValid = CoordCheck.forAzSpherical(dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected void toCcen(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double[] temp = new double[4];
        double[] temp1 = new double[4];
        temp[0] = source_generic_coordinate[0];
        temp[1] = source_generic_coordinate[1];
        temp[2] = source_generic_coordinate[2];
        temp[3] = 1.0;
        OrmData e_constants = this.getOrmData();
        if (this._toCcenConst == null) {
            if (srcSrf instanceof SRF_LocalTangentSpaceAzimuthalSpherical) {
                SRF_LT_Params tmpLTParam = ((SRF_LocalTangentSpaceAzimuthalSpherical)srcSrf).getSRFParameters();
                SRF_LTSE_Params tmpLTEParam = new SRF_LTSE_Params();
                tmpLTEParam.geodetic_longitude = tmpLTParam.geodetic_longitude;
                tmpLTEParam.geodetic_latitude = tmpLTParam.geodetic_latitude;
                tmpLTEParam.azimuth = tmpLTParam.azimuth;
                tmpLTEParam.x_false_origin = 0.0;
                tmpLTEParam.y_false_origin = 0.0;
                tmpLTEParam.height_offset = tmpLTParam.height_offset;
                this._toCcenConst = new ToCcenConst(e_constants, tmpLTEParam);
            } else if (srcSrf instanceof SRF_LocalTangentSpaceCylindrical) {
                SRF_LT_Params tmpLTParam = ((SRF_LocalTangentSpaceCylindrical)srcSrf).getSRFParameters();
                SRF_LTSE_Params tmpLTEParam = new SRF_LTSE_Params();
                tmpLTEParam.geodetic_longitude = tmpLTParam.geodetic_longitude;
                tmpLTEParam.geodetic_latitude = tmpLTParam.geodetic_latitude;
                tmpLTEParam.azimuth = tmpLTParam.azimuth;
                tmpLTEParam.x_false_origin = 0.0;
                tmpLTEParam.y_false_origin = 0.0;
                tmpLTEParam.height_offset = tmpLTParam.height_offset;
                this._toCcenConst = new ToCcenConst(e_constants, tmpLTEParam);
            } else {
                this._toCcenConst = new ToCcenConst(e_constants, ((SRF_LocalTangentSpaceEuclidean)srcSrf).getSRFParameters());
            }
        }
        Const.multMatrixSubsetVector(this._toCcenConst.T, temp, temp1, 4);
        dest_generic_coordinate[0] = temp1[0];
        dest_generic_coordinate[1] = temp1[1];
        dest_generic_coordinate[2] = temp1[2];
    }

    protected void toLtsc(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coord, double[] dest_generic_coord) throws SrmException {
        double theta;
        double x2 = Const.square(source_generic_coord[0]);
        if (x2 > 1.0E-12) {
            double theta_prime = Math.atan(source_generic_coord[1] / source_generic_coord[0]);
            theta = source_generic_coord[0] >= 0.0 ? (source_generic_coord[1] >= 0.0 ? theta_prime : Math.PI * 2 + theta_prime) : (source_generic_coord[1] >= 0.0 ? Math.PI + theta_prime : Math.PI + theta_prime);
        } else {
            theta = source_generic_coord[1] >= 1.0E-6 ? 0.0 : Math.PI;
        }
        double rho = Math.sqrt(x2 + Const.square(source_generic_coord[1]));
        double zeta = source_generic_coord[2];
        dest_generic_coord[0] = theta;
        dest_generic_coord[1] = rho;
        dest_generic_coord[2] = zeta;
    }

    protected void toAzSphere(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coord, double[] dest_generic_coord) throws SrmException {
        double x2 = Const.square(source_generic_coord[0]);
        dest_generic_coord[0] = x2 > 1.0E-12 ? (source_generic_coord[0] >= 0.0 ? (source_generic_coord[1] >= 0.0 ? Math.atan(source_generic_coord[1] / source_generic_coord[0]) : Math.PI * 2 + Math.atan(source_generic_coord[1] / source_generic_coord[0])) : Math.PI + Math.atan(source_generic_coord[1] / source_generic_coord[0])) : (source_generic_coord[1] > 1.0E-6 ? 0.0 : Math.PI);
        dest_generic_coord[2] = Math.sqrt(x2 + Const.square(source_generic_coord[1]) + Const.square(source_generic_coord[2]));
        dest_generic_coord[1] = Math.asin(source_generic_coord[2] / dest_generic_coord[2]);
    }

    public class LtsasLtseConst {
        double ltsas_azimuth;
        double ltsas_height_offset;
        double ltse_azimuth;
        double ltse_height_offset;

        public LtsasLtseConst(SRF_LT_Params ltsas_params, SRF_LTSE_Params ltse_params) {
            this.ltsas_azimuth = ltsas_params.azimuth;
            this.ltsas_height_offset = ltsas_params.height_offset;
            this.ltse_azimuth = ltse_params.azimuth;
            this.ltse_height_offset = ltse_params.height_offset;
        }
    }

    public class ToCcenConst {
        double[][] T = new double[4][4];
        double[][] T_inv = new double[4][4];

        public ToCcenConst(OrmData e_constants, SRF_LTSE_Params params) {
            Const.calc_T(e_constants, params, this.T, this.T_inv);
        }
    }
}

