/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.OrmData;
import SRM.SRF_M_Params;
import SRM.SRF_Mercator;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class MercConv
extends Conversions {
    private ToCdetConst _toCdetConst;

    public MercConv() {
        super(SRM_SRFT_Code.SRFTCOD_MERCATOR, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new MercConv();
    }

    public SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC) {
            src[0] = src[0] - ((SRF_Mercator)srcSrf).get_false_easting();
            src[1] = src[1] - ((SRF_Mercator)srcSrf).get_false_northing();
            this.toCdet(srcSrf, destSrf, src, dest);
            retValid = CoordCheck.forCelestiodetic(this.getOrmData(), dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected void toCdet(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double dest_lat;
        OrmData e_constants = this.getOrmData();
        if (this._toCdetConst == null) {
            this._toCdetConst = new ToCdetConst(e_constants, ((SRF_Mercator)srcSrf).getSRFParameters());
        }
        double source_x = source_generic_coordinate[0] * this._toCdetConst.scale_inv;
        double source_y = source_generic_coordinate[1] * this._toCdetConst.scale_inv;
        double source_z = source_generic_coordinate[2];
        double dest_lon = source_x * e_constants.A_inv + this._toCdetConst.longitude_origin;
        double tanz2 = Math.exp(-source_y * e_constants.A_inv);
        double z = 2.0 * Math.atan(tanz2);
        if (e_constants.Eps != 0.0) {
            double t2 = tanz2 * tanz2;
            double den_inv = 1.0 / (1.0 + t2);
            double cki = 2.0 * tanz2 * den_inv;
            double ski = (1.0 - t2) * den_inv;
            double sk2 = ski * ski;
            double xki = 1.5707963267948966 - z;
            dest_lat = xki + ski * cki * (this._toCdetConst.b1 + sk2 * (this._toCdetConst.b2 + sk2 * (this._toCdetConst.b3 + sk2 * this._toCdetConst.b4)));
        } else {
            dest_lat = 1.5707963267948966 - z;
        }
        dest_generic_coordinate[0] = dest_lon = Const.fix_longitude(dest_lon);
        dest_generic_coordinate[1] = dest_lat;
        dest_generic_coordinate[2] = source_z;
    }

    private class ToCdetConst {
        double b1;
        double b2;
        double b3;
        double b4;
        double longitude_origin;
        double geodetic_latitude;
        double scale_inv;

        public ToCdetConst(OrmData e_constants, SRF_M_Params params) {
            this.longitude_origin = params.origin_longitude;
            this.scale_inv = 1.0 / params.central_scale;
            if (e_constants.Eps != 0.0) {
                double pa2 = e_constants.Eps2 / 2.0 + Math.pow(e_constants.Eps2, 2.0) * 5.0 / 24.0;
                double pa4 = Math.pow(e_constants.Eps2, 2.0) * 7.0 / 48.0 + Math.pow(e_constants.Eps2, 3.0) * 29.0 / 240.0;
                double pa6 = Math.pow(e_constants.Eps2, 3.0) * 7.0 / 120.0 + Math.pow(e_constants.Eps2, 4.0) * 81.0 / 1120.0;
                double pa8 = Math.pow(e_constants.Eps2, 4.0) * 4279.0 / 161280.0;
                this.b1 = (pa2 += Math.pow(e_constants.Eps2, 3.0) / 12.0 + Math.pow(e_constants.Eps2, 4.0) * 13.0 / 360.0) * 2.0 + (pa4 += Math.pow(e_constants.Eps2, 4.0) * 811.0 / 11520.0) * 4.0 + pa6 * 6.0 + pa8 * 8.0;
                this.b2 = pa4 * -8.0 - pa6 * 32.0 - pa8 * 80.0;
                this.b3 = pa6 * 32.0 + pa8 * 192.0;
                this.b4 = pa8 * -128.0;
            }
        }
    }
}

