/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.OrmData;
import SRM.SRF_OM_Params;
import SRM.SRF_ObliqueMercatorSpherical;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class OmConv
extends Conversions {
    private ToCdetConst _toCdetConst = null;

    protected OmConv() {
        super(SRM_SRFT_Code.SRFTCOD_OBLIQUE_MERCATOR_SPHERICAL, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new OmConv();
    }

    public SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC) {
            src[0] = src[0] - ((SRF_ObliqueMercatorSpherical)srcSrf).get_false_easting();
            src[1] = src[1] - ((SRF_ObliqueMercatorSpherical)srcSrf).get_false_northing();
            this.toCdet(srcSrf, destSrf, src, dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected void toCdet(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double dest_lat = 0.0;
        double dest_lon = 0.0;
        double source_x = 0.0;
        double source_y = 0.0;
        double source_z = 0.0;
        double cos_u = 0.0;
        double cosh_v = 0.0;
        double q1 = 0.0;
        double q2 = 0.0;
        double sin_u = 0.0;
        double sinh_v = 0.0;
        double u_star = 0.0;
        double v_star = 0.0;
        double xlon1 = 0.0;
        OrmData e_constants = this.getOrmData();
        if (this._toCdetConst == null) {
            this._toCdetConst = new ToCdetConst(e_constants, ((SRF_ObliqueMercatorSpherical)srcSrf).getSRFParameters());
        }
        source_x = source_generic_coordinate[0];
        source_y = source_generic_coordinate[1];
        source_z = source_generic_coordinate[2];
        u_star = source_x * this._toCdetConst.inv_ak0;
        v_star = source_y * this._toCdetConst.inv_ak0;
        double exp_v = 0.0;
        double inv_expv = 0.0;
        exp_v = Math.exp(v_star);
        inv_expv = 1.0 / exp_v;
        sinh_v = 0.5 * (exp_v - inv_expv);
        cosh_v = 0.5 * (exp_v + inv_expv);
        sin_u = Math.sin(u_star);
        cos_u = Math.cos(u_star);
        q1 = this._toCdetConst.ca0 * sin_u - this._toCdetConst.sa0 * sinh_v;
        q2 = this._toCdetConst.sa0 * sin_u + this._toCdetConst.ca0 * sinh_v;
        xlon1 = Math.atan2(q1, cos_u);
        dest_lon = Const.getLambdaStar(xlon1, -this._toCdetConst.lambda_0);
        dest_lat = Math.asin(q2 / cosh_v);
        dest_generic_coordinate[0] = dest_lon;
        dest_generic_coordinate[1] = dest_lat;
        dest_generic_coordinate[2] = source_z;
    }

    private class ToCdetConst {
        double lambda_0;
        double sl0;
        double cl0;
        double inv_ak0;
        double sa0;
        double ca0;

        public ToCdetConst(OrmData e_constants, SRF_OM_Params omParams) {
            double sin_lat1 = 0.0;
            double cos_lat1 = 0.0;
            double sin_lat2 = 0.0;
            double cos_lat2 = 0.0;
            double sin_lon1 = 0.0;
            double cos_lon1 = 0.0;
            double sin_lon2 = 0.0;
            double cos_lon2 = 0.0;
            double p0 = 0.0;
            double q0 = 0.0;
            double alpha_0 = 0.0;
            double sin_lambda_1_minus_lambda_0 = 0.0;
            double sin_lambda_2_minus_lambda_0 = 0.0;
            sin_lat1 = Math.sin(omParams.latitude1);
            cos_lat1 = Math.cos(omParams.latitude1);
            sin_lat2 = Math.sin(omParams.latitude2);
            cos_lat2 = Math.cos(omParams.latitude2);
            sin_lon1 = Math.sin(omParams.longitude1);
            cos_lon1 = Math.cos(omParams.longitude1);
            sin_lon2 = Math.sin(omParams.longitude2);
            cos_lon2 = Math.cos(omParams.longitude2);
            p0 = cos_lat1 * sin_lat2 * sin_lon1 - sin_lat1 * cos_lat2 * sin_lon2;
            q0 = cos_lat1 * sin_lat2 * cos_lon1 - sin_lat1 * cos_lat2 * cos_lon2;
            this.lambda_0 = Math.atan(p0 / q0);
            this.cl0 = Math.cos(this.lambda_0);
            this.sl0 = Math.sin(this.lambda_0);
            sin_lambda_1_minus_lambda_0 = Math.sin(omParams.longitude1 - this.lambda_0);
            sin_lambda_2_minus_lambda_0 = Math.sin(omParams.longitude2 - this.lambda_0);
            alpha_0 = Math.abs(sin_lambda_1_minus_lambda_0) >= Math.abs(sin_lambda_2_minus_lambda_0) ? Math.atan(sin_lat1 / (cos_lat1 * sin_lambda_1_minus_lambda_0)) : Math.atan(sin_lat2 / (cos_lat2 * sin_lambda_2_minus_lambda_0));
            this.sa0 = Math.sin(alpha_0);
            this.ca0 = Math.cos(alpha_0);
            this.inv_ak0 = 1.0 / (e_constants.A * omParams.central_scale);
        }
    }
}

