/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.OriComp;
import SRM.Orientation;
import SRM.SRM_Axis_Angle_Params;
import SRM.SRM_Matrix_3x3;
import SRM.SRM_Ori_Rep;
import SRM.SrmException;

public class OrientationAxisAngle
extends Orientation {
    private SRM_Axis_Angle_Params _axis_angle = new SRM_Axis_Angle_Params();

    public OrientationAxisAngle() {
    }

    public OrientationAxisAngle(SRM_Axis_Angle_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, "OrientationAxisAngle(params): invalid (axis, angle) parameters");
        }
        System.arraycopy(params.axis, 0, this._axis_angle.axis, 0, 3);
        this._axis_angle.angle = params.angle;
    }

    public OrientationAxisAngle(double[] axis, double angle_in_rad) throws SrmException {
        SRM_Axis_Angle_Params aa = new SRM_Axis_Angle_Params(axis, angle_in_rad);
        if (!aa.valid()) {
            throw new SrmException(8, new String("OrientationAxisAngle(axis, angle): invalid (axis, angle) parameters"));
        }
        this._axis_angle = aa;
    }

    public SRM_Axis_Angle_Params getAxisAngle() {
        return new SRM_Axis_Angle_Params(this._axis_angle);
    }

    public void setAxisAngle(SRM_Axis_Angle_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, new String("OrientationAxisAngle.setAxisAngle: invalid (axis, angle) parameters"));
        }
        System.arraycopy(params.axis, 0, this._axis_angle.axis, 0, 3);
        this._axis_angle.angle = params.angle;
        this._set_internal_data_is_current(false);
    }

    public String toString() {
        return this._axis_angle.toString();
    }

    public SRM_Ori_Rep getOriRep() {
        return SRM_Ori_Rep.ORI_REP_AXIS_ANGLE;
    }

    public static OrientationAxisAngle compose(Orientation left, Orientation right) throws SrmException {
        SRM_Matrix_3x3 ret_mat = OriComp.matrixMultiply(left.getMatrix3x3(), right.getMatrix3x3());
        return new OrientationAxisAngle(OriComp.matrix_to_axis_angle(ret_mat));
    }

    protected void _updateIntData() {
        if (!this._get_internal_data_is_current()) {
            this._set_matrix_base(OriComp.axis_angle_to_matrix(this._axis_angle));
            this._set_internal_data_is_current(true);
        }
    }

    protected void _updateRepData() {
        this._axis_angle = OriComp.matrix_to_axis_angle(this._get_matrix_base_unch());
        this._set_internal_data_is_current(true);
    }
}

