/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.OriComp;
import SRM.Orientation;
import SRM.SRM_Euler_Angles_ZXZ_Params;
import SRM.SRM_Matrix_3x3;
import SRM.SRM_Ori_Rep;
import SRM.SrmException;

public class OrientationEulerAnglesZXZ
extends Orientation {
    private SRM_Euler_Angles_ZXZ_Params _euler_angles = new SRM_Euler_Angles_ZXZ_Params();

    public OrientationEulerAnglesZXZ() {
    }

    public OrientationEulerAnglesZXZ(SRM_Euler_Angles_ZXZ_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, "OrientationEulerAnglesZXZ(spin, nutation, precession): invalid parameters");
        }
        this._euler_angles.spin = params.spin;
        this._euler_angles.nutation = params.nutation;
        this._euler_angles.precession = params.precession;
    }

    public OrientationEulerAnglesZXZ(double spin, double nutation, double precession) throws SrmException {
        SRM_Euler_Angles_ZXZ_Params ea = new SRM_Euler_Angles_ZXZ_Params(spin, nutation, precession);
        if (!ea.valid()) {
            throw new SrmException(8, "OrientationEulerAnglesZXZ(spin, nutation, precession): invalid parameters");
        }
        this._euler_angles = ea;
    }

    public SRM_Euler_Angles_ZXZ_Params getEulerAnglesZXZ() {
        return new SRM_Euler_Angles_ZXZ_Params(this._euler_angles);
    }

    public void setEulerAnglesZXZ(SRM_Euler_Angles_ZXZ_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, "OrientationEulerAnglesZXZ.setEulerAnglesZXZ: invalid parameters");
        }
        this._euler_angles.spin = params.spin;
        this._euler_angles.nutation = params.nutation;
        this._euler_angles.precession = params.precession;
        this._set_internal_data_is_current(false);
    }

    public String toString() {
        return this._euler_angles.toString();
    }

    public SRM_Ori_Rep getOriRep() {
        return SRM_Ori_Rep.ORI_REP_EULER_ANGLES_ZXZ;
    }

    public static OrientationEulerAnglesZXZ compose(Orientation left, Orientation right) throws SrmException {
        SRM_Matrix_3x3 ret_mat = OriComp.matrixMultiply(left.getMatrix3x3(), right.getMatrix3x3());
        return new OrientationEulerAnglesZXZ(OriComp.matrix_to_euler_zxz(ret_mat));
    }

    protected void _updateIntData() {
        if (!this._get_internal_data_is_current()) {
            this._set_matrix_base(OriComp.euler_zxz_to_matrix(this._euler_angles));
            this._set_internal_data_is_current(true);
        }
    }

    protected void _updateRepData() {
        this._euler_angles = OriComp.matrix_to_euler_zxz(this._get_matrix_base_unch());
        this._set_internal_data_is_current(true);
    }
}

