/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.OriComp;
import SRM.Orientation;
import SRM.SRM_Matrix_3x3;
import SRM.SRM_Ori_Rep;
import SRM.SrmException;

public class OrientationMatrix
extends Orientation {
    private SRM_Matrix_3x3 _matrix = new SRM_Matrix_3x3();

    public OrientationMatrix() {
    }

    public OrientationMatrix(SRM_Matrix_3x3 params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, new String("OrientationMatrix(params): invalid matrix 3x3 parameters"));
        }
        System.arraycopy(params.m[0], 0, this._matrix.m[0], 0, 3);
        System.arraycopy(params.m[1], 0, this._matrix.m[1], 0, 3);
        System.arraycopy(params.m[2], 0, this._matrix.m[2], 0, 3);
    }

    public OrientationMatrix(double a11, double a12, double a13, double a21, double a22, double a23, double a31, double a32, double a33) throws SrmException {
        SRM_Matrix_3x3 mat = new SRM_Matrix_3x3(a11, a12, a13, a21, a22, a23, a31, a32, a33);
        if (!mat.valid()) {
            throw new SrmException(8, new String("OrientationMatrix(a11, ..., a33): invalid matrix 3x3 parameters"));
        }
        this._matrix = mat;
    }

    public SRM_Matrix_3x3 getMatrix3x3() {
        return new SRM_Matrix_3x3(this._matrix);
    }

    public void setMatrix3x3(SRM_Matrix_3x3 params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, new String("OrientationMatrix::setMatrix3x3: invalid matrix 3x3 parameters"));
        }
        System.arraycopy(params.m[0], 0, this._matrix.m[0], 0, 3);
        System.arraycopy(params.m[1], 0, this._matrix.m[1], 0, 3);
        System.arraycopy(params.m[2], 0, this._matrix.m[2], 0, 3);
        this._set_internal_data_is_current(false);
    }

    OrientationMatrix(Orientation other) {
        this._set_matrix_base(this._matrix);
        this._set_internal_data_is_current(true);
    }

    public String toString() {
        return this._matrix.toString();
    }

    public SRM_Ori_Rep getOriRep() {
        return SRM_Ori_Rep.ORI_REP_MATRIX_3X3;
    }

    public static OrientationMatrix compose(Orientation left, Orientation right) throws SrmException {
        SRM_Matrix_3x3 ret_mat = OriComp.matrixMultiply(left.getMatrix3x3(), right.getMatrix3x3());
        return new OrientationMatrix(ret_mat);
    }

    protected void _updateIntData() {
        if (!this._get_internal_data_is_current()) {
            this._set_matrix_base(this._matrix);
            this._set_internal_data_is_current(true);
        }
    }

    protected void _updateRepData() {
        this._matrix = this._get_matrix_base_unch();
        this._set_internal_data_is_current(true);
    }
}

