/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.OrmData;
import SRM.SRF_PS_Params;
import SRM.SRF_PolarStereographic;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_Polar_Aspect;
import SRM.SRM_SRFS_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class PostConv
extends Conversions {
    private ToCdetConst _toCdetConst = null;

    protected PostConv() {
        super(SRM_SRFT_Code.SRFTCOD_POLAR_STEREOGRAPHIC, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new PostConv();
    }

    public SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC) {
            src[0] = src[0] - ((SRF_PolarStereographic)srcSrf).get_false_easting();
            src[1] = src[1] - ((SRF_PolarStereographic)srcSrf).get_false_northing();
            retValid = CoordCheck.forNaN_3D(src);
            this.toCdet(srcSrf, destSrf, src, dest);
            retValid = destSrf.getSRFSetCode() == SRM_SRFS_Code.SRFSCOD_UNIVERSAL_POLAR_STEREOGRAPHIC ? CoordCheck.forUPS_cd(((SRF_PolarStereographic)srcSrf).getSRFParameters(), dest) : CoordCheck.forPolarStereographic_cd(((SRF_PolarStereographic)srcSrf).getSRFParameters(), dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected void toCdet(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double longitude;
        double latitude;
        OrmData e_constants = this.getOrmData();
        if (this._toCdetConst == null) {
            this._toCdetConst = new ToCdetConst(e_constants, ((SRF_PolarStereographic)srcSrf).getSRFParameters());
        }
        double easting = source_generic_coordinate[0];
        double northing = source_generic_coordinate[1];
        double longitude_origin = this._toCdetConst.longitude_origin;
        double rho = Math.sqrt(Const.square(easting) + Const.square(northing));
        double tanz2 = Double.NaN;
        double ski = Double.NaN;
        double cki = Double.NaN;
        if (rho < 1.0E-6) {
            latitude = 1.5707963267948966;
            longitude = longitude_origin;
        } else {
            northing *= this._toCdetConst.polar_aspect_constant;
            easting *= this._toCdetConst.polar_aspect_constant;
            longitude_origin *= this._toCdetConst.polar_aspect_constant;
            if (e_constants.Eps != 0.0) {
                tanz2 = rho * this._toCdetConst.scale_inverse * this._toCdetConst.FK_inv;
                double T2 = tanz2 * tanz2;
                double DEN_INV = 1.0 / (1.0 + T2);
                cki = 2.0 * tanz2 * DEN_INV;
                ski = (1.0 - T2) * DEN_INV;
                double sk2 = ski * ski;
                double xki = 1.5707963267948966 - 2.0 * Math.atan(tanz2);
                latitude = xki + ski * cki * Const.chi_approx(this._toCdetConst.b, sk2);
                if (latitude > 1.5707963267948966) {
                    latitude = 1.5707963267948966;
                } else if (latitude < -1.5707963267948966) {
                    latitude = -1.5707963267948966;
                }
            } else {
                tanz2 = rho * (0.5 * e_constants.A_inv * this._toCdetConst.scale_inverse);
                latitude = 1.5707963267948966 - 2.0 * Math.atan(tanz2);
            }
            longitude = longitude_origin + Math.atan2(easting, -northing);
            if (longitude > Math.PI) {
                longitude -= Math.PI * 2;
            } else if (longitude < -Math.PI) {
                longitude += Math.PI * 2;
            }
        }
        dest_generic_coordinate[0] = longitude *= this._toCdetConst.polar_aspect_constant;
        dest_generic_coordinate[1] = latitude *= this._toCdetConst.polar_aspect_constant;
        dest_generic_coordinate[2] = source_generic_coordinate[2];
    }

    private class ToCdetConst {
        double[] b = new double[4];
        double sin_critical_lat;
        double[] cr1 = new double[5];
        double[] cr2 = new double[5];
        double P0;
        double P1;
        double Tc;
        double longitude_origin;
        double scale_inverse;
        double xmc_inv;
        double polar_aspect_constant;
        double FK_inv;

        public ToCdetConst(OrmData e_constants, SRF_PS_Params params) throws SrmException {
            Const.init_chi_series(e_constants, this.b);
            if (e_constants.Eps != 0.0) {
                Const.init_power_p_series(e_constants, this.cr1, this.cr2);
            } else {
                for (int i = 0; i < 5; ++i) {
                    this.cr1[i] = Double.NaN;
                    this.cr2[i] = Double.NaN;
                }
            }
            this.P0 = Const.power_p(e_constants, 1.0);
            this.longitude_origin = params.origin_longitude;
            this.scale_inverse = 1.0 / params.central_scale;
            this.polar_aspect_constant = params.polar_aspect == SRM_Polar_Aspect.PLRASP_NORTH ? 1.0 : -1.0;
            this.FK_inv = 1.0 / (2.0 * this.P0 * e_constants.A2 * e_constants.B_inv);
        }
    }
}

