/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_3D;
import SRM.Coord3D;
import SRM.Coord3D_LococentricEuclidean3D;
import SRM.SRF_LCE_3D_Params;
import SRM.SRM_CS_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrfCheck;
import SRM.SrmException;

public class SRF_LococentricEuclidean3D
extends BaseSRF_3D {
    private SRF_LCE_3D_Params _params = new SRF_LCE_3D_Params();

    public SRF_LococentricEuclidean3D(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_LCE_3D_Params params) throws SrmException {
        SrfCheck.forLococentricEuclidean3D(orm, rt, params.lococentre, params.primary_axis, params.secondary_axis);
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_LOCOCENTRIC_EUCLIDEAN_3D;
        this._myCsCode = SRM_CS_Code.CSCOD_LOCOCENT_EUCLIDEAN_3D;
        this._orm = orm;
        this._rt = rt;
        System.arraycopy(params.lococentre, 0, this._params.lococentre, 0, 3);
        System.arraycopy(params.primary_axis, 0, this._params.primary_axis, 0, 3);
        System.arraycopy(params.secondary_axis, 0, this._params.secondary_axis, 0, 3);
    }

    public SRF_LococentricEuclidean3D(SRM_ORM_Code orm, SRM_RT_Code rt, double[] lococentre, double[] primary_axis, double[] secondary_axis) throws SrmException {
        SrfCheck.forLococentricEuclidean3D(orm, rt, lococentre, primary_axis, secondary_axis);
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_LOCOCENTRIC_EUCLIDEAN_3D;
        this._myCsCode = SRM_CS_Code.CSCOD_LOCOCENT_EUCLIDEAN_3D;
        this._orm = orm;
        this._rt = rt;
        System.arraycopy(lococentre, 0, this._params.lococentre, 0, 3);
        System.arraycopy(primary_axis, 0, this._params.primary_axis, 0, 3);
        System.arraycopy(secondary_axis, 0, this._params.secondary_axis, 0, 3);
    }

    public Coord3D createCoordinate3D() {
        return new Coord3D_LococentricEuclidean3D(this, Double.NaN, Double.NaN, Double.NaN);
    }

    public Coord3D createCoordinate3D(double coord_comp1, double coord_comp2, double coord_comp3) {
        return new Coord3D_LococentricEuclidean3D(this, coord_comp1, coord_comp2, coord_comp3);
    }

    public SRF_LCE_3D_Params getSRFParameters() {
        SRF_LCE_3D_Params retParams = new SRF_LCE_3D_Params();
        retParams.lococentre = this._params.lococentre;
        retParams.primary_axis = this._params.primary_axis;
        retParams.secondary_axis = this._params.secondary_axis;
        return retParams;
    }

    public double[] get_lococentre() {
        return this._params.lococentre;
    }

    public double[] get_primary_axis() {
        return this._params.primary_axis;
    }

    public double[] get_secondary_axis() {
        return this._params.secondary_axis;
    }

    public boolean isEqual(BaseSRF srf) {
        return srf != null && srf instanceof SRF_LococentricEuclidean3D && this._orm == srf.getOrm() && this._rt == srf.getRt() && this._params.isEqual(((SRF_LococentricEuclidean3D)srf).getSRFParameters());
    }

    public String toString() {
        String retString = new String();
        retString = retString + super.toString() + "\n";
        retString = retString + this._params;
        return retString;
    }
}

