/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_MapProjection;
import SRM.Const;
import SRM.Coord3D;
import SRM.Coord3D_Mercator;
import SRM.CoordSurf;
import SRM.CoordSurf_Mercator;
import SRM.OrmData;
import SRM.SRF_M_Params;
import SRM.SRM_CS_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrfCheck;
import SRM.SrmException;

public class SRF_Mercator
extends BaseSRF_MapProjection {
    private SRF_M_Params _params = new SRF_M_Params();

    public SRF_Mercator(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_M_Params params) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_MERCATOR;
        this._myCsCode = SRM_CS_Code.CSCOD_MERCATOR;
        this._orm = orm;
        this._rt = rt;
        this._params.origin_longitude = params.origin_longitude;
        this._params.central_scale = params.central_scale;
        this._params.false_easting = params.false_easting;
        this._params.false_northing = params.false_northing;
        SrfCheck.forMercator(this._orm, this._rt, this._params);
    }

    public SRF_Mercator(SRM_ORM_Code orm, SRM_RT_Code rt, double origin_longitude, double central_scale, double false_easting, double false_northing) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_MERCATOR;
        this._myCsCode = SRM_CS_Code.CSCOD_MERCATOR;
        this._orm = orm;
        this._rt = rt;
        this._params.origin_longitude = origin_longitude;
        this._params.central_scale = central_scale;
        this._params.false_easting = false_easting;
        this._params.false_northing = false_northing;
        SrfCheck.forMercator(this._orm, this._rt, this._params);
    }

    public Coord3D createCoordinate3D() {
        return new Coord3D_Mercator(this, Double.NaN, Double.NaN, Double.NaN);
    }

    public Coord3D createCoordinate3D(double coord_comp1, double coord_comp2, double coord_comp3) {
        return new Coord3D_Mercator(this, coord_comp1, coord_comp2, coord_comp3);
    }

    public CoordSurf createSurfaceCoordinate() {
        return new CoordSurf_Mercator(this, Double.NaN, Double.NaN);
    }

    public CoordSurf createSurfaceCoordinate(double coord_comp1, double coord_comp2) {
        return new CoordSurf_Mercator(this, coord_comp1, coord_comp2);
    }

    public SRF_M_Params getSRFParameters() {
        SRF_M_Params retParams = new SRF_M_Params();
        retParams.origin_longitude = this._params.origin_longitude;
        retParams.central_scale = this._params.central_scale;
        retParams.false_easting = this._params.false_easting;
        retParams.false_northing = this._params.false_northing;
        return retParams;
    }

    public double get_origin_longitude() {
        return this._params.origin_longitude;
    }

    public double get_central_scale() {
        return this._params.central_scale;
    }

    public double get_false_easting() {
        return this._params.false_easting;
    }

    public double get_false_northing() {
        return this._params.false_northing;
    }

    public CoordSurf getAssociatedSurfaceCoordinate(Coord3D coord) throws SrmException {
        if (coord.getSRF() != this) {
            throw new SrmException(5, new String("getAssociatedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new CoordSurf_Mercator(this, coord.getValues()[0], coord.getValues()[1]);
    }

    public Coord3D getPromotedSurfaceCoordinate(CoordSurf surf_coord) throws SrmException {
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, new String("getPromotedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new Coord3D_Mercator(this, surf_coord.getValues()[0], surf_coord.getValues()[1], 0.0);
    }

    public boolean isEqual(BaseSRF srf) {
        return srf != null && srf instanceof SRF_Mercator && this._orm == srf.getOrm() && this._rt == srf.getRt() && this._params.isEqual(((SRF_Mercator)srf).getSRFParameters());
    }

    public String toString() {
        String retString = new String();
        retString = retString + super.toString() + "\n";
        retString = retString + this._params;
        return retString;
    }

    protected double comCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        return 0.0;
    }

    protected double pointScaleCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        double slat = Math.sin(cd_coord[1]);
        double Rn = 0.0;
        Rn = Const.computeRnFast(slat * slat, e_constants);
        return this.get_central_scale() * e_constants.A / (Rn * Math.cos(cd_coord[1]));
    }
}

