/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_MapProjection;
import SRM.Coord3D;
import SRM.Coord3D_ObliqueMercatorSpherical;
import SRM.CoordSurf;
import SRM.CoordSurf_ObliqueMercatorSpherical;
import SRM.OrmData;
import SRM.SRF_OM_Params;
import SRM.SRM_CS_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrfCheck;
import SRM.SrmException;

public class SRF_ObliqueMercatorSpherical
extends BaseSRF_MapProjection {
    private double _const_om_cl0 = 123.123;
    private double _const_om_sl0 = 0.0;
    private double _const_om_ca0 = 0.0;
    private double _const_om_sa0 = 0.0;
    private SRF_OM_Params _params = new SRF_OM_Params();

    public SRF_ObliqueMercatorSpherical(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_OM_Params params) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_OBLIQUE_MERCATOR_SPHERICAL;
        this._myCsCode = SRM_CS_Code.CSCOD_OBLIQUE_MERCATOR_SPHERICAL;
        this._orm = orm;
        this._rt = rt;
        this._params.longitude1 = params.longitude1;
        this._params.latitude1 = params.latitude1;
        this._params.longitude2 = params.longitude2;
        this._params.latitude2 = params.latitude2;
        this._params.central_scale = params.central_scale;
        this._params.false_easting = params.false_easting;
        this._params.false_northing = params.false_northing;
        SrfCheck.forObliqueMercatorSpherical(this._orm, this._rt, this._params);
    }

    public SRF_ObliqueMercatorSpherical(SRM_ORM_Code orm, SRM_RT_Code rt, double longitude1, double latitude1, double longitude2, double latitude2, double central_scale, double false_easting, double false_northing) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_OBLIQUE_MERCATOR_SPHERICAL;
        this._myCsCode = SRM_CS_Code.CSCOD_OBLIQUE_MERCATOR_SPHERICAL;
        this._orm = orm;
        this._rt = rt;
        this._params.longitude1 = longitude1;
        this._params.latitude1 = latitude1;
        this._params.longitude2 = longitude2;
        this._params.latitude2 = latitude2;
        this._params.central_scale = central_scale;
        this._params.false_easting = false_easting;
        this._params.false_northing = false_northing;
        SrfCheck.forObliqueMercatorSpherical(this._orm, this._rt, this._params);
    }

    public Coord3D createCoordinate3D() {
        return new Coord3D_ObliqueMercatorSpherical(this, Double.NaN, Double.NaN, Double.NaN);
    }

    public Coord3D createCoordinate3D(double coord_comp1, double coord_comp2, double coord_comp3) {
        return new Coord3D_ObliqueMercatorSpherical(this, coord_comp1, coord_comp2, coord_comp3);
    }

    public CoordSurf createSurfaceCoordinate() {
        return new CoordSurf_ObliqueMercatorSpherical(this, Double.NaN, Double.NaN);
    }

    public CoordSurf createSurfaceCoordinate(double coord_comp1, double coord_comp2) {
        return new CoordSurf_ObliqueMercatorSpherical(this, coord_comp1, coord_comp2);
    }

    public SRF_OM_Params getSRFParameters() {
        SRF_OM_Params retParams = new SRF_OM_Params();
        retParams.longitude1 = this._params.longitude1;
        retParams.latitude1 = this._params.latitude1;
        retParams.longitude2 = this._params.longitude2;
        retParams.latitude2 = this._params.latitude2;
        retParams.central_scale = this._params.central_scale;
        retParams.false_easting = this._params.false_easting;
        retParams.false_northing = this._params.false_northing;
        return retParams;
    }

    public double get_longitude1() {
        return this._params.longitude1;
    }

    public double get_latitude1() {
        return this._params.latitude1;
    }

    public double get_longitude2() {
        return this._params.longitude2;
    }

    public double get_latitude2() {
        return this._params.latitude2;
    }

    public double get_central_scale() {
        return this._params.central_scale;
    }

    public double get_false_easting() {
        return this._params.false_easting;
    }

    public double get_false_northing() {
        return this._params.false_northing;
    }

    public CoordSurf getAssociatedSurfaceCoordinate(Coord3D coord) throws SrmException {
        if (coord.getSRF() != this) {
            throw new SrmException(5, new String("getAssociatedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new CoordSurf_ObliqueMercatorSpherical(this, coord.getValues()[0], coord.getValues()[1]);
    }

    public Coord3D getPromotedSurfaceCoordinate(CoordSurf surf_coord) throws SrmException {
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, new String("getPromotedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new Coord3D_ObliqueMercatorSpherical(this, surf_coord.getValues()[0], surf_coord.getValues()[1], 0.0);
    }

    public boolean isEqual(BaseSRF srf) {
        return srf != null && srf instanceof SRF_ObliqueMercatorSpherical && this._orm == srf.getOrm() && this._rt == srf.getRt() && this._params.isEqual(((SRF_ObliqueMercatorSpherical)srf).getSRFParameters());
    }

    public String toString() {
        String retString = new String();
        retString = retString + super.toString() + "\n";
        retString = retString + this._params;
        return retString;
    }

    private void setOmConst() {
        double sin_lat1 = 0.0;
        double cos_lat1 = 0.0;
        double sin_lat2 = 0.0;
        double cos_lat2 = 0.0;
        double sin_lon1 = 0.0;
        double cos_lon1 = 0.0;
        double sin_lon2 = 0.0;
        double cos_lon2 = 0.0;
        double lambda_0 = 0.0;
        double sin_lambda_1_minus_lambda_0 = 0.0;
        double sin_lambda_2_minus_lambda_0 = 0.0;
        double p0 = 0.0;
        double q0 = 0.0;
        double alpha_0 = 0.0;
        sin_lat1 = Math.sin(this.get_latitude1());
        cos_lat1 = Math.cos(this.get_latitude1());
        sin_lat2 = Math.sin(this.get_latitude2());
        cos_lat2 = Math.cos(this.get_latitude2());
        sin_lon1 = Math.sin(this.get_longitude1());
        cos_lon1 = Math.cos(this.get_longitude1());
        sin_lon2 = Math.sin(this.get_longitude2());
        cos_lon2 = Math.cos(this.get_longitude2());
        p0 = cos_lat1 * sin_lat2 * sin_lon1 - sin_lat1 * cos_lat2 * sin_lon2;
        q0 = cos_lat1 * sin_lat2 * cos_lon1 - sin_lat1 * cos_lat2 * cos_lon2;
        lambda_0 = Math.atan2(p0, q0);
        this._const_om_cl0 = Math.cos(lambda_0);
        this._const_om_sl0 = Math.sin(lambda_0);
        sin_lambda_1_minus_lambda_0 = sin_lon1 * this._const_om_cl0 - cos_lon1 * this._const_om_sl0;
        sin_lambda_2_minus_lambda_0 = sin_lon2 * this._const_om_cl0 - cos_lon2 * this._const_om_sl0;
        alpha_0 = Math.abs(sin_lambda_1_minus_lambda_0) >= Math.abs(sin_lambda_2_minus_lambda_0) ? Math.atan(sin_lat1 / (cos_lat1 * sin_lambda_1_minus_lambda_0)) : Math.atan(sin_lat2 / (cos_lat2 * sin_lambda_2_minus_lambda_0));
        this._const_om_sa0 = Math.sin(alpha_0);
        this._const_om_ca0 = Math.cos(alpha_0);
    }

    protected double comCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        double sin_lon = Math.sin(cd_coord[0]);
        double cos_lon = Math.cos(cd_coord[0]);
        double sin_lat = Math.sin(cd_coord[1]);
        double cos_lat = Math.cos(cd_coord[1]);
        if (this._const_om_cl0 == 123.123) {
            this.setOmConst();
        }
        double sin_lambda_minus_lambda_0 = sin_lon * this._const_om_cl0 - cos_lon * this._const_om_sl0;
        double cos_lambda_minus_lambda_0 = cos_lon * this._const_om_cl0 + sin_lon * this._const_om_sl0;
        return Math.atan2(-this._const_om_sa0 * cos_lambda_minus_lambda_0, this._const_om_ca0 * cos_lat + this._const_om_sa0 * sin_lat * sin_lambda_minus_lambda_0);
    }

    protected double pointScaleCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        double sin_lat = Math.sin(cd_coord[1]);
        double cos_lat = Math.cos(cd_coord[1]);
        double sin_lon = Math.sin(cd_coord[0]);
        double cos_lon = Math.cos(cd_coord[0]);
        if (this._const_om_cl0 == 123.123) {
            this.setOmConst();
        }
        double A = this._const_om_ca0 * sin_lat - this._const_om_sa0 * cos_lat * (sin_lon * this._const_om_cl0 - cos_lon * this._const_om_sl0);
        return this.get_central_scale() / Math.sqrt(1.0 - A * A);
    }
}

