/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_MapProjection;
import SRM.Const;
import SRM.Coord3D;
import SRM.Coord3D_PolarStereographic;
import SRM.CoordSurf;
import SRM.CoordSurf_PolarStereographic;
import SRM.OrmData;
import SRM.SRF_PS_Params;
import SRM.SRM_CS_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_Polar_Aspect;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrfCheck;
import SRM.SrmException;

public class SRF_PolarStereographic
extends BaseSRF_MapProjection {
    private double _ps_TwoAk0E = 123.123;
    private SRF_PS_Params _params = new SRF_PS_Params();

    public SRF_PolarStereographic(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_PS_Params params) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_POLAR_STEREOGRAPHIC;
        this._myCsCode = SRM_CS_Code.CSCOD_POLAR_STEREOGRAPHIC;
        this._orm = orm;
        this._rt = rt;
        this._params.polar_aspect = params.polar_aspect;
        this._params.origin_longitude = params.origin_longitude;
        this._params.central_scale = params.central_scale;
        this._params.false_easting = params.false_easting;
        this._params.false_northing = params.false_northing;
        SrfCheck.forPolarStereographic(this._orm, this._rt, this._params);
    }

    public SRF_PolarStereographic(SRM_ORM_Code orm, SRM_RT_Code rt, SRM_Polar_Aspect polar_aspect, double origin_longitude, double central_scale, double false_easting, double false_northing) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_POLAR_STEREOGRAPHIC;
        this._myCsCode = SRM_CS_Code.CSCOD_POLAR_STEREOGRAPHIC;
        this._orm = orm;
        this._rt = rt;
        this._params.polar_aspect = polar_aspect;
        this._params.origin_longitude = origin_longitude;
        this._params.central_scale = central_scale;
        this._params.false_easting = false_easting;
        this._params.false_northing = false_northing;
        SrfCheck.forPolarStereographic(this._orm, this._rt, this._params);
    }

    public Coord3D createCoordinate3D() {
        return new Coord3D_PolarStereographic(this, Double.NaN, Double.NaN, Double.NaN);
    }

    public Coord3D createCoordinate3D(double coord_comp1, double coord_comp2, double coord_comp3) {
        return new Coord3D_PolarStereographic(this, coord_comp1, coord_comp2, coord_comp3);
    }

    public CoordSurf createSurfaceCoordinate() {
        return new CoordSurf_PolarStereographic(this, Double.NaN, Double.NaN);
    }

    public CoordSurf createSurfaceCoordinate(double coord_comp1, double coord_comp2) {
        return new CoordSurf_PolarStereographic(this, coord_comp1, coord_comp2);
    }

    public SRF_PS_Params getSRFParameters() {
        SRF_PS_Params retParams = new SRF_PS_Params();
        retParams.polar_aspect = this._params.polar_aspect;
        retParams.origin_longitude = this._params.origin_longitude;
        retParams.central_scale = this._params.central_scale;
        retParams.false_easting = this._params.false_easting;
        retParams.false_northing = this._params.false_northing;
        return retParams;
    }

    public SRM_Polar_Aspect get_polar_aspect() {
        return this._params.polar_aspect;
    }

    public double get_origin_longitude() {
        return this._params.origin_longitude;
    }

    public double get_central_scale() {
        return this._params.central_scale;
    }

    public double get_false_easting() {
        return this._params.false_easting;
    }

    public double get_false_northing() {
        return this._params.false_northing;
    }

    public CoordSurf getAssociatedSurfaceCoordinate(Coord3D coord) throws SrmException {
        if (coord.getSRF() != this) {
            throw new SrmException(5, new String("getAssociatedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new CoordSurf_PolarStereographic(this, coord.getValues()[0], coord.getValues()[1]);
    }

    public Coord3D getPromotedSurfaceCoordinate(CoordSurf surf_coord) throws SrmException {
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, new String("getPromotedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new Coord3D_PolarStereographic(this, surf_coord.getValues()[0], surf_coord.getValues()[1], 0.0);
    }

    public boolean isEqual(BaseSRF srf) {
        return srf != null && srf instanceof SRF_PolarStereographic && this._orm == srf.getOrm() && this._rt == srf.getRt() && this._params.isEqual(((SRF_PolarStereographic)srf).getSRFParameters());
    }

    public String toString() {
        String retString = new String();
        retString = retString + super.toString() + "\n";
        retString = retString + this._params;
        return retString;
    }

    protected double comCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        double ret_com = 0.0;
        double lambda_star = Const.getLambdaStar(cd_coord[0], this.get_origin_longitude());
        ret_com = this.get_polar_aspect() == SRM_Polar_Aspect.PLRASP_NORTH ? lambda_star : -lambda_star;
        return ret_com;
    }

    protected double pointScaleCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        if (this._ps_TwoAk0E == 123.123) {
            double E = e_constants.A / e_constants.B * Math.pow((1.0 - e_constants.Eps) / (1.0 + e_constants.Eps), e_constants.EpsH);
            this._ps_TwoAk0E = 2.0 * e_constants.A * this.get_central_scale() * E;
        }
        double abs_phi = Math.abs(cd_coord[1]);
        double sphi = Math.sin(cd_coord[1]);
        double cphi = Math.cos(cd_coord[1]);
        double eps_sabs_phi = e_constants.Eps * Math.sin(abs_phi);
        double tphi = Math.tan(0.7853981633974483 - abs_phi * 0.5) * Math.pow((1.0 + eps_sabs_phi) / (1.0 - eps_sabs_phi), e_constants.EpsH);
        double Rn = Const.computeRnFast(sphi * sphi, e_constants);
        return this._ps_TwoAk0E * tphi / (Rn * cphi);
    }
}

