/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Const;

public class SRM_Axis_Angle_Params {
    double[] axis = new double[]{1.0, 0.0, 0.0};
    double angle = 0.0;

    public SRM_Axis_Angle_Params() {
    }

    public SRM_Axis_Angle_Params(double[] axis, double angle) {
        System.arraycopy(axis, 0, this.axis, 0, 3);
        this.angle = angle;
    }

    public SRM_Axis_Angle_Params(SRM_Axis_Angle_Params params) {
        System.arraycopy(params.axis, 0, this.axis, 0, 3);
        this.angle = params.angle;
    }

    public static final boolean isEquiv(SRM_Axis_Angle_Params a, SRM_Axis_Angle_Params b, double tolerance) {
        if (Const.areEqualAngles(a.angle, 0.0, tolerance) && Const.areEqualAngles(b.angle, 0.0, tolerance) || Const.areEqualAngles(a.angle, b.angle, tolerance) && Const.isEqual(a.axis, b.axis, tolerance)) {
            return true;
        }
        double[] negative_axis2 = new double[]{-b.axis[0], -b.axis[1], -b.axis[2]};
        return Const.areEqualAngles(a.angle, -b.angle, tolerance) && Const.isEqual(a.axis, negative_axis2, tolerance);
    }

    public boolean valid() {
        return Const.isUnit(this.axis) && Const.inFourPiRange(this.angle);
    }

    public String toString() {
        return "[ [" + this.axis[0] + ", " + this.axis[1] + ", " + this.axis[2] + "], " + this.angle + " ]";
    }
}

